/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.shaders.graph;

import com.badlogic.gdx.graphics.g3d.shaders.graph.ShaderDefine;
import com.badlogic.gdx.graphics.g3d.shaders.graph.ShaderInput;
import com.badlogic.gdx.graphics.g3d.shaders.graph.ShaderNode;
import com.badlogic.gdx.graphics.g3d.shaders.graph.ShaderOutput;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class ShaderNodeBuilder {
    private String name;
    private ShaderNode.ShaderNodeType type;
    private Array<ShaderInput> inputs = new Array();
    private Array<ShaderOutput> outputs = new Array();
    private Array<String> requires = new Array();
    private Array<ShaderDefine> defines = new Array();
    private String code;

    public ShaderNodeBuilder name(String name) {
        if (name == null) {
            throw new GdxRuntimeException("name must not be null");
        }
        if (name.length() == 0) {
            throw new GdxRuntimeException("name must not be empty string");
        }
        this.name = name;
        return this;
    }

    public ShaderNodeBuilder type(ShaderNode.ShaderNodeType type) {
        if (type == null) {
            throw new GdxRuntimeException("type must not be null");
        }
        this.type = type;
        return this;
    }

    public ShaderNodeBuilder define(String define, int value) {
        if (define == null) {
            throw new GdxRuntimeException("define must not be null");
        }
        if (define.length() == 0) {
            throw new GdxRuntimeException("define must not be zero");
        }
        this.defines.add(new ShaderDefine(define, value));
        return this;
    }

    public ShaderNodeBuilder require(String require) {
        if (require == null) {
            throw new GdxRuntimeException("requires must not be null");
        }
        if (require.length() == 0) {
            throw new GdxRuntimeException("requires must not be zero");
        }
        this.requires.add(require);
        return this;
    }

    public ShaderNodeBuilder input(String name, String type) {
        return this.input(name, type, ShaderInput.ShaderInputQualifier.Local);
    }

    public ShaderNodeBuilder input(String name, String type, ShaderInput.ShaderInputQualifier qualifier) {
        if (name == null) {
            throw new GdxRuntimeException("name must not be null");
        }
        if (name.length() == 0) {
            throw new GdxRuntimeException("name must not be empty string");
        }
        if (type == null) {
            throw new GdxRuntimeException("type must not be null");
        }
        if (type.length() == 0) {
            throw new GdxRuntimeException("type must not be empty string");
        }
        if (qualifier == null) {
            throw new GdxRuntimeException("qualifier must not be null");
        }
        for (ShaderInput i : this.inputs) {
            if (!i.getName().equals(name)) continue;
            throw new GdxRuntimeException("input with name '" + i.getName() + "' already in shader node");
        }
        this.inputs.add(new ShaderInput(name, type, qualifier));
        return this;
    }

    public ShaderNodeBuilder output(String name, String type) {
        return this.output(name, type, false);
    }

    public ShaderNodeBuilder output(String name, String type, boolean isVarying) {
        if (name == null) {
            throw new GdxRuntimeException("name must not be null");
        }
        if (name.length() == 0) {
            throw new GdxRuntimeException("name must not be empty string");
        }
        if (type == null) {
            throw new GdxRuntimeException("type must not be null");
        }
        if (type.length() == 0) {
            throw new GdxRuntimeException("type must not be empty string");
        }
        for (ShaderOutput o : this.outputs) {
            if (!o.getName().equals(name)) continue;
            throw new GdxRuntimeException("output with name '" + o.getName() + "' already in shader node");
        }
        this.outputs.add(new ShaderOutput(name, type, isVarying));
        return this;
    }

    public ShaderNodeBuilder code(String code) {
        if (code == null) {
            throw new GdxRuntimeException("code must not be null");
        }
        if (code.length() == 0) {
            throw new GdxRuntimeException("code must not be empty string");
        }
        this.code = code;
        return this;
    }

    public ShaderNode build() {
        if (this.name == null) {
            throw new GdxRuntimeException("name is not set");
        }
        if (this.type == null) {
            throw new GdxRuntimeException("type is not set");
        }
        if (this.code == null) {
            throw new GdxRuntimeException("code is not set");
        }
        if (this.inputs.size == 0 && this.outputs.size == 0) {
            throw new GdxRuntimeException("node has neither inputs nor outputs");
        }
        return new ShaderNode(this.name, this.type, new Array<String>(this.requires), new Array<ShaderDefine>(this.defines), new Array<ShaderInput>(this.inputs), new Array<ShaderOutput>(this.outputs), this.code);
    }

    public void clear() {
        this.name = null;
        this.type = null;
        this.code = null;
        this.inputs.clear();
        this.outputs.clear();
        this.requires.clear();
        this.defines.clear();
    }
}

