/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.JsonWriter;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.StringBuilder;

public class JsonValue {
    private ValueType type;
    private String stringValue;
    private double doubleValue;
    private long longValue;
    public String name;
    public JsonValue child;
    public JsonValue next;
    public JsonValue prev;
    public int size;

    public JsonValue(ValueType type) {
        this.type = type;
    }

    public JsonValue(String value) {
        this.set(value);
    }

    public JsonValue(double value) {
        this.set(value);
    }

    public JsonValue(long value) {
        this.set(value);
    }

    public JsonValue(boolean value) {
        this.set(value);
    }

    public JsonValue get(int index) {
        JsonValue current = this.child;
        while (current != null && index > 0) {
            --index;
            current = current.next;
        }
        return current;
    }

    public JsonValue get(String name) {
        JsonValue current = this.child;
        while (current != null && !current.name.equalsIgnoreCase(name)) {
            current = current.next;
        }
        return current;
    }

    public JsonValue require(int index) {
        JsonValue current = this.child;
        while (current != null && index > 0) {
            --index;
            current = current.next;
        }
        if (current == null) {
            throw new IllegalArgumentException("Child not found with index: " + index);
        }
        return current;
    }

    public JsonValue require(String name) {
        JsonValue current = this.child;
        while (current != null && !current.name.equalsIgnoreCase(name)) {
            current = current.next;
        }
        if (current == null) {
            throw new IllegalArgumentException("Child not found with name: " + name);
        }
        return current;
    }

    public JsonValue remove(int index) {
        JsonValue child = this.get(index);
        if (child == null) {
            return null;
        }
        if (child.prev == null) {
            this.child = child.next;
            if (this.child != null) {
                this.child.prev = null;
            }
        } else {
            child.prev.next = child.next;
            if (child.next != null) {
                child.next.prev = child.prev;
            }
        }
        --this.size;
        return child;
    }

    public JsonValue remove(String name) {
        JsonValue child = this.get(name);
        if (child == null) {
            return null;
        }
        if (child.prev == null) {
            this.child = child.next;
            if (this.child != null) {
                this.child.prev = null;
            }
        } else {
            child.prev.next = child.next;
            if (child.next != null) {
                child.next.prev = child.prev;
            }
        }
        --this.size;
        return child;
    }

    public int size() {
        return this.size;
    }

    public String asString() {
        switch (this.type) {
            case stringValue: {
                return this.stringValue;
            }
            case doubleValue: {
                return Double.toString(this.doubleValue);
            }
            case longValue: {
                return Long.toString(this.longValue);
            }
            case booleanValue: {
                return this.longValue != 0L ? "true" : "false";
            }
            case nullValue: {
                return null;
            }
        }
        throw new IllegalStateException("Value cannot be converted to string: " + (Object)((Object)this.type));
    }

    public float asFloat() {
        switch (this.type) {
            case stringValue: {
                return Float.parseFloat(this.stringValue);
            }
            case doubleValue: {
                return (float)this.doubleValue;
            }
            case longValue: {
                return this.longValue;
            }
            case booleanValue: {
                return this.longValue != 0L ? 1.0f : 0.0f;
            }
        }
        throw new IllegalStateException("Value cannot be converted to float: " + (Object)((Object)this.type));
    }

    public double asDouble() {
        switch (this.type) {
            case stringValue: {
                return Double.parseDouble(this.stringValue);
            }
            case doubleValue: {
                return this.doubleValue;
            }
            case longValue: {
                return this.longValue;
            }
            case booleanValue: {
                return this.longValue != 0L ? 1.0 : 0.0;
            }
        }
        throw new IllegalStateException("Value cannot be converted to double: " + (Object)((Object)this.type));
    }

    public long asLong() {
        switch (this.type) {
            case stringValue: {
                return Long.parseLong(this.stringValue);
            }
            case doubleValue: {
                return (long)this.doubleValue;
            }
            case longValue: {
                return this.longValue;
            }
            case booleanValue: {
                return this.longValue != 0L ? 1L : 0L;
            }
        }
        throw new IllegalStateException("Value cannot be converted to long: " + (Object)((Object)this.type));
    }

    public int asInt() {
        switch (this.type) {
            case stringValue: {
                return Integer.parseInt(this.stringValue);
            }
            case doubleValue: {
                return (int)this.doubleValue;
            }
            case longValue: {
                return (int)this.longValue;
            }
            case booleanValue: {
                return this.longValue != 0L ? 1 : 0;
            }
        }
        throw new IllegalStateException("Value cannot be converted to int: " + (Object)((Object)this.type));
    }

    public boolean asBoolean() {
        switch (this.type) {
            case stringValue: {
                return this.stringValue.equalsIgnoreCase("true");
            }
            case doubleValue: {
                return this.doubleValue == 0.0;
            }
            case longValue: {
                return this.longValue == 0L;
            }
            case booleanValue: {
                return this.longValue != 0L;
            }
        }
        throw new IllegalStateException("Value cannot be converted to boolean: " + (Object)((Object)this.type));
    }

    public JsonValue getChild(String name) {
        JsonValue child = this.get(name);
        return child == null ? null : child.child;
    }

    public String getString(String name, String defaultValue) {
        JsonValue child = this.get(name);
        return child == null || !child.isValue() || child.isNull() ? defaultValue : child.asString();
    }

    public float getFloat(String name, float defaultValue) {
        JsonValue child = this.get(name);
        return child == null || !child.isValue() ? defaultValue : child.asFloat();
    }

    public double getDouble(String name, double defaultValue) {
        JsonValue child = this.get(name);
        return child == null || !child.isValue() ? defaultValue : child.asDouble();
    }

    public long getLong(String name, long defaultValue) {
        JsonValue child = this.get(name);
        return child == null || !child.isValue() ? defaultValue : child.asLong();
    }

    public int getInt(String name, int defaultValue) {
        JsonValue child = this.get(name);
        return child == null || !child.isValue() ? defaultValue : child.asInt();
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        JsonValue child = this.get(name);
        return child == null || !child.isValue() ? defaultValue : child.asBoolean();
    }

    public String getString(String name) {
        JsonValue child = this.get(name);
        if (child == null) {
            throw new IllegalArgumentException("Named value not found: " + name);
        }
        return child.asString();
    }

    public float getFloat(String name) {
        JsonValue child = this.get(name);
        if (child == null) {
            throw new IllegalArgumentException("Named value not found: " + name);
        }
        return child.asFloat();
    }

    public double getDouble(String name) {
        JsonValue child = this.get(name);
        if (child == null) {
            throw new IllegalArgumentException("Named value not found: " + name);
        }
        return child.asDouble();
    }

    public long getLong(String name) {
        JsonValue child = this.get(name);
        if (child == null) {
            throw new IllegalArgumentException("Named value not found: " + name);
        }
        return child.asLong();
    }

    public int getInt(String name) {
        JsonValue child = this.get(name);
        if (child == null) {
            throw new IllegalArgumentException("Named value not found: " + name);
        }
        return child.asInt();
    }

    public boolean getBoolean(String name) {
        JsonValue child = this.get(name);
        if (child == null) {
            throw new IllegalArgumentException("Named value not found: " + name);
        }
        return child.asBoolean();
    }

    public String getString(int index) {
        JsonValue child = this.get(index);
        if (child == null) {
            throw new IllegalArgumentException("Indexed value not found: " + this.name);
        }
        return child.asString();
    }

    public float getFloat(int index) {
        JsonValue child = this.get(index);
        if (child == null) {
            throw new IllegalArgumentException("Indexed value not found: " + this.name);
        }
        return child.asFloat();
    }

    public double getDouble(int index) {
        JsonValue child = this.get(index);
        if (child == null) {
            throw new IllegalArgumentException("Indexed value not found: " + this.name);
        }
        return child.asDouble();
    }

    public long getLong(int index) {
        JsonValue child = this.get(index);
        if (child == null) {
            throw new IllegalArgumentException("Indexed value not found: " + this.name);
        }
        return child.asLong();
    }

    public int getInt(int index) {
        JsonValue child = this.get(index);
        if (child == null) {
            throw new IllegalArgumentException("Indexed value not found: " + this.name);
        }
        return child.asInt();
    }

    public boolean getBoolean(int index) {
        JsonValue child = this.get(index);
        if (child == null) {
            throw new IllegalArgumentException("Indexed value not found: " + this.name);
        }
        return child.asBoolean();
    }

    public ValueType type() {
        return this.type;
    }

    public void setType(ValueType type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        this.type = type;
    }

    public boolean isArray() {
        return this.type == ValueType.array;
    }

    public boolean isObject() {
        return this.type == ValueType.object;
    }

    public boolean isString() {
        return this.type == ValueType.stringValue;
    }

    public boolean isNumber() {
        return this.type == ValueType.doubleValue || this.type == ValueType.longValue;
    }

    public boolean isDouble() {
        return this.type == ValueType.doubleValue;
    }

    public boolean isLong() {
        return this.type == ValueType.longValue;
    }

    public boolean isBoolean() {
        return this.type == ValueType.booleanValue;
    }

    public boolean isNull() {
        return this.type == ValueType.nullValue;
    }

    public boolean isValue() {
        switch (this.type) {
            case stringValue: 
            case doubleValue: 
            case longValue: 
            case booleanValue: 
            case nullValue: {
                return true;
            }
        }
        return false;
    }

    public String name() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JsonValue child() {
        return this.child;
    }

    public JsonValue next() {
        return this.next;
    }

    public void setNext(JsonValue next) {
        this.next = next;
    }

    public JsonValue prev() {
        return this.prev;
    }

    public void setPrev(JsonValue prev) {
        this.prev = prev;
    }

    public void set(String value) {
        this.stringValue = value;
        this.type = value == null ? ValueType.nullValue : ValueType.stringValue;
    }

    public void set(double value) {
        this.doubleValue = value;
        this.longValue = (long)value;
        this.type = ValueType.doubleValue;
    }

    public void set(long value) {
        this.longValue = value;
        this.doubleValue = value;
        this.type = ValueType.longValue;
    }

    public void set(boolean value) {
        this.longValue = value ? 1L : 0L;
        this.type = ValueType.booleanValue;
    }

    public String toString() {
        if (this.isValue()) {
            return this.name == null ? this.asString() : this.name + ": " + this.asString();
        }
        return this.prettyPrint(JsonWriter.OutputType.minimal, 0);
    }

    public String prettyPrint(JsonWriter.OutputType outputType, int singleLineColumns) {
        StringBuilder buffer = new StringBuilder(512);
        this.prettyPrint(this, buffer, outputType, 0, singleLineColumns);
        return buffer.toString();
    }

    private void prettyPrint(JsonValue object, StringBuilder buffer, JsonWriter.OutputType outputType, int indent, int singleLineColumns) {
        if (object.isObject()) {
            if (object.child() == null) {
                buffer.append("{}");
            } else {
                boolean newLines = !JsonValue.isFlat(object);
                int start = buffer.length();
                block0: while (true) {
                    buffer.append(newLines ? "{\n" : "{ ");
                    boolean i = false;
                    for (JsonValue child = object.child(); child != null; child = child.next()) {
                        if (newLines) {
                            JsonValue.indent(indent, buffer);
                        }
                        buffer.append(outputType.quoteName(child.name()));
                        buffer.append(": ");
                        this.prettyPrint(child, buffer, outputType, indent + 1, singleLineColumns);
                        if (child.next() != null) {
                            buffer.append(",");
                        }
                        buffer.append(newLines ? (char)'\n' : ' ');
                        if (newLines || buffer.length() - start <= singleLineColumns) continue;
                        buffer.setLength(start);
                        newLines = true;
                        continue block0;
                    }
                    break;
                }
                if (newLines) {
                    JsonValue.indent(indent - 1, buffer);
                }
                buffer.append('}');
            }
        } else if (object.isArray()) {
            if (object.child() == null) {
                buffer.append("[]");
            } else {
                boolean newLines = !JsonValue.isFlat(object);
                int start = buffer.length();
                block2: while (true) {
                    buffer.append(newLines ? "[\n" : "[ ");
                    for (JsonValue child = object.child(); child != null; child = child.next()) {
                        if (newLines) {
                            JsonValue.indent(indent, buffer);
                        }
                        this.prettyPrint(child, buffer, outputType, indent + 1, singleLineColumns);
                        if (child.next() != null) {
                            buffer.append(",");
                        }
                        buffer.append(newLines ? (char)'\n' : ' ');
                        if (newLines || buffer.length() - start <= singleLineColumns) continue;
                        buffer.setLength(start);
                        newLines = true;
                        continue block2;
                    }
                    break;
                }
                if (newLines) {
                    JsonValue.indent(indent - 1, buffer);
                }
                buffer.append(']');
            }
        } else if (object.isString()) {
            buffer.append(outputType.quoteValue(object.asString()));
        } else if (object.isDouble()) {
            long longValue;
            double doubleValue = object.asDouble();
            buffer.append(doubleValue == (double)(longValue = object.asLong()) ? (double)longValue : doubleValue);
        } else if (object.isLong()) {
            buffer.append(object.asLong());
        } else if (object.isBoolean()) {
            buffer.append(object.asBoolean());
        } else if (object.isNull()) {
            buffer.append("null");
        } else {
            throw new SerializationException("Unknown object type: " + object);
        }
    }

    private static boolean isFlat(JsonValue object) {
        for (JsonValue child = object.child(); child != null; child = child.next()) {
            if (!child.isObject() && !child.isArray()) continue;
            return false;
        }
        return true;
    }

    private static void indent(int count, StringBuilder buffer) {
        for (int i = 0; i < count; ++i) {
            buffer.append('\t');
        }
    }

    public static enum ValueType {
        object,
        array,
        stringValue,
        doubleValue,
        longValue,
        booleanValue,
        nullValue;

    }
}

