/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.BaseJsonReader;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.SerializationException;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UBJsonReader
implements BaseJsonReader {
    @Override
    public JsonValue parse(InputStream input) {
        try {
            return this.parse(new DataInputStream(input));
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    @Override
    public JsonValue parse(FileHandle file) {
        try {
            return this.parse(file.read());
        }
        catch (Exception ex) {
            throw new SerializationException("Error parsing file: " + file, ex);
        }
    }

    public JsonValue parse(DataInputStream din) throws IOException {
        return this.parse(din, din.readByte());
    }

    protected JsonValue parse(DataInputStream din, byte type) throws IOException {
        if (type == 91) {
            return this.parseArray(din);
        }
        if (type == 123) {
            return this.parseObject(din);
        }
        if (type == 90) {
            return new JsonValue(JsonValue.ValueType.nullValue);
        }
        if (type == 84) {
            return new JsonValue(true);
        }
        if (type == 70) {
            return new JsonValue(false);
        }
        if (type == 66) {
            return new JsonValue(this.readUChar(din));
        }
        if (type == 105) {
            return new JsonValue(din.readShort());
        }
        if (type == 73) {
            return new JsonValue(din.readInt());
        }
        if (type == 76) {
            return new JsonValue(din.readLong());
        }
        if (type == 100) {
            return new JsonValue(din.readFloat());
        }
        if (type == 68) {
            return new JsonValue(din.readDouble());
        }
        if (type == 115 || type == 83) {
            return new JsonValue(this.parseString(din, type));
        }
        if (type == 97 || type == 65) {
            return this.parseData(din, type);
        }
        throw new GdxRuntimeException("Unrecognized data type");
    }

    protected JsonValue parseArray(DataInputStream din) throws IOException {
        JsonValue result = new JsonValue(JsonValue.ValueType.array);
        byte type = din.readByte();
        JsonValue prev = null;
        while (din.available() > 0 && type != 93) {
            JsonValue val2 = this.parse(din, type);
            if (prev != null) {
                prev.next = val2;
                ++result.size;
            } else {
                result.child = val2;
                result.size = 1;
            }
            prev = val2;
            type = din.readByte();
        }
        return result;
    }

    protected JsonValue parseObject(DataInputStream din) throws IOException {
        JsonValue result = new JsonValue(JsonValue.ValueType.object);
        byte type = din.readByte();
        JsonValue prev = null;
        while (din.available() > 0 && type != 125) {
            if (type != 115 && type != 83) {
                throw new GdxRuntimeException("Only string key are currently supported");
            }
            String key = this.parseString(din, type);
            JsonValue child = this.parse(din);
            child.setName(key);
            if (prev != null) {
                prev.next = child;
                ++result.size;
            } else {
                result.child = child;
                result.size = 1;
            }
            prev = child;
            type = din.readByte();
        }
        return result;
    }

    protected JsonValue parseData(DataInputStream din, byte blockType) throws IOException {
        byte dataType = din.readByte();
        long size = blockType == 65 ? this.readUInt(din) : (long)this.readUChar(din);
        JsonValue result = new JsonValue(JsonValue.ValueType.array);
        JsonValue prev = null;
        for (long i = 0L; i < size; ++i) {
            JsonValue val2 = this.parse(din, dataType);
            if (prev != null) {
                prev.next = val2;
                ++result.size;
            } else {
                result.child = val2;
                result.size = 1;
            }
            prev = val2;
        }
        return result;
    }

    protected String parseString(DataInputStream din, byte type) throws IOException {
        return this.readString(din, type == 115 ? (long)this.readUChar(din) : this.readUInt(din));
    }

    protected short readUChar(DataInputStream din) throws IOException {
        return (short)((short)din.readByte() & 0xFF);
    }

    protected long readUInt(DataInputStream din) throws IOException {
        return (long)din.readInt() & 0xFFFFFFFFFFFFFFFFL;
    }

    protected String readString(DataInputStream din, long size) throws IOException {
        byte[] data = new byte[(int)size];
        din.readFully(data);
        return new String(data, "UTF-8");
    }
}

