/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix3;
import com.esotericsoftware.spine.BoneData;

public class Bone {
    final BoneData data;
    final Bone parent;
    float x;
    float y;
    float rotation;
    float scaleX;
    float scaleY;
    float m00;
    float m01;
    float worldX;
    float m10;
    float m11;
    float worldY;
    float worldRotation;
    float worldScaleX;
    float worldScaleY;

    public Bone(BoneData data, Bone parent) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        this.data = data;
        this.parent = parent;
        this.setToSetupPose();
    }

    public Bone(Bone bone, Bone parent) {
        if (bone == null) {
            throw new IllegalArgumentException("bone cannot be null.");
        }
        this.parent = parent;
        this.data = bone.data;
        this.x = bone.x;
        this.y = bone.y;
        this.rotation = bone.rotation;
        this.scaleX = bone.scaleX;
        this.scaleY = bone.scaleY;
    }

    public void updateWorldTransform(boolean flipX, boolean flipY) {
        Bone parent = this.parent;
        if (parent != null) {
            this.worldX = this.x * parent.m00 + this.y * parent.m01 + parent.worldX;
            this.worldY = this.x * parent.m10 + this.y * parent.m11 + parent.worldY;
            if (this.data.inheritScale) {
                this.worldScaleX = parent.worldScaleX * this.scaleX;
                this.worldScaleY = parent.worldScaleY * this.scaleY;
            } else {
                this.worldScaleX = this.scaleX;
                this.worldScaleY = this.scaleY;
            }
            this.worldRotation = this.data.inheritRotation ? parent.worldRotation + this.rotation : this.rotation;
        } else {
            this.worldX = flipX ? -this.x : this.x;
            this.worldY = flipY ? -this.y : this.y;
            this.worldScaleX = this.scaleX;
            this.worldScaleY = this.scaleY;
            this.worldRotation = this.rotation;
        }
        float cos = MathUtils.cosDeg(this.worldRotation);
        float sin = MathUtils.sinDeg(this.worldRotation);
        this.m00 = cos * this.worldScaleX;
        this.m10 = sin * this.worldScaleX;
        this.m01 = -sin * this.worldScaleY;
        this.m11 = cos * this.worldScaleY;
        if (flipX) {
            this.m00 = -this.m00;
            this.m01 = -this.m01;
        }
        if (flipY) {
            this.m10 = -this.m10;
            this.m11 = -this.m11;
        }
    }

    public void setToSetupPose() {
        BoneData data = this.data;
        this.x = data.x;
        this.y = data.y;
        this.rotation = data.rotation;
        this.scaleX = data.scaleX;
        this.scaleY = data.scaleY;
    }

    public BoneData getData() {
        return this.data;
    }

    public Bone getParent() {
        return this.parent;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
    }

    public float getM00() {
        return this.m00;
    }

    public float getM01() {
        return this.m01;
    }

    public float getM10() {
        return this.m10;
    }

    public float getM11() {
        return this.m11;
    }

    public float getWorldX() {
        return this.worldX;
    }

    public float getWorldY() {
        return this.worldY;
    }

    public float getWorldRotation() {
        return this.worldRotation;
    }

    public float getWorldScaleX() {
        return this.worldScaleX;
    }

    public float getWorldScaleY() {
        return this.worldScaleY;
    }

    public Matrix3 getWorldTransform(Matrix3 worldTransform) {
        if (worldTransform == null) {
            throw new IllegalArgumentException("worldTransform cannot be null.");
        }
        float[] val2 = worldTransform.val;
        if (this.data.inheritRotation) {
            val2[0] = this.m00;
            val2[3] = this.m01;
            val2[1] = this.m10;
            val2[4] = this.m11;
        } else {
            val2[0] = 1.0f;
            val2[3] = 0.0f;
            val2[1] = 0.0f;
            val2[4] = 1.0f;
        }
        val2[6] = this.worldX;
        val2[7] = this.worldY;
        val2[2] = 0.0f;
        val2[5] = 0.0f;
        val2[8] = 1.0f;
        return worldTransform;
    }

    public String toString() {
        return this.data.name;
    }
}

