/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.DataInput;
import com.badlogic.gdx.utils.SerializationException;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.attachments.AtlasAttachmentLoader;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.AttachmentLoader;
import com.esotericsoftware.spine.attachments.AttachmentType;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.RegionSequenceAttachment;
import java.io.IOException;

public class SkeletonBinary {
    public static final int TIMELINE_SCALE = 0;
    public static final int TIMELINE_ROTATE = 1;
    public static final int TIMELINE_TRANSLATE = 2;
    public static final int TIMELINE_ATTACHMENT = 3;
    public static final int TIMELINE_COLOR = 4;
    public static final int CURVE_LINEAR = 0;
    public static final int CURVE_STEPPED = 1;
    public static final int CURVE_BEZIER = 2;
    private static final Color tempColor = new Color();
    private final AttachmentLoader attachmentLoader;
    private float scale = 1.0f;

    public SkeletonBinary(TextureAtlas atlas) {
        this.attachmentLoader = new AtlasAttachmentLoader(atlas);
    }

    public SkeletonBinary(AttachmentLoader attachmentLoader) {
        this.attachmentLoader = attachmentLoader;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public SkeletonData readSkeletonData(FileHandle file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        SkeletonData skeletonData = new SkeletonData();
        skeletonData.setName(file.nameWithoutExtension());
        DataInput input = new DataInput(file.read(512));
        try {
            try {
                int i = 0;
                int n = input.readInt(true);
                while (i < n) {
                    String name = input.readString();
                    BoneData parent = null;
                    String parentName = input.readString();
                    if (parentName != null && (parent = skeletonData.findBone(parentName)) == null) {
                        throw new SerializationException("Parent bone not found: " + parentName);
                    }
                    BoneData boneData = new BoneData(name, parent);
                    boneData.x = input.readFloat() * this.scale;
                    boneData.y = input.readFloat() * this.scale;
                    boneData.scaleX = input.readFloat();
                    boneData.scaleY = input.readFloat();
                    boneData.rotation = input.readFloat();
                    boneData.length = input.readFloat() * this.scale;
                    boneData.inheritScale = input.readByte() == 1;
                    boneData.inheritRotation = input.readByte() == 1;
                    skeletonData.addBone(boneData);
                    ++i;
                }
                i = 0;
                n = input.readInt(true);
                while (i < n) {
                    String slotName = input.readString();
                    String boneName = input.readString();
                    BoneData boneData = skeletonData.findBone(boneName);
                    if (boneData == null) {
                        throw new SerializationException("Bone not found: " + boneName);
                    }
                    SlotData slotData = new SlotData(slotName, boneData);
                    Color.rgba8888ToColor(slotData.getColor(), input.readInt());
                    slotData.setAttachmentName(input.readString());
                    slotData.additiveBlending = input.readByte() == 1;
                    skeletonData.addSlot(slotData);
                    ++i;
                }
                Skin defaultSkin = this.readSkin(input, "default");
                if (defaultSkin != null) {
                    skeletonData.setDefaultSkin(defaultSkin);
                    skeletonData.addSkin(defaultSkin);
                }
                int i2 = 0;
                int n2 = input.readInt(true);
                while (i2 < n2) {
                    skeletonData.addSkin(this.readSkin(input, input.readString()));
                    ++i2;
                }
                i2 = 0;
                n2 = input.readInt(true);
                while (i2 < n2) {
                    this.readAnimation(input.readString(), input, skeletonData);
                    ++i2;
                }
            }
            catch (IOException ex) {
                throw new SerializationException("Error reading skeleton file.", ex);
            }
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        skeletonData.bones.shrink();
        skeletonData.slots.shrink();
        skeletonData.skins.shrink();
        return skeletonData;
    }

    private Skin readSkin(DataInput input, String skinName) throws IOException {
        int slotCount = input.readInt(true);
        if (slotCount == 0) {
            return null;
        }
        Skin skin = new Skin(skinName);
        int i = 0;
        while (i < slotCount) {
            int slotIndex = input.readInt(true);
            int attachmentCount = input.readInt(true);
            int ii = 0;
            while (ii < attachmentCount) {
                String name = input.readString();
                skin.addAttachment(slotIndex, name, this.readAttachment(input, skin, name));
                ++ii;
            }
            ++i;
        }
        return skin;
    }

    private Attachment readAttachment(DataInput input, Skin skin, String attachmentName) throws IOException {
        AttachmentType type;
        Attachment attachment;
        String name = input.readString();
        if (name == null) {
            name = attachmentName;
        }
        if ((attachment = this.attachmentLoader.newAttachment(skin, type = AttachmentType.values()[input.readByte()], name)) instanceof RegionSequenceAttachment) {
            RegionSequenceAttachment regionSequenceAttachment = (RegionSequenceAttachment)attachment;
            regionSequenceAttachment.setFrameTime(1.0f / input.readFloat());
            regionSequenceAttachment.setMode(RegionSequenceAttachment.Mode.values()[input.readInt(true)]);
        }
        if (attachment instanceof RegionAttachment) {
            RegionAttachment regionAttachment = (RegionAttachment)attachment;
            regionAttachment.setX(input.readFloat() * this.scale);
            regionAttachment.setY(input.readFloat() * this.scale);
            regionAttachment.setScaleX(input.readFloat());
            regionAttachment.setScaleY(input.readFloat());
            regionAttachment.setRotation(input.readFloat());
            regionAttachment.setWidth(input.readFloat() * this.scale);
            regionAttachment.setHeight(input.readFloat() * this.scale);
            regionAttachment.updateOffset();
        }
        return attachment;
    }

    private void readAnimation(String name, DataInput input, SkeletonData skeletonData) {
        Array<Animation.Timeline> timelines = new Array<Animation.Timeline>();
        float duration = 0.0f;
        try {
            int frameIndex;
            int boneCount = input.readInt(true);
            int i = 0;
            while (i < boneCount) {
                String boneName = input.readString();
                int boneIndex = skeletonData.findBoneIndex(boneName);
                if (boneIndex == -1) {
                    throw new SerializationException("Bone not found: " + boneName);
                }
                int itemCount = input.readInt(true);
                int ii = 0;
                while (ii < itemCount) {
                    byte timelineType = input.readByte();
                    int keyCount = input.readInt(true);
                    switch (timelineType) {
                        case 1: {
                            Animation.CurveTimeline timeline = new Animation.RotateTimeline(keyCount);
                            ((Animation.RotateTimeline)timeline).setBoneIndex(boneIndex);
                            int frameIndex2 = 0;
                            while (frameIndex2 < keyCount) {
                                ((Animation.RotateTimeline)timeline).setFrame(frameIndex2, input.readFloat(), input.readFloat());
                                if (frameIndex2 < keyCount - 1) {
                                    this.readCurve(input, frameIndex2, timeline);
                                }
                                ++frameIndex2;
                            }
                            timelines.add(timeline);
                            duration = Math.max(duration, ((Animation.RotateTimeline)timeline).getFrames()[keyCount * 2 - 2]);
                            break;
                        }
                        case 0: 
                        case 2: {
                            Animation.CurveTimeline timeline;
                            float timelineScale = 1.0f;
                            if (timelineType == 0) {
                                timeline = new Animation.ScaleTimeline(keyCount);
                            } else {
                                timeline = new Animation.TranslateTimeline(keyCount);
                                timelineScale = this.scale;
                            }
                            ((Animation.TranslateTimeline)timeline).setBoneIndex(boneIndex);
                            frameIndex = 0;
                            while (frameIndex < keyCount) {
                                ((Animation.TranslateTimeline)timeline).setFrame(frameIndex, input.readFloat(), input.readFloat() * timelineScale, input.readFloat() * timelineScale);
                                if (frameIndex < keyCount - 1) {
                                    this.readCurve(input, frameIndex, timeline);
                                }
                                ++frameIndex;
                            }
                            timelines.add(timeline);
                            duration = Math.max(duration, ((Animation.TranslateTimeline)timeline).getFrames()[keyCount * 3 - 3]);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Invalid timeline type for a bone: " + timelineType + " (" + boneName + ")");
                        }
                    }
                    ++ii;
                }
                ++i;
            }
            int slotCount = input.readInt(true);
            int i2 = 0;
            while (i2 < slotCount) {
                String slotName = input.readString();
                int slotIndex = skeletonData.findSlotIndex(slotName);
                int itemCount = input.readInt(true);
                int ii = 0;
                while (ii < itemCount) {
                    byte timelineType = input.readByte();
                    int keyCount = input.readInt(true);
                    switch (timelineType) {
                        case 4: {
                            Animation.Timeline timeline = new Animation.ColorTimeline(keyCount);
                            ((Animation.ColorTimeline)timeline).setSlotIndex(slotIndex);
                            frameIndex = 0;
                            while (frameIndex < keyCount) {
                                float time = input.readFloat();
                                Color.rgba8888ToColor(tempColor, input.readInt());
                                ((Animation.ColorTimeline)timeline).setFrame(frameIndex, time, SkeletonBinary.tempColor.r, SkeletonBinary.tempColor.g, SkeletonBinary.tempColor.b, SkeletonBinary.tempColor.a);
                                if (frameIndex < keyCount - 1) {
                                    this.readCurve(input, frameIndex, (Animation.CurveTimeline)timeline);
                                }
                                ++frameIndex;
                            }
                            timelines.add(timeline);
                            duration = Math.max(duration, ((Animation.ColorTimeline)timeline).getFrames()[keyCount * 5 - 5]);
                            break;
                        }
                        case 3: {
                            Animation.Timeline timeline = new Animation.AttachmentTimeline(keyCount);
                            ((Animation.AttachmentTimeline)timeline).setSlotIndex(slotIndex);
                            frameIndex = 0;
                            while (frameIndex < keyCount) {
                                ((Animation.AttachmentTimeline)timeline).setFrame(frameIndex, input.readFloat(), input.readString());
                                ++frameIndex;
                            }
                            timelines.add(timeline);
                            duration = Math.max(duration, ((Animation.AttachmentTimeline)timeline).getFrames()[keyCount - 1]);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Invalid timeline type for a slot: " + timelineType + " (" + slotName + ")");
                        }
                    }
                    ++ii;
                }
                ++i2;
            }
        }
        catch (IOException ex) {
            throw new SerializationException("Error reading skeleton file.", ex);
        }
        timelines.shrink();
        skeletonData.addAnimation(new Animation(name, timelines, duration));
    }

    private void readCurve(DataInput input, int frameIndex, Animation.CurveTimeline timeline) throws IOException {
        switch (input.readByte()) {
            case 1: {
                timeline.setStepped(frameIndex);
                break;
            }
            case 2: {
                this.setCurve(timeline, frameIndex, input.readFloat(), input.readFloat(), input.readFloat(), input.readFloat());
            }
        }
    }

    void setCurve(Animation.CurveTimeline timeline, int frameIndex, float cx1, float cy1, float cx2, float cy2) {
        timeline.setCurve(frameIndex, cx1, cy1, cx2, cy2);
    }
}

