/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;

public class SkeletonRenderer {
    public void draw(SpriteBatch batch, Skeleton skeleton) {
        Array<Slot> drawOrder = skeleton.drawOrder;
        boolean additive = false;
        int i = 0;
        int n = drawOrder.size;
        while (i < n) {
            Slot slot = drawOrder.get(i);
            Attachment attachment = slot.attachment;
            if (attachment instanceof RegionAttachment) {
                RegionAttachment regionAttachment = (RegionAttachment)attachment;
                regionAttachment.updateVertices(slot);
                float[] vertices = regionAttachment.getVertices();
                if (slot.data.getAdditiveBlending() != additive) {
                    boolean bl = additive = !additive;
                    if (additive) {
                        batch.setBlendFunction(770, 1);
                    } else {
                        batch.setBlendFunction(770, 771);
                    }
                }
                batch.draw(regionAttachment.getRegion().getTexture(), vertices, 0, vertices.length);
            }
            ++i;
        }
        if (additive) {
            batch.setBlendFunction(770, 771);
        }
    }
}

