/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;

public class Skin {
    private static final Key lookup = new Key();
    final String name;
    final ObjectMap<Key, Attachment> attachments = new ObjectMap();

    public Skin(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        this.name = name;
    }

    public void addAttachment(int slotIndex, String name, Attachment attachment) {
        if (attachment == null) {
            throw new IllegalArgumentException("attachment cannot be null.");
        }
        Key key = new Key();
        key.set(slotIndex, name);
        this.attachments.put(key, attachment);
    }

    public Attachment getAttachment(int slotIndex, String name) {
        lookup.set(slotIndex, name);
        return this.attachments.get(lookup);
    }

    public void findNamesForSlot(int slotIndex, Array<String> names) {
        if (names == null) {
            throw new IllegalArgumentException("names cannot be null.");
        }
        for (Key key : this.attachments.keys()) {
            if (key.slotIndex != slotIndex) continue;
            names.add(key.name);
        }
    }

    public void findAttachmentsForSlot(int slotIndex, Array<Attachment> attachments) {
        if (attachments == null) {
            throw new IllegalArgumentException("attachments cannot be null.");
        }
        for (ObjectMap.Entry<Key, Attachment> entry : this.attachments.entries()) {
            if (((Key)entry.key).slotIndex != slotIndex) continue;
            attachments.add((Attachment)entry.value);
        }
    }

    public void clear() {
        this.attachments.clear();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    void attachAll(Skeleton skeleton, Skin oldSkin) {
        for (ObjectMap.Entry<Key, Attachment> entry : oldSkin.attachments.entries()) {
            Attachment attachment;
            int slotIndex = ((Key)entry.key).slotIndex;
            Slot slot = skeleton.slots.get(slotIndex);
            if (slot.attachment != entry.value || (attachment = this.getAttachment(slotIndex, ((Key)entry.key).name)) == null) continue;
            slot.setAttachment(attachment);
        }
    }

    static class Key {
        int slotIndex;
        String name;
        int hashCode;

        Key() {
        }

        public void set(int slotName, String name) {
            if (name == null) {
                throw new IllegalArgumentException("name cannot be null.");
            }
            this.slotIndex = slotName;
            this.name = name;
            this.hashCode = 31 * (31 + name.hashCode()) + this.slotIndex;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            Key other = (Key)object;
            if (this.slotIndex != other.slotIndex) {
                return false;
            }
            return this.name.equals(other.name);
        }

        public String toString() {
            return String.valueOf(this.slotIndex) + ":" + this.name;
        }
    }
}

