/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.attachments.Attachment;

public class Slot {
    final SlotData data;
    final Bone bone;
    private final Skeleton skeleton;
    final Color color;
    Attachment attachment;
    private float attachmentTime;

    Slot() {
        this.data = null;
        this.bone = null;
        this.skeleton = null;
        this.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public Slot(SlotData data, Skeleton skeleton, Bone bone) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        if (bone == null) {
            throw new IllegalArgumentException("bone cannot be null.");
        }
        this.data = data;
        this.skeleton = skeleton;
        this.bone = bone;
        this.color = new Color();
        this.setToSetupPose();
    }

    public Slot(Slot slot, Skeleton skeleton, Bone bone) {
        if (slot == null) {
            throw new IllegalArgumentException("slot cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        if (bone == null) {
            throw new IllegalArgumentException("bone cannot be null.");
        }
        this.data = slot.data;
        this.skeleton = skeleton;
        this.bone = bone;
        this.color = new Color(slot.color);
        this.attachment = slot.attachment;
        this.attachmentTime = slot.attachmentTime;
    }

    public SlotData getData() {
        return this.data;
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public Bone getBone() {
        return this.bone;
    }

    public Color getColor() {
        return this.color;
    }

    public Attachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
        this.attachmentTime = this.skeleton.time;
    }

    public void setAttachmentTime(float time) {
        this.attachmentTime = this.skeleton.time - time;
    }

    public float getAttachmentTime() {
        return this.skeleton.time - this.attachmentTime;
    }

    void setToSetupPose(int slotIndex) {
        this.color.set(this.data.color);
        this.setAttachment(this.data.attachmentName == null ? null : this.skeleton.getAttachment(slotIndex, this.data.attachmentName));
    }

    public void setToSetupPose() {
        this.setToSetupPose(this.skeleton.data.slots.indexOf(this.data, true));
    }

    public String toString() {
        return this.data.name;
    }
}

