/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.attachments;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.NumberUtils;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;

public class RegionAttachment
extends Attachment {
    private TextureRegion region;
    private float x;
    private float y;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float rotation;
    private float width;
    private float height;
    private final float[] vertices = new float[20];
    private final float[] offset = new float[8];

    public RegionAttachment(String name) {
        super(name);
    }

    public void updateOffset() {
        float width = this.getWidth();
        float height = this.getHeight();
        float localX2 = width / 2.0f;
        float localY2 = height / 2.0f;
        float localX = -localX2;
        float localY = -localY2;
        if (this.region instanceof TextureAtlas.AtlasRegion) {
            TextureAtlas.AtlasRegion region = (TextureAtlas.AtlasRegion)this.region;
            if (region.rotate) {
                localX += region.offsetX / (float)region.originalWidth * height;
                localY += region.offsetY / (float)region.originalHeight * width;
                localX2 -= ((float)region.originalWidth - region.offsetX - (float)region.packedHeight) / (float)region.originalWidth * height;
                localY2 -= ((float)region.originalHeight - region.offsetY - (float)region.packedWidth) / (float)region.originalHeight * width;
            } else {
                localX += region.offsetX / (float)region.originalWidth * width;
                localY += region.offsetY / (float)region.originalHeight * height;
                localX2 -= ((float)region.originalWidth - region.offsetX - (float)region.packedWidth) / (float)region.originalWidth * width;
                localY2 -= ((float)region.originalHeight - region.offsetY - (float)region.packedHeight) / (float)region.originalHeight * height;
            }
        }
        float scaleX = this.getScaleX();
        float scaleY = this.getScaleY();
        localX *= scaleX;
        localY *= scaleY;
        localX2 *= scaleX;
        localY2 *= scaleY;
        float rotation = this.getRotation();
        float cos = MathUtils.cosDeg(rotation);
        float sin = MathUtils.sinDeg(rotation);
        float x = this.getX();
        float y = this.getY();
        float localXCos = localX * cos + x;
        float localXSin = localX * sin;
        float localYCos = localY * cos + y;
        float localYSin = localY * sin;
        float localX2Cos = localX2 * cos + x;
        float localX2Sin = localX2 * sin;
        float localY2Cos = localY2 * cos + y;
        float localY2Sin = localY2 * sin;
        float[] offset = this.offset;
        offset[0] = localXCos - localYSin;
        offset[1] = localYCos + localXSin;
        offset[2] = localXCos - localY2Sin;
        offset[3] = localY2Cos + localXSin;
        offset[4] = localX2Cos - localY2Sin;
        offset[5] = localY2Cos + localX2Sin;
        offset[6] = localX2Cos - localYSin;
        offset[7] = localYCos + localX2Sin;
    }

    public void setRegion(TextureRegion region) {
        if (region == null) {
            throw new IllegalArgumentException("region cannot be null.");
        }
        this.region = region;
        float[] vertices = this.vertices;
        if (region instanceof TextureAtlas.AtlasRegion && ((TextureAtlas.AtlasRegion)region).rotate) {
            vertices[8] = region.getU();
            vertices[9] = region.getV2();
            vertices[13] = region.getU();
            vertices[14] = region.getV();
            vertices[18] = region.getU2();
            vertices[19] = region.getV();
            vertices[3] = region.getU2();
            vertices[4] = region.getV2();
        } else {
            vertices[3] = region.getU();
            vertices[4] = region.getV2();
            vertices[8] = region.getU();
            vertices[9] = region.getV();
            vertices[13] = region.getU2();
            vertices[14] = region.getV();
            vertices[18] = region.getU2();
            vertices[19] = region.getV2();
        }
        this.updateOffset();
    }

    public TextureRegion getRegion() {
        if (this.region == null) {
            throw new IllegalStateException("Region has not been set: " + this);
        }
        return this.region;
    }

    public void updateVertices(Slot slot) {
        Skeleton skeleton = slot.getSkeleton();
        Color skeletonColor = skeleton.getColor();
        Color slotColor = slot.getColor();
        float color = NumberUtils.intToFloatColor((int)(255.0f * skeletonColor.a * slotColor.a) << 24 | (int)(255.0f * skeletonColor.b * slotColor.b) << 16 | (int)(255.0f * skeletonColor.g * slotColor.g) << 8 | (int)(255.0f * skeletonColor.r * slotColor.r));
        float[] vertices = this.vertices;
        vertices[2] = color;
        vertices[7] = color;
        vertices[12] = color;
        vertices[17] = color;
        float[] offset = this.offset;
        Bone bone = slot.getBone();
        float x = bone.getWorldX() + skeleton.getX();
        float y = bone.getWorldY() + skeleton.getY();
        float m00 = bone.getM00();
        float m01 = bone.getM01();
        float m10 = bone.getM10();
        float m11 = bone.getM11();
        vertices[0] = offset[0] * m00 + offset[1] * m01 + x;
        vertices[1] = offset[0] * m10 + offset[1] * m11 + y;
        vertices[5] = offset[2] * m00 + offset[3] * m01 + x;
        vertices[6] = offset[2] * m10 + offset[3] * m11 + y;
        vertices[10] = offset[4] * m00 + offset[5] * m01 + x;
        vertices[11] = offset[4] * m10 + offset[5] * m11 + y;
        vertices[15] = offset[6] * m00 + offset[7] * m01 + x;
        vertices[16] = offset[6] * m10 + offset[7] * m11 + y;
    }

    public float[] getVertices() {
        return this.vertices;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }
}

