/*
 * Decompiled with CFR 0.152.
 */
package com.mcburrobit.util;

import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer20;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;

public class VLine {
    private final Array<VPoint> points;
    private final Array<VStick> sticks;
    private Vector2 p1;
    private Vector2 p2;
    private final float gravity;

    public VLine(Vector2 p1, Vector2 p2, int resolution, float gravity) {
        this.p1 = p1;
        this.p2 = p2;
        this.gravity = gravity;
        this.points = new Array(true, resolution, VPoint.class);
        this.sticks = new Array(true, resolution - 1, VStick.class);
        int i = 0;
        while (i < resolution) {
            this.points.add(new VPoint(p1.x + (float)i * (p1.dst(p2) / (float)resolution), 0.0f));
            if (i > 0) {
                this.sticks.add(new VStick(this.points.get(i - 1), this.points.get(i)));
            }
            ++i;
        }
    }

    public void update(ImmediateModeRenderer20 renderer) {
        this.points.get(0).setPos(this.p1.x, this.p1.y);
        this.points.peek().setPos(this.p2.x, this.p2.y);
        for (VPoint point : this.points) {
            point.y -= this.gravity;
            point.refresh();
        }
        for (VStick stick : this.sticks) {
            stick.contract();
        }
        for (VStick stick : this.sticks) {
            renderer.color(1.0f, 0.0f, 0.0f, 1.0f);
            renderer.vertex(stick.pointA.x, stick.pointA.y, 0.0f);
            renderer.color(1.0f, 0.0f, 0.0f, 1.0f);
            renderer.vertex(stick.pointB.x, stick.pointB.y, 0.0f);
        }
    }

    public void setP1(Vector2 p1) {
        this.p1 = p1;
    }

    public void setP2(Vector2 p2) {
        this.p2 = p2;
    }

    private class VPoint {
        public float x;
        public float y;
        private float oldX;
        private float oldY;

        public VPoint(float x, float y) {
            this.setPos(x, y);
        }

        private void setPos(float x2, float y2) {
            this.x = this.oldX = x2;
            this.y = this.oldY = y2;
        }

        public void refresh() {
            float tempX = this.x;
            float tempY = this.y;
            this.x += this.x - this.oldX;
            this.y += this.y - this.oldY;
            this.oldX = tempX;
            this.oldY = tempY;
        }
    }

    private class VStick {
        public VPoint pointA;
        public VPoint pointB;
        private final float hypotenuse;

        public VStick(VPoint a, VPoint b) {
            this.pointA = a;
            this.pointB = b;
            float dx = a.x - b.x;
            float dy = a.y - b.y;
            this.hypotenuse = (float)Math.sqrt(dx * dx + dy * dy);
        }

        public void contract() {
            float dx = this.pointB.x - this.pointA.x;
            float dy = this.pointB.y - this.pointA.y;
            float h = (float)Math.sqrt(dx * dx + dy * dy);
            float diff = this.hypotenuse - h;
            float offX = diff * dx / h * 0.5f;
            float offY = diff * dy / h * 0.5f;
            this.pointA.x -= offX;
            this.pointA.y -= offY;
            this.pointB.x += offX;
            this.pointB.y += offY;
        }
    }
}

