/*
 * Decompiled with CFR 0.152.
 */
package core;

import actors.Enemy;
import aurelienribon.tweenengine.Tween;
import aurelienribon.tweenengine.TweenManager;
import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.backends.lwjgl.LwjglApplication;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.MathUtils;
import com.mcburrobit.util.CursorTrail;
import com.mcburrobit.util.EnemyAccessor;
import com.mcburrobit.util.SpriteAccessor;
import com.mcburrobit.util.Tween2;
import screens.GameScreen;
import screens.MenuScreen;
import screens.SplashScreen;

public class OfficeRunnerGame
extends Game {
    public static final float[] INTERNAL_RES = new float[]{1280.0f, 720.0f};
    public Sound gun;
    private Sound[] pew = new Sound[6];
    public Screen menuS;
    public Screen gameS;
    public Screen gameOvS;
    public TweenManager tweenM;
    private float score;
    private float ppm;
    public Music menuMusic;
    public Music gameMusic;
    private boolean done = false;

    @Override
    public void create() {
        this.ppm = 30.0f;
        this.score = 0.0f;
        Tween.registerAccessor(Sprite.class, new SpriteAccessor());
        Tween2.registerAccessor(Enemy.class, new EnemyAccessor());
        this.tweenM = new TweenManager();
        int i = 0;
        while (i < 6) {
            this.pew[i] = Gdx.audio.newSound(Gdx.files.internal("data/hnng" + (i + 1) + ".wav"));
            ++i;
        }
        this.gun = Gdx.audio.newSound(Gdx.files.internal("data/ase2.wav"));
        this.menuMusic = Gdx.audio.newMusic(Gdx.files.internal("music/menu.mp3"));
        this.gameMusic = Gdx.audio.newMusic(Gdx.files.internal("music/game.mp3"));
        this.menuS = new MenuScreen(this);
        this.gameS = new GameScreen(this);
        this.setScreen(new SplashScreen(this));
    }

    public void pew() {
        int i = MathUtils.random(0, 5);
        long l = this.pew[i].play();
        if (l == -1L) {
            System.out.println("AUDIO: chocked.");
        }
    }

    @Override
    public void render() {
        Gdx.graphics.getGL20().glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        super.render();
    }

    public void addScore(float f) {
        this.score += f;
    }

    public float getPPM() {
        return this.ppm;
    }

    public static void main(String[] args) {
        LwjglApplicationConfiguration cfg = new LwjglApplicationConfiguration();
        cfg.title = "Office Runner by McBurrobit";
        cfg.useGL20 = true;
        cfg.width = 1280;
        cfg.height = 720;
        cfg.resizable = false;
        new CursorTrail();
        new LwjglApplication(new OfficeRunnerGame(), cfg);
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }
}

