/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.AccessLevel;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.TransformationsUtil;
import lombok.eclipse.Eclipse;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseHandlerUtil;
import lombok.eclipse.handlers.SetGeneratedByVisitor;
import lombok.experimental.Wither;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandleWither
extends EclipseAnnotationHandler<Wither> {
    public boolean generateWitherForType(EclipseNode typeNode, EclipseNode pos, AccessLevel level, boolean checkForTypeLevelWither) {
        boolean notAClass;
        if (checkForTypeLevelWither && EclipseHandlerUtil.hasAnnotation(Wither.class, typeNode)) {
            return true;
        }
        TypeDeclaration typeDecl = null;
        if (typeNode.get() instanceof TypeDeclaration) {
            typeDecl = (TypeDeclaration)typeNode.get();
        }
        int modifiers = typeDecl == null ? 0 : typeDecl.modifiers;
        boolean bl = notAClass = (modifiers & 0x6200) != 0;
        if (typeDecl == null || notAClass) {
            pos.addError("@Wither is only supported on a class or a field.");
            return false;
        }
        for (EclipseNode field : typeNode.down()) {
            FieldDeclaration fieldDecl;
            if (field.getKind() != AST.Kind.FIELD || !EclipseHandlerUtil.filterField(fieldDecl = (FieldDeclaration)field.get()) || (fieldDecl.modifiers & 0x10) != 0 && fieldDecl.initialization != null) continue;
            this.generateWitherForField(field, (ASTNode)pos.get(), level);
        }
        return true;
    }

    public void generateWitherForField(EclipseNode fieldNode, ASTNode pos, AccessLevel level) {
        for (EclipseNode child : fieldNode.down()) {
            if (child.getKind() != AST.Kind.ANNOTATION || !EclipseHandlerUtil.annotationTypeMatches(Wither.class, child)) continue;
            return;
        }
        List<Annotation> empty = Collections.emptyList();
        this.createWitherForField(level, fieldNode, fieldNode, pos, false, empty, empty);
    }

    @Override
    public void handle(AnnotationValues<Wither> annotation, Annotation ast, EclipseNode annotationNode) {
        EclipseNode node = (EclipseNode)annotationNode.up();
        AccessLevel level = annotation.getInstance().value();
        if (level == AccessLevel.NONE || node == null) {
            return;
        }
        List<Annotation> onMethod = EclipseHandlerUtil.unboxAndRemoveAnnotationParameter(ast, "onMethod", "@Setter(onMethod=", annotationNode);
        List<Annotation> onParam = EclipseHandlerUtil.unboxAndRemoveAnnotationParameter(ast, "onParam", "@Setter(onParam=", annotationNode);
        switch (node.getKind()) {
            case FIELD: {
                this.createWitherForFields(level, annotationNode.upFromAnnotationToFields(), annotationNode, (ASTNode)annotationNode.get(), true, onMethod, onParam);
                break;
            }
            case TYPE: {
                if (!onMethod.isEmpty()) {
                    annotationNode.addError("'onMethod' is not supported for @Wither on a type.");
                }
                if (!onParam.isEmpty()) {
                    annotationNode.addError("'onParam' is not supported for @Wither on a type.");
                }
                this.generateWitherForType(node, annotationNode, level, false);
            }
        }
    }

    private void createWitherForFields(AccessLevel level, Collection<EclipseNode> fieldNodes, EclipseNode errorNode, ASTNode source, boolean whineIfExists, List<Annotation> onMethod, List<Annotation> onParam) {
        for (EclipseNode fieldNode : fieldNodes) {
            this.createWitherForField(level, fieldNode, errorNode, source, whineIfExists, onMethod, onParam);
        }
    }

    private void createWitherForField(AccessLevel level, EclipseNode fieldNode, EclipseNode errorNode, ASTNode source, boolean whineIfExists, List<Annotation> onMethod, List<Annotation> onParam) {
        if (fieldNode.getKind() != AST.Kind.FIELD) {
            errorNode.addError("@Wither is only supported on a class or a field.");
            return;
        }
        FieldDeclaration field = (FieldDeclaration)fieldNode.get();
        TypeReference fieldType = EclipseHandlerUtil.copyType(field.type, source);
        boolean isBoolean = Eclipse.nameEquals(fieldType.getTypeName(), "boolean") && fieldType.dimensions() == 0;
        String witherName = EclipseHandlerUtil.toWitherName(fieldNode, isBoolean);
        if (witherName == null) {
            errorNode.addWarning("Not generating wither for this field: It does not fit your @Accessors prefix list.");
            return;
        }
        if ((field.modifiers & 8) != 0) {
            errorNode.addWarning("Not generating wither for this field: Withers cannot be generated for static fields.");
            return;
        }
        if ((field.modifiers & 0x10) != 0 && field.initialization != null) {
            errorNode.addWarning("Not generating wither for this field: Withers cannot be generated for final, initialized fields.");
            return;
        }
        if (field.name != null && field.name.length > 0 && field.name[0] == '$') {
            errorNode.addWarning("Not generating wither for this field: Withers cannot be generated for fields starting with $.");
            return;
        }
        for (String altName : EclipseHandlerUtil.toAllWitherNames(fieldNode, isBoolean)) {
            switch (EclipseHandlerUtil.methodExists(altName, fieldNode, false, 1)) {
                case EXISTS_BY_LOMBOK: {
                    return;
                }
                case EXISTS_BY_USER: {
                    if (whineIfExists) {
                        String altNameExpl = "";
                        if (!altName.equals(witherName)) {
                            altNameExpl = String.format(" (%s)", altName);
                        }
                        errorNode.addWarning(String.format("Not generating %s(): A method with that name already exists%s", witherName, altNameExpl));
                    }
                    return;
                }
            }
        }
        int modifier = EclipseHandlerUtil.toEclipseModifier(level);
        MethodDeclaration method = this.createWither((TypeDeclaration)((EclipseNode)fieldNode.up()).get(), fieldNode, witherName, modifier, source, onMethod, onParam);
        EclipseHandlerUtil.injectMethod((EclipseNode)fieldNode.up(), (AbstractMethodDeclaration)method);
    }

    private MethodDeclaration createWither(TypeDeclaration parent, EclipseNode fieldNode, String name, int modifier, ASTNode source, List<Annotation> onMethod, List<Annotation> onParam) {
        Statement nullCheck;
        Annotation[] copiedAnnotations;
        if (name == null) {
            return null;
        }
        FieldDeclaration field = (FieldDeclaration)fieldNode.get();
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        long p = (long)pS << 32 | (long)pE;
        MethodDeclaration method = new MethodDeclaration(parent.compilationResult);
        method.modifiers = modifier;
        method.returnType = EclipseHandlerUtil.cloneSelfType(fieldNode, source);
        if (method.returnType == null) {
            return null;
        }
        Annotation[] deprecated = null;
        if (EclipseHandlerUtil.isFieldDeprecated(fieldNode)) {
            deprecated = new Annotation[]{EclipseHandlerUtil.generateDeprecatedAnnotation(source)};
        }
        if ((copiedAnnotations = EclipseHandlerUtil.copyAnnotations(source, onMethod.toArray(new Annotation[0]), deprecated)).length != 0) {
            method.annotations = copiedAnnotations;
        }
        Argument param = new Argument(field.name, p, EclipseHandlerUtil.copyType(field.type, source), 16);
        param.sourceStart = pS;
        param.sourceEnd = pE;
        method.arguments = new Argument[]{param};
        method.selector = name.toCharArray();
        method.binding = null;
        method.thrownExceptions = null;
        method.typeParameters = null;
        method.bits |= 0x800000;
        ArrayList<Object> args = new ArrayList<Object>();
        for (EclipseNode child : ((EclipseNode)fieldNode.up()).down()) {
            long fieldFlags;
            if (child.getKind() != AST.Kind.FIELD) continue;
            FieldDeclaration childDecl = (FieldDeclaration)child.get();
            if (childDecl.name != null && childDecl.name.length > 0 && childDecl.name[0] == '$' || ((fieldFlags = (long)childDecl.modifiers) & 8L) != 0L || (fieldFlags & 0x10L) != 0L && childDecl.initialization != null) continue;
            if (child.get() == fieldNode.get()) {
                args.add(new SingleNameReference(field.name, p));
                continue;
            }
            args.add(EclipseHandlerUtil.createFieldAccessor(child, EclipseHandlerUtil.FieldAccess.ALWAYS_FIELD, source));
        }
        AllocationExpression constructorCall = new AllocationExpression();
        constructorCall.arguments = args.toArray(new Expression[0]);
        constructorCall.type = EclipseHandlerUtil.cloneSelfType(fieldNode, source);
        EqualExpression identityCheck = new EqualExpression(EclipseHandlerUtil.createFieldAccessor(fieldNode, EclipseHandlerUtil.FieldAccess.ALWAYS_FIELD, source), (Expression)new SingleNameReference(field.name, p), 18);
        ThisReference thisRef = new ThisReference(pS, pE);
        ConditionalExpression conditional = new ConditionalExpression((Expression)identityCheck, (Expression)thisRef, (Expression)constructorCall);
        ReturnStatement returnStatement = new ReturnStatement((Expression)conditional, pS, pE);
        method.declarationSourceStart = method.sourceStart = source.sourceStart;
        method.bodyStart = method.sourceStart;
        method.declarationSourceEnd = method.sourceEnd = source.sourceEnd;
        method.bodyEnd = method.sourceEnd;
        Annotation[] nonNulls = Eclipse.findAnnotations(field, TransformationsUtil.NON_NULL_PATTERN);
        Annotation[] nullables = Eclipse.findAnnotations(field, TransformationsUtil.NULLABLE_PATTERN);
        ArrayList<Object> statements = new ArrayList<Object>(5);
        if (nonNulls.length > 0 && (nullCheck = EclipseHandlerUtil.generateNullCheck((AbstractVariableDeclaration)field, source)) != null) {
            statements.add(nullCheck);
        }
        statements.add(returnStatement);
        method.statements = statements.toArray(new Statement[0]);
        Annotation[] copiedAnnotationsParam = EclipseHandlerUtil.copyAnnotations(source, nonNulls, nullables, onParam.toArray(new Annotation[0]));
        if (copiedAnnotationsParam.length != 0) {
            param.annotations = copiedAnnotationsParam;
        }
        method.traverse((ASTVisitor)new SetGeneratedByVisitor(source), parent.scope);
        return method;
    }
}

