/*
 * Decompiled with CFR 0.152.
 */
package screens;

import actors.Enemy;
import actors.Gun;
import actors.Level;
import aurelienribon.tweenengine.TweenManager;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.badlogic.gdx.graphics.g2d.ParticleEffectPool;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer20;
import com.badlogic.gdx.math.FloatCounter;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Box2DDebugRenderer;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.RayCastCallback;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.physics.box2d.joints.RopeJoint;
import com.badlogic.gdx.physics.box2d.joints.RopeJointDef;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.SkeletonBinary;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonRenderer;
import com.esotericsoftware.spine.Slot;
import com.mcburrobit.util.CursorTrail;
import com.mcburrobit.util.VLine;
import core.AbstractScreen;
import core.OfficeRunnerGame;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import screens.GameoverScreen;

public class GameScreen
extends AbstractScreen {
    private World world;
    static final float MAX_VELOCITY = 17.0f;
    static float ppm;
    static final float skeletonScale = 1.0f;
    boolean jump = false;
    Body player;
    Fixture playerPhysicsFixture;
    ParallaxCamera cam;
    Box2DDebugRenderer renderer;
    FloatCounter camX;
    FloatCounter camY;
    private SkeletonRenderer skeletonrenderer;
    private Animation animation;
    private Skeleton skeleton;
    private float time;
    private SpriteBatch skeletonbatch;
    private boolean groundRayHit;
    private float groundDistance;
    private ImmediateModeRenderer20 rend;
    private Bone shoulder;
    private TweenManager tweenM;
    private Skeleton enemySkeleton;
    private Array<Enemy> enemies;
    private float enemyTimer;
    private ParticleEffectPool bloodEffectPool;
    private Array<ParticleEffectPool.PooledEffect> effects;
    private ParticleEffect bloodEffect;
    private Animation enemyAnimation;
    private Texture[] layers;
    private BitmapFont font;
    private NumberFormat formatter;
    private Level level;
    private Gun gun;
    private RopeJoint rope;
    private VLine ropeLine;
    private CursorTrail ct;
    private boolean dragArm = false;
    private Sprite shoulderSprite;
    private Body shoulderBox;
    private Texture bg;
    private Animation jumpAnimation;
    private boolean paused;
    private FrameBuffer fbo;
    private TextureRegion fboRegion;
    private Sprite pauseGameS;
    private Texture kello;
    private float kelloY;

    public GameScreen(OfficeRunnerGame gameObj) {
        super(gameObj);
        ppm = this.game.getPPM();
        this.world = new World(new Vector2(0.0f, -20.0f), true);
        this.renderer = new Box2DDebugRenderer();
        this.cam = new ParallaxCamera(OfficeRunnerGame.INTERNAL_RES[0], OfficeRunnerGame.INTERNAL_RES[1]);
        this.createWorld();
        this.camX = new FloatCounter(15);
        this.camY = new FloatCounter(15);
        this.skeletonbatch = new SpriteBatch();
        this.skeletonrenderer = new SkeletonRenderer();
        String name = "snygin_luut";
        TextureAtlas atlas = new TextureAtlas(Gdx.files.internal(String.valueOf(name) + ".atlas"));
        this.shoulderSprite = new Sprite(atlas.findRegion("SNYGG_ASE"));
        SkeletonBinary binary = new SkeletonBinary(atlas);
        SkeletonData skeletonData = binary.readSkeletonData(Gdx.files.internal(String.valueOf(name) + ".skel"));
        this.animation = skeletonData.findAnimation("running");
        this.jumpAnimation = skeletonData.findAnimation("jumping");
        this.skeleton = new Skeleton(skeletonData);
        this.skeleton.updateWorldTransform();
        name = "vihun_luut";
        atlas = new TextureAtlas(Gdx.files.internal(String.valueOf(name) + ".atlas"));
        binary = new SkeletonBinary(atlas);
        skeletonData = binary.readSkeletonData(Gdx.files.internal(String.valueOf(name) + ".skel"));
        this.enemyAnimation = skeletonData.findAnimation("run");
        this.enemySkeleton = new Skeleton(skeletonData);
        this.enemySkeleton.updateWorldTransform();
        for (Slot slot : this.skeleton.getSlots()) {
            if (!slot.getData().getName().toString().contains("ASE")) continue;
            this.shoulder = slot.getBone();
        }
        this.gun = new Gun(this.player, this.world, this.cam, this.game, this.shoulder);
        this.rend = new ImmediateModeRenderer20(false, true, 0);
        this.tweenM = this.game.tweenM;
        this.enemies = new Array(false, 20, Enemy.class);
        this.enemyTimer = 0.0f;
        this.effects = new Array();
        this.bloodEffect = new ParticleEffect();
        this.bloodEffect.load(Gdx.files.internal("blood.particle"), Gdx.files.internal("data/"));
        this.bloodEffectPool = new ParticleEffectPool(this.bloodEffect, 1, 4);
        this.bg = new Texture(Gdx.files.internal("parallax/bg.png"));
        this.layers = new Texture[8];
        this.layers[0] = new Texture(Gdx.files.internal("parallax/layer1.png"));
        this.layers[1] = new Texture(Gdx.files.internal("parallax/pilvet1.png"));
        this.layers[2] = new Texture(Gdx.files.internal("parallax/pilvet2.png"));
        this.layers[3] = new Texture(Gdx.files.internal("parallax/pilvet3.png"));
        this.layers[4] = new Texture(Gdx.files.internal("parallax/layer3.png"));
        this.layers[5] = new Texture(Gdx.files.internal("parallax/minipilvet1.png"));
        this.layers[6] = new Texture(Gdx.files.internal("parallax/minipilvet2.png"));
        this.layers[7] = new Texture(Gdx.files.internal("parallax/layer1_2.png"));
        this.game.setScore(0.0f);
        this.formatter = new DecimalFormat("#.00");
        this.ct = new CursorTrail();
        this.font = new BitmapFont(Gdx.files.internal("data/font.fnt"), Gdx.files.internal("data/font.png"), false, true);
        this.font.setFixedWidthGlyphs("0123456789.,");
        this.skeleton.setAttachment("prop_CAP", "prop_CAP");
        Gdx.input.setCursorCatched(true);
    }

    @Override
    public void render(float delta) {
        if (!this.game.gameMusic.isPlaying()) {
            this.game.gameMusic.setLooping(true);
            this.game.gameMusic.play();
        }
        Gdx.graphics.getGL20().glClearColor(1.0f, 0.0f, 1.0f, 1.0f);
        if (Gdx.input.isKeyPressed(131)) {
            this.game.gameMusic.pause();
            this.game.setScreen(this.game.menuS);
        }
        super.render(delta);
        this.batch.setProjectionMatrix(this.cam.calculateParallaxMatrix(0.0f, 0.0f));
        this.batch.begin();
        this.batch.draw(this.bg, (float)(-this.bg.getWidth() / 2), (float)(-this.bg.getHeight() / 2));
        this.batch.end();
        int layer1TimesOffset = (int)this.cam.frustum.planePoints[0].x / (int)((float)this.layers[0].getWidth() / 0.05f);
        int layer1_2TimesOffset = (int)this.cam.frustum.planePoints[0].x / (int)((float)this.layers[7].getWidth() / 0.06f);
        int layer2TimesOffset = (int)this.cam.frustum.planePoints[0].x / (int)((float)this.layers[1].getWidth() / 0.048f);
        int layer3TimesOffset = (int)this.cam.frustum.planePoints[0].x / (int)((float)this.layers[2].getWidth() / 0.1f);
        int layer4TimesOffset = (int)this.cam.frustum.planePoints[0].x / (int)((float)this.layers[3].getWidth() / 0.13f);
        int layer5TimesOffset = (int)this.cam.frustum.planePoints[0].x / (int)((float)this.layers[4].getWidth() / 0.175f);
        int layer6TimesOffset = (int)this.cam.frustum.planePoints[0].x / (int)((float)this.layers[5].getWidth() / 0.19f);
        int layer7TimesOffset = (int)this.cam.frustum.planePoints[0].x / (int)((float)this.layers[6].getWidth() / 0.22f);
        this.batch.setProjectionMatrix(this.cam.calculateParallaxMatrix(0.05f, 0.0f));
        this.batch.begin();
        int i = 0;
        while (i < 4) {
            this.batch.draw(this.layers[0], (float)(-this.layers[0].getWidth() + (i + layer1TimesOffset) * this.layers[0].getWidth()), (float)(-(this.layers[0].getHeight() / 2)));
            ++i;
        }
        this.batch.end();
        this.batch.setProjectionMatrix(this.cam.calculateParallaxMatrix(0.06f, 0.0f));
        this.batch.begin();
        i = 0;
        while (i < 4) {
            this.batch.draw(this.layers[7], (float)(-this.layers[7].getWidth() + (i + layer1_2TimesOffset) * this.layers[7].getWidth()), (float)(-(this.layers[7].getHeight() / 2)));
            ++i;
        }
        this.batch.end();
        this.batch.setProjectionMatrix(this.cam.calculateParallaxMatrix(-0.048f, 0.0f));
        this.batch.begin();
        i = 0;
        while (i < 4) {
            this.batch.setColor(1.0f, 1.0f, 1.0f, 0.75f);
            this.batch.draw(this.layers[1], (float)(-this.layers[1].getWidth() + (i + layer2TimesOffset) * this.layers[1].getWidth()), (float)(-(this.layers[1].getHeight() / 2)));
            ++i;
        }
        this.batch.end();
        this.batch.setProjectionMatrix(this.cam.calculateParallaxMatrix(0.1f, 0.0f));
        this.batch.begin();
        i = 0;
        while (i < 4) {
            this.batch.draw(this.layers[2], (float)(-this.layers[2].getWidth() + (i + layer3TimesOffset) * this.layers[2].getWidth()), (float)(-(this.layers[2].getHeight() / 2)));
            ++i;
        }
        this.batch.end();
        this.batch.setProjectionMatrix(this.cam.calculateParallaxMatrix(0.13f, 0.0f));
        this.batch.begin();
        i = 0;
        while (i < 4) {
            this.batch.draw(this.layers[3], (float)(-this.layers[3].getWidth() + (i + layer4TimesOffset) * this.layers[3].getWidth()), (float)(-(this.layers[3].getHeight() / 2)));
            ++i;
        }
        this.batch.end();
        this.batch.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.batch.setProjectionMatrix(this.cam.calculateParallaxMatrix(0.175f, 0.0f));
        this.batch.begin();
        i = 0;
        while (i < 4) {
            this.batch.draw(this.layers[4], (float)(-this.layers[4].getWidth() + (i + layer5TimesOffset) * this.layers[4].getWidth()), (float)(-(this.layers[4].getHeight() / 2)));
            ++i;
        }
        this.batch.end();
        this.batch.setColor(1.0f, 1.0f, 1.0f, 0.5f);
        this.batch.setProjectionMatrix(this.cam.calculateParallaxMatrix(0.19f, 0.0f));
        this.batch.begin();
        i = 0;
        while (i < 4) {
            this.batch.draw(this.layers[5], (float)(-this.layers[5].getWidth() + (i + layer6TimesOffset) * this.layers[5].getWidth()), (float)(-(this.layers[5].getHeight() / 2)));
            ++i;
        }
        this.batch.end();
        this.batch.setProjectionMatrix(this.cam.calculateParallaxMatrix(0.22f, 0.0f));
        this.batch.begin();
        i = 0;
        while (i < 4) {
            this.batch.draw(this.layers[6], (float)(-this.layers[6].getWidth() + (i + layer7TimesOffset) * this.layers[6].getWidth()), (float)(-(this.layers[6].getHeight() / 2)));
            ++i;
        }
        this.batch.end();
        this.batch.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        Vector2 vel = this.player.getLinearVelocity();
        Vector2 pos = this.player.getPosition();
        this.batch.setProjectionMatrix(this.cam.combined.cpy());
        this.batch.begin();
        this.level.render(this.batch);
        this.batch.end();
        if (pos.y < -10.0f) {
            this.game.gameMusic.pause();
            this.game.setScreen(new GameoverScreen(this.game, this.formatter.format(this.game.getScore())));
        }
        boolean grounded = this.isPlayerGrounded(delta);
        if (!this.paused) {
            int i2 = this.enemies.size - 1;
            while (i2 >= 0) {
                Enemy enemy = this.enemies.get(i2);
                if (!enemy.update()) {
                    this.enemies.removeIndex(i2);
                }
                --i2;
            }
            this.enemyTimer += delta;
            if (this.enemyTimer >= 0.5f) {
                this.log("ENEMY");
                this.enemyTimer -= 0.5f;
                this.enemies.add(new Enemy("enemy", this.enemySkeleton, new Vector2(MathUtils.random(this.cam.frustum.planePoints[0].x / ppm, pos.x - 0.7f), pos.y), this.game, this.world, this.cam, this.player, this.tweenM, this.effects, this.bloodEffectPool));
            }
            this.tweenM.update(delta);
            this.cam.position.set(pos.x * ppm - OfficeRunnerGame.INTERNAL_RES[0] / 8.0f, 45.0f, 0.0f);
            this.cam.update();
            if (Math.abs(vel.x) > 42.5f) {
                vel.x = Math.signum(vel.x) * 17.0f * 2.5f;
                this.player.setLinearVelocity(vel.x, vel.y);
            }
            this.playerPhysicsFixture.setFriction(0.1f);
            this.player.applyLinearImpulse(6.6000004f, 0.0f, pos.x, pos.y, true);
            this.world.rayCast(new RayCastCallback(){

                @Override
                public float reportRayFixture(Fixture fixture, Vector2 point, Vector2 normal, float fraction) {
                    String udName = "";
                    try {
                        udName = fixture.getBody().getUserData().getClass().getSimpleName();
                    }
                    catch (Exception e) {
                        return 1.0f;
                    }
                    if (udName.equals("House")) {
                        Level.House h = (Level.House)fixture.getBody().getUserData();
                        float y = h.getBounds().y;
                        Vector2 pos = GameScreen.this.player.getPosition();
                        if (y - pos.y < 0.4f) {
                            GameScreen.this.player.setTransform(pos.x + 1.0f, y + 2.2f + 0.025f, 0.0f);
                        }
                        return 0.0f;
                    }
                    return 1.0f;
                }
            }, this.player.getPosition().cpy().add(0.0f, -1.1f), this.player.getPosition().cpy().add(1.0f, -1.1f));
            if (this.jump) {
                this.jump = false;
                this.time = 0.0f;
                if (grounded) {
                    this.player.setLinearVelocity(vel.x, 0.0f);
                    this.player.setTransform(pos.x, pos.y + 0.025f, 0.0f);
                    this.player.applyLinearImpulse(0.0f, 70.0f, pos.x, pos.y, true);
                }
            }
            this.world.step(delta, 8, 4);
        }
        this.skeletonbatch.setProjectionMatrix(this.cam.combined.cpy().scl(1.0f));
        this.time += delta;
        this.skeleton.setX(pos.x * ppm / 1.0f);
        this.skeleton.setY((pos.y - 2.2f) * ppm / 1.0f);
        if (grounded) {
            this.animation.apply(this.skeleton, this.time, true);
        } else {
            this.jumpAnimation.apply(this.skeleton, this.time, false);
        }
        this.enemyAnimation.apply(this.enemySkeleton, this.time, true);
        Vector3 mousePos = new Vector3(Gdx.input.getX(), Gdx.input.getY(), 0.0f);
        this.cam.unproject(mousePos);
        Vector2 shoulderPos = new Vector2((this.skeleton.getX() + this.shoulder.getWorldX()) * 1.0f, (this.skeleton.getY() + this.shoulder.getWorldY()) * 1.0f);
        Vector2 mouseShoulderVector = new Vector2(mousePos.x - shoulderPos.x, mousePos.y - shoulderPos.y).nor();
        this.gun.update(shoulderPos.cpy().scl(1.0f / ppm), mouseShoulderVector.cpy().scl(1.0f / ppm));
        if (this.gun.rotated() > 1440.0f && !this.dragArm) {
            this.dragArm = true;
            this.createDragArm(this.player.getPosition().cpy().add(0.0f, 1.1f));
            this.skeleton.setAttachment("prop_CAP", "prop_CAP_flipped");
        }
        this.skeleton.updateWorldTransform();
        this.skeleton.update(delta);
        this.enemySkeleton.updateWorldTransform();
        this.enemySkeleton.update(delta);
        this.skeletonbatch.begin();
        this.skeletonrenderer.draw(this.skeletonbatch, this.skeleton);
        for (Enemy enemy : this.enemies) {
            enemy.render();
            this.skeletonrenderer.draw(this.skeletonbatch, this.enemySkeleton);
        }
        this.skeletonbatch.end();
        this.player.setAwake(true);
        this.level.update();
        if (!this.paused) {
            if (Gdx.input.isTouched()) {
                this.player.applyForceToCenter(mouseShoulderVector.cpy().mul(-120.0f), true);
            }
            this.game.addScore(delta * 10.0f);
        }
        this.batch.setProjectionMatrix(this.cam.combined);
        this.batch.begin();
        int i3 = this.effects.size - 1;
        while (i3 >= 0) {
            ParticleEffectPool.PooledEffect peffect = this.effects.get(i3);
            peffect.draw(this.batch, delta);
            if (peffect.isComplete()) {
                peffect.free();
                this.effects.removeIndex(i3);
            }
            --i3;
        }
        this.batch.end();
        this.batch.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, 1280.0f, 720.0f);
        this.batch.begin();
        this.font.draw(this.batch, this.formatter.format(this.game.getScore()), 1280.0f - this.font.getBounds((CharSequence)this.formatter.format((double)((double)this.game.getScore()))).width, 780.0f);
        this.batch.end();
        if (!this.paused && (Gdx.input.isTouched() || Gdx.input.isKeyPressed(45)) && this.gun.trigger() && MathUtils.randomBoolean()) {
            Vector2 aimVector = this.gun.aimvec();
            float hitDistance = this.gun.hitdist();
            Gdx.gl20.glLineWidth(MathUtils.random(1.0f, 2.0f));
            this.rend.begin(this.cam.combined.cpy().scl(ppm), 1);
            float c = MathUtils.random(0.6f, 1.0f);
            this.rend.color(c, c, c, 1.0f);
            this.rend.vertex(shoulderPos.cpy().scl((float)(1.0f / GameScreen.ppm)).add((Vector2)mouseShoulderVector.cpy().scl((float)(1.0f / GameScreen.ppm * 50.0f))).x, shoulderPos.cpy().scl((float)(1.0f / GameScreen.ppm)).add((Vector2)mouseShoulderVector.cpy().scl((float)(1.0f / GameScreen.ppm * 50.0f))).y, 0.0f);
            this.rend.color(c, c, c, 1.0f);
            if (hitDistance > 50.0f) {
                this.rend.vertex(shoulderPos.cpy().scl((float)(1.0f / GameScreen.ppm)).add((Vector2)mouseShoulderVector.cpy().scl((float)(1.0f / GameScreen.ppm * hitDistance))).x, shoulderPos.cpy().scl((float)(1.0f / GameScreen.ppm)).add((Vector2)mouseShoulderVector.cpy().scl((float)(1.0f / GameScreen.ppm * hitDistance))).y, 0.0f);
            } else {
                this.rend.vertex(aimVector.cpy().x, aimVector.cpy().y, 0.0f);
            }
            this.rend.end();
            Gdx.gl20.glLineWidth(1.0f);
        }
        if (this.dragArm) {
            this.shoulder.setScaleX(0.0f);
            this.shoulder.setScaleY(0.0f);
            Gdx.gl20.glLineWidth(5.0f);
            this.rend.begin(this.cam.combined.cpy().scl(ppm), 1);
            this.ropeLine.setP1(this.rope.getAnchorA());
            this.ropeLine.setP2(this.rope.getAnchorB());
            this.ropeLine.update(this.rend);
            this.rend.end();
            Gdx.gl20.glLineWidth(1.0f);
            this.shoulderSprite.setPosition(ppm / 1.0f * this.shoulderBox.getWorldCenter().x - this.shoulderSprite.getWidth() / 2.0f, ppm / 1.0f * this.shoulderBox.getWorldCenter().y - this.shoulderSprite.getHeight() / 2.0f);
            this.shoulderSprite.setRotation(this.shoulderBox.getAngle() * 57.295776f - 180.0f);
            this.skeletonbatch.begin();
            this.shoulderSprite.draw(this.skeletonbatch);
            this.skeletonbatch.end();
        }
        if (this.paused) {
            if (this.fbo == null) {
                this.fbo = new FrameBuffer(Pixmap.Format.RGB565, 320, 180, false);
                this.fboRegion = new TextureRegion(this.fbo.getColorBufferTexture());
                this.fboRegion.flip(false, true);
                this.pauseGameS = new Sprite(new Texture(Gdx.files.internal("splash/burro.png")));
                this.kello = new Texture(Gdx.files.internal("pauseGame/kello.png"));
                this.kelloY = 720.0f;
            }
            this.fbo.begin();
            this.batch.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, 320.0f, 180.0f);
            this.batch.begin();
            Gdx.graphics.getGL20().glClearColor(0.23921569f, 0.26666668f, 0.40392157f, 1.0f);
            Gdx.gl.glClear(16640);
            this.pauseGameS.setPosition(0.0f, 0.0f);
            this.pauseGameS.setSize(64.0f, 64.0f);
            if (!(this.kelloY <= 0.0f) || Gdx.input.isTouched()) {
                // empty if block
            }
            this.batch.end();
            this.fbo.end();
            this.kelloY = this.kelloY > 0.0f ? (this.kelloY -= delta * 360.0f) : 0.0f;
            this.batch.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, 1280.0f, 720.0f);
            this.batch.begin();
            this.batch.draw(this.kello, 0.0f, this.kelloY, 1280.0f, 720.0f);
            this.batch.draw(this.fboRegion, 290.0f, this.kelloY + 180.0f, 699.0f, 358.0f);
            this.batch.end();
        }
        Vector3 mouseP = new Vector3(Gdx.input.getX() + 5, Gdx.input.getY() + 5, 0.0f);
        this.rend.begin(this.cam.combined.cpy().setToOrtho2D(0.0f, 720.0f, 1280.0f, -720.0f), 5);
        this.ct.update(this.rend, new Vector2(mouseP.x, mouseP.y));
        this.rend.end();
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this);
    }

    @Override
    public void hide() {
        Gdx.input.setCursorCatched(false);
    }

    private void createWorld() {
        this.player = this.createPlayer();
        this.player.setTransform(10.0f, 4.0f, 0.0f);
        this.player.setFixedRotation(true);
        this.level = new Level(this.player, this.world, this.cam, ppm);
    }

    private void createDragArm(Vector2 playerPos) {
        BodyDef def = new BodyDef();
        def.type = BodyDef.BodyType.DynamicBody;
        Body box = this.world.createBody(def);
        PolygonShape poly = new PolygonShape();
        poly.setAsBox(1.8f, 0.25f);
        Fixture f = box.createFixture(poly, 1.25f);
        f.setFriction(0.65f);
        box.setTransform(playerPos.sub(1.26f, 0.0f), 0.0f);
        box.setBullet(true);
        RopeJointDef rjd = new RopeJointDef();
        rjd.bodyA = this.player;
        rjd.bodyB = box;
        rjd.maxLength = 5.0f;
        rjd.localAnchorA.x = -0.6f;
        rjd.localAnchorA.y = 2.1f;
        rjd.localAnchorB.x = 1.4f;
        rjd.localAnchorB.y = 0.2f;
        this.rope = (RopeJoint)this.world.createJoint(rjd);
        this.ropeLine = new VLine(this.rope.getAnchorA(), this.rope.getAnchorB(), 8, 0.1f);
        this.dragArm = true;
        this.shoulderBox = box;
    }

    @Override
    public void dispose() {
        this.bg.dispose();
        Texture[] textureArray = this.layers;
        int n = this.layers.length;
        int n2 = 0;
        while (n2 < n) {
            Texture layer = textureArray[n2];
            layer.dispose();
            ++n2;
        }
        this.world.dispose();
        this.bloodEffectPool.clear();
        this.bloodEffect.dispose();
        this.renderer.dispose();
        this.skeletonbatch.dispose();
        this.batch.dispose();
        this.rend.dispose();
    }

    private Body createPlayer() {
        BodyDef def = new BodyDef();
        def.type = BodyDef.BodyType.DynamicBody;
        Body box = this.world.createBody(def);
        Filter fil = new Filter();
        fil.groupIndex = (short)-1;
        PolygonShape poly = new PolygonShape();
        poly.setAsBox(0.7f, 2.2f);
        this.playerPhysicsFixture = box.createFixture(poly, 1.0f);
        this.playerPhysicsFixture.setFilterData(fil);
        poly.dispose();
        box.setBullet(true);
        return box;
    }

    private boolean isPlayerGrounded(float deltaTime) {
        this.groundRayHit = false;
        this.groundDistance = 99.0f;
        this.world.rayCast(new RayCastCallback(){

            @Override
            public float reportRayFixture(Fixture fixture, Vector2 point, Vector2 normal, float fraction) {
                String udName = "";
                try {
                    udName = fixture.getBody().getUserData().getClass().getSimpleName();
                }
                catch (Exception e) {
                    return 1.0f;
                }
                if (udName.equals("House")) {
                    GameScreen.this.groundRayHit = true;
                    GameScreen.this.groundDistance = fraction * 10.0f;
                    return 0.0f;
                }
                return 1.0f;
            }
        }, this.player.getPosition().cpy().add(0.0f, -2.2f), this.player.getPosition().cpy().add(0.0f, -12.2f));
        if (!this.groundRayHit) {
            return false;
        }
        return !(this.groundDistance > 0.5f);
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 51) {
            this.jump = true;
        }
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        if (keycode == 51) {
            this.jump = false;
        }
        return false;
    }

    class ParallaxCamera
    extends OrthographicCamera {
        Matrix4 parallaxView;
        Matrix4 parallaxCombined;
        Vector3 tmp;
        Vector3 tmp2;

        public ParallaxCamera(float viewportWidth, float viewportHeight) {
            super(viewportWidth, viewportHeight);
            this.parallaxView = new Matrix4();
            this.parallaxCombined = new Matrix4();
            this.tmp = new Vector3();
            this.tmp2 = new Vector3();
        }

        public Matrix4 calculateParallaxMatrix(float parallaxX, float parallaxY) {
            this.update();
            this.tmp.set(this.position);
            this.tmp.x *= parallaxX;
            this.tmp.y *= parallaxY;
            this.parallaxView.setToLookAt(this.tmp, this.tmp2.set(this.tmp).add(this.direction), this.up);
            this.parallaxCombined.set(this.projection);
            Matrix4.mul(this.parallaxCombined.val, this.parallaxView.val);
            return this.parallaxCombined;
        }
    }
}

