﻿
var init = function(){
  
  var width = window.innerWidth;
  var height = window.innerHeight;
  
  RENDERER = new THREE.WebGLRenderer();
  RENDERER.setSize(width, height);
  RENDERER.setClearColor(0x000000);
  document.body.appendChild( RENDERER.domElement );
  
  MAIN_SCENE = new THREE.Scene();
  
  MAIN_CAMERA_PERSPECTIVE = new THREE.PerspectiveCamera( 45, width / height);
  MAIN_CAMERA_PERSPECTIVE.position.z = 400;
  MAIN_SCENE.add(MAIN_CAMERA_PERSPECTIVE);
  MAIN_CAMERA_ORTHO = new THREE.OrthographicCamera(-(width/2), width/2, height/2, -(height/2));
  MAIN_CAMERA_ORTHO.position.z = 1;
  MAIN_SCENE.add(MAIN_CAMERA_ORTHO);
  
  ACTIVE_CAMERA = MAIN_CAMERA_ORTHO;
  
  RTT_RESO = [2048, 1024];
  RENDER_TARGET = new THREE.WebGLRenderTarget(RTT_RESO[0], RTT_RESO[1]);
  
  var display = new THREE.Mesh(new THREE.PlaneGeometry(width, height),
    new THREE.MeshBasicMaterial({map : RENDER_TARGET}));
  display.position.z = -200;
  MAIN_SCENE.add(display);
  
  //Kaikilla sceneillä on oma piirtofunktio, joka piirtää scenen RENDER_TARGET frame bufferiin
  SCENES = [];
  SCENES.push(initLines());
  SCENES.push(initBall());
  
  //Aktiivinen scene on se, mikä piirretään
  ACTIVE_SCENE = 0;
  FRAME_COUNT = 0;
  
  window.addEventListener( 'resize', onResize, false );
  
  mainLoop();
};

var initLines = function(){
  
  var scene = new THREE.Scene();
  var camera = new THREE.OrthographicCamera(-(RTT_RESO[0]/2), RTT_RESO[0]/2, RTT_RESO[1]/2, -(RTT_RESO[1]/2));
  camera.position.z = 1;
  scene.add(camera);
  
  LINES_AMOUNT = 3;
  var lines = [];
  
  for(var i = 0; i < LINES_AMOUNT; ++i){
    var geometry = new THREE.Geometry();

    geometry.vertices.push(new THREE.Vector3(0,-RTT_RESO[1]/2,0));
    geometry.vertices.push(new THREE.Vector3(0,-RTT_RESO[1]/2+1,0));
    
    var line = new THREE.Line(geometry, new THREE.LineBasicMaterial({color : 0xFFFFFF, linewidth : 10}));
    line.updateMatrix();
    
    lines.push(line);
    scene.add(line);
  }

  var drawLinesScene = function(){
    RENDERER.render(scene, camera, RENDER_TARGET);
  }
  
  var animateLinesScene = function(){
    
    if(FRAME_COUNT >= 5 && FRAME_COUNT % 5 == 0){
      
      var tmp = lines[0];
      var newGeometry = new THREE.Geometry();
      
      for(var k = 0; k < tmp.geometry.vertices.length; ++k){
        newGeometry.vertices.push(tmp.geometry.vertices[k].clone());
      }
      
      var lastPoint = newGeometry.vertices[newGeometry.vertices.length-1];
      
      var x = -lastPoint.x + (Math.sin(FRAME_COUNT)*100);
      var y = lastPoint.y + FRAME_COUNT;
      
      newGeometry.vertices.push(new THREE.Vector3(x, y, 0));
       
      scene.remove(tmp);
      tmp.geometry.dispose();
      lines.splice(0, 1);

      newLine = new THREE.Line(newGeometry, new THREE.LineBasicMaterial({color : 0xFFFFFF, linewidth : 10}));
      newLine.updateMatrix();
      scene.add(newLine);
      
      lines.push(newLine);
      
    }else if(FRAME_COUNT >= 3 && FRAME_COUNT % 3 == 0){
    
      var tmp = lines[0];
      var newGeometry = new THREE.Geometry();
      
      for(var k = 0; k < tmp.geometry.vertices.length; ++k){
        newGeometry.vertices.push(tmp.geometry.vertices[k].clone());
      }
      
      var lastPoint = newGeometry.vertices[newGeometry.vertices.length-1];
      
      var y = -lastPoint.x + (Math.sin(FRAME_COUNT)*100);
      var x = lastPoint.y + FRAME_COUNT;
      
      newGeometry.vertices.push(new THREE.Vector3(x, y, 0));
      
      scene.remove(tmp);
      tmp.geometry.dispose();
      lines.splice(0, 1);

      newLine = new THREE.Line(newGeometry, new THREE.LineBasicMaterial({color : 0xFFFFFF, linewidth : 10}));
      newLine.updateMatrix();
      scene.add(newLine);
      
      lines.push(newLine);
      
    }
  }
  
  return{
    render : drawLinesScene,
    animate : animateLinesScene,
    duration : 340
  };
}

var initBall = function(){
  var ball = new THREE.Mesh(new THREE.SphereGeometry(150, 32, 32),
    new THREE.MeshBasicMaterial({
      map : RENDER_TARGET
  }));
  ball.position.z = -100;
  ball.visible = false;
  MAIN_SCENE.add(ball);
  
  var started = false;
  
  
  var anim = function(){
    if(!started){
      ACTIVE_CAMERA = MAIN_CAMERA_PERSPECTIVE;
      ball.visible = true;
      started = true;
    }
    
    ball.rotation.y += Math.PI/1000;
  }
  
  return{
    render : function(){},
    animate : anim,
    duration : 1000
  };
}


var render = function(){
  if(SCENES[ACTIVE_SCENE]){
    SCENES[ACTIVE_SCENE].render();
    RENDERER.render(MAIN_SCENE, ACTIVE_CAMERA);
  }
};

var mainLoop = function(){
  
  if(SCENES[ACTIVE_SCENE]){
    requestAnimationFrame( mainLoop );
    ++FRAME_COUNT;
    
    if(FRAME_COUNT <= SCENES[ACTIVE_SCENE].duration){
      SCENES[ACTIVE_SCENE].animate();
    }
    else{
      ++ACTIVE_SCENE;
      FRAME_COUNT = 0;
    }
    if(ACTIVE_SCENE >= SCENES.length){
      cancelAnimationFrame(mainLoop);
    }
    render();
  }
};

var onResize = function(){
  MAIN_CAMERA_PERSPECTIVE.aspect = window.innerWidth / window.innerHeight;
  MAIN_CAMERA_PERSPECTIVE.updateProjectionMatrix();
  RENDERER.setSize(window.innerWidth, window.innerHeight);
};