//Namespace
this.wideload = this.wideload || {};

/**
* Part 2 
*/

(function(){

	
	/**
	* Constructor
	* @param beginTime When the effect should start
	* @param prepareTime How long should the effect be allowed to stay in prepare phase (visible during previous parts end phase).
	         Value of 0 indicates immediate change. The endtime for previous part is the same as this parts prepare. First part has no prepare.
	*/
	var ParticlePart = function(beginTime, prepareTime, main){
		this.beginTime = beginTime;
		this.prepareTime = prepareTime;
		this.renderer = null; //Renderer is given from outside.
		this.main = main;
		this.curPos = 0;
	}
	
	//Expose class
	wideload.ParticlePart = ParticlePart;
	
	var p = ParticlePart.prototype = new wideload.BasePart();
	
	/**
	* Initialize the part. This is called during page load.
	*/
	p.initialize_Super = p.initialize;
	p.initialize = function(){
	
		$("#code").fadeOut(0);
		$("#exca").fadeOut(0);
		$("#poro").fadeOut(0);
		$("#rimina").fadeOut(0);
		$("#music").fadeOut(0);
		$("#eclipser").fadeOut(0);
		$("#brownies").fadeOut(0);
		this.initialize_Super();
		this.scene.remove(this.camera);
		//this.camera = new THREE.PerspectiveCamera( 45, this.width / this.height);
		//this.camera.position.z = -400;
		//this.scene.add(this.camera);
		
		this.uniforms = {
			delta: {type: 'f', value:0.0},
			rm: {type: 'f', value:0},
			gm: {type: 'f', value:0},			
			bm: {type: 'f', value:0},
			midPoint: {type: 'v2', value:new THREE.Vector2(this.width/2, this.height/2)},
			time: {type: 'f', value:0},
		};
		this.material = new THREE.ShaderMaterial({
			wireframe: false,
			side: THREE.DoubleSide,
			shading: 1,
			attributes: {},
			uniforms: this.uniforms,
			vertexShader: wideload.ParticleShader.vertexShader,
			fragmentShader: wideload.ParticleShader.fragmentShader
		});
		this.maxX = this.width/2;
		this.minX = -this.width/2;
		this.maxY = this.height/2;
		this.minY = -this.height/2;
		
		this.camera = new THREE.PerspectiveCamera( 45, 1280 / 720);
		
		//material = new THREE.MeshBasicMaterial({color:0xFFFFFF, side:THREE.DoubleSide});
		
		//tmn leveys/korkeus tulee olla sama kuin RESO.x/RESO.y
		this.display = new THREE.Mesh(new THREE.PlaneGeometry(this.width*4, this.height*4),
									 this.material);
		this.display.position.z = -400;
		this.scene.add(this.display);
		
		this.ambient = new THREE.AmbientLight(0x151515);
		this.scene.add(this.ambient);
		
		this.part = new wideload.Particle();
		this.part.init(this.scene, 0,0,-50,0x00);
		this.part2 = new wideload.Particle();
		this.part2.init(this.scene, 0,0,-50,0x00);
		
		this.part3 = new wideload.Particle();
		this.part3.init(this.scene, 0,0,-50, 0x201010);
		this.part4 = new wideload.Particle();
		this.part4.init(this.scene, 0,0,-50, 0x203020);
		
		
		this.dotScreenEffect = new THREE.ShaderPass(THREE.RGBShiftShader);
		this.dotScreenEffect.uniforms['amount'].value = 10.0;
		
		this.film = new THREE.ShaderPass(THREE.FilmShader);
		this.film.uniforms[ "sCount" ].value = 300;
		this.film.uniforms[ "sIntensity" ].value = 0.9;
		this.film.uniforms[ "nIntensity" ].value = 0.3; 
		this.film.uniforms.grayscale.value = 1;
		
		this.vignette = new THREE.ShaderPass(THREE.VignetteShader);
		this.vignette.darkness=2.0;
		//this.vignette.renderToScreen = true;
		//this.film.renderToScreen = true;
		
		this.composer = new THREE.EffectComposer(this.main.renderer,this.renderTarget);
		this.composer.addPass(new THREE.RenderPass(this.scene, this.camera));
		//this.composer.addPass(this.dotScreenEffect);
		this.composer.addPass(this.film);
		this.composer.addPass(this.vignette);
		
		copyPass = new THREE.ShaderPass( THREE.CopyShader );
		copyPass.renderToScreen = true;
		this.composer.addPass(copyPass);
		
		var wallMaterial = new THREE.MeshPhongMaterial({color:0x909090, shading:THREE.SmoothShading});
		var ballMaterial = new THREE.MeshPhongMaterial({color:0xcccccc, ambient:0,  shading:THREE.FlatShading});
		
		this.light = new THREE.PointLight(0xE08B0E, 1.9, 250);
		this.scene.add(this.light);
		this.light2 = new THREE.PointLight(0x4274E8, 1.9, 250);
		this.scene.add(this.light2);
		wideload.Random.init(100);
		
		var colors = [
			Math.floor(0.4*255) << 16 | 255 << 8 | Math.floor(0.7*255),
			Math.floor(0.2*255) << 16 | 255 << 8 | Math.floor(0.9*255),
			0 << 16 | Math.floor(0.6*255) << 8 | 255,
			Math.floor(0.4*255) << 16 | Math.floor(0.3*255) << 8 | Math.floor(0.5*255),
			Math.floor(0.4*255) << 16 | 255 << 8 | Math.floor(0.4*255),
			255 << 16 | Math.floor(0.2*255) << 8 | Math.floor(0.2*255)
		];
		
		for(var i = 0; i < 80; i++)
		{
			var icoG = new THREE.IcosahedronGeometry(10+wideload.Random.next()%10,0);
			
			var ballMaterial = new THREE.MeshLambertMaterial({color:colors[wideload.Random.next()%colors.length], ambient:0x404040, shininess:4,  shading:THREE.FlatShading});
				
		
			this.ball = new THREE.Mesh(icoG, ballMaterial);
			this.ball.rotation.z = wideload.Random.nextFloat();
			this.ball.rotation.x = wideload.Random.nextFloat();
			this.ball.rotation.y = wideload.Random.nextFloat();
			
			this.ball.position.z = i*40;// -wideload.Random.next()%450-50;
			this.ball.position.x = Math.sin(i/80*Math.PI*2)*60;//wideload.Random.nextFloat() < 0.5 ? -wideload.Random.next()%100 - 20 : wideload.Random.next()%100+20;
			this.ball.position.y = Math.cos(i/80*Math.PI*2)*60;// wideload.Random.nextFloat() < 0.5 ? -wideload.Random.next()%50 - 20 : wideload.Random.next()%50+20;
		//	this.scene.add(this.ball);
		}
		this.cubes = [];
		//Create main tunnel
		/*
		for(var j = 0; j < 3; j++)
		{
			/*var geometry = new THREE.CubeGeometry(10,30,10);
			var cube = new THREE.Mesh(geometry, material);
			cube.position.x = -40;
			cube.position.z = j*-300;
			this.scene.add(cube);
			*/
			/*
			
			var bottomGeom = new THREE.CubeGeometry(160, 5,300);
			var bottomCube = new THREE.Mesh(bottomGeom, wallMaterial);
			bottomCube.position.z = j*-300-300*1.7;
			bottomCube.position.y = -40;
			bottomCube.position.x = -0;
			bottomCube.visible = false;
			this.scene.add(bottomCube);
			this.cubes.push(bottomCube);
			
			var topGeom = new THREE.CubeGeometry(160, 5,300);
			var topCube = new THREE.Mesh(topGeom, wallMaterial);
			topCube.position.z = j*-300-300*1.7;
			topCube.position.y = 40;
			topCube.position.x = -0;
			topCube.visible = false;
			this.scene.add(topCube);
			this.cubes.push(topCube);
			
			var leftGeom = new THREE.CubeGeometry(5, 80,300);
			var leftCube = new THREE.Mesh(leftGeom, wallMaterial);
			leftCube.position.z = j*-300-300*1.7;
			leftCube.position.y = 0;
			leftCube.position.x = -80;
			leftCube.visible = false;
			this.scene.add(leftCube);
			this.cubes.push(leftCube);

			var rightGeom = new THREE.CubeGeometry(5, 80,300);
			var rightCube = new THREE.Mesh(rightGeom, wallMaterial);
			rightCube.position.z = j*-300-300*1.7;
			rightCube.position.y = 0;
			rightCube.position.x = 80;
			rightCube.visible = false;
			this.scene.add(rightCube);
			this.cubes.push(rightCube);

		}
		*/
		//TEstmaterial without lights
var pipeMaterial =
  		new THREE.MeshBasicMaterial (
    	{
      		color: 0x00FFFF
    	});

		var scn = this.scene;
		var pipe;
		loader = new THREE.OfflineJSONLoader();
		
    	loader.load( part4pipe, function( geometry ) {
        	mesh = new THREE.Mesh( geometry,wallMaterial );
        	geometry.computeBoundingBox();
        	var box = geometry.boundingBox;
        	mesh.scale.set( 15, 15, 20 );
        	mesh.position.y = 0;
        	mesh.position.x = 0;
        	mesh.position.z = -850;
        	scn.add( mesh );
        	pipe = mesh;
   		} );
   		this.pipe = pipe;
   		this.pipe.visible = false;

		//Twister
		var twisterGeometry = new THREE.CubeGeometry(80, 1, 80);
		var vertices = [];
		var faces = [];
		var off = 0;
		this.cubes2 = [];

		var twisterShaderMaterial = new THREE.ShaderMaterial({
		//	color:0x606060,
			wireframe: false,
			shading: 1,
			attributes: {},
			uniforms: {},
			vertexShader: wideload.TwisterShader.vertexShader,
			fragmentShader: wideload.TwisterShader.fragmentShader
		});
		/*
		twisterShaderMaterial = new THREE.MeshPhongMaterial({
			color:0xFF0000,
			wireframe: false,
			shading: 1,
			attributes: {},
			ambient:0x303030
		//	uniforms: this.twisterUniforms,
		//	vertexShader: wideload.TwisterShader.vertexShader,
		//	fragmentShader: wideload.TwisterShader.fragmentShader
		});*/
		

		for(var i = 0; i < 220; i++)
		{
			//Generate twister vertices
			var ver = twisterGeometry.vertices;
			var fac = twisterGeometry.faces;
			for(var j = 0; j < ver.length; j++)
			{
				var v = ver[j].clone();
				v.y = i;
				vertices.push(v);
			}
			for(var j = 0; j < fac.length; j++)
			{
				var f = fac[j].clone();
				f.a += off;
				f.b += off;
				f.c += off;
				f.d += off;
				faces.push(f);
			}
			off+=ver.length;
			this.twisterCube = new THREE.Mesh(twisterGeometry, twisterShaderMaterial);
			this.scene.add(this.twisterCube);
			this.twisterCube.position.y = -110+i;
			this.twisterCube.position.z = -100-300*5;
			this.twisterCube.position.x = 0;
			//this.twisterCube.rotation.y = i/100;
			this.twisterCube.visible = false;
			this.cubes2.push(this.twisterCube);
		}
		var endGeometry = new THREE.Geometry();
		endGeometry.faces = faces;
		endGeometry.vertices = vertices;
		this.twisterUniforms = {
			delta: {type: 'f', value:0.0},
			rm: {type: 'f', value:0},
			gm: {type: 'f', value:0},			
			bm: {type: 'f', value:0},
			collapse: {type: 'f', value:1},
			distance: {type: 'f', value:0}
		};
		
	}
	
	/**
	* Prepare the part for coming up next. This is called when previous effect notifies the main controller it is ready to end.
	* @param previous Previous part.
	*/
	p.prepare = function(elapsedtime,previous){
		this.main.renderer.setClearColor(0x400000);
		this.count = 0;
		this.swapCount = 600;
		this.sinC = 0;
	}
	
	/**
	* Previous effect has stopped playback. Start playback part.
	*/
	p.begin = function(elapsedtime){
		this.startTime = elapsedtime;
		this.timeFixCount = 0;
	}
	
	/**
	* Pre render action if required
	*/
	p.preRender = function(elapsedtime, timedelta){
		this.film.uniforms[ "time" ].value += 0.05;
		var tdc = 0;
		this.pipe.rotation.z += 0.0022*timedelta;
		this.sinC += timedelta;
		this.twisterUniforms.delta.value+=0.05;
		this.twisterUniforms.delta.value+=0.05;
		this.twisterUniforms.delta.value+=0.05;
		this.twisterUniforms.delta.value+=0.05;
		this.count+=0.5;
		this.timeFixCount+= 0.5*timedelta;
		this.ambient.color = new THREE.Color(0xFFFFFF);
		if(this.timeFixCount >= 150 && !this.dispRemoved)
		{
			this.dispRemoved = true;
			this.main.renderer.setClearColor(0xffffff);
			this.scene.remove(this.display);
		}
		if( elapsedtime - this.startTime > 26500)
		{
			this.swapCount+=0.5*timedelta;
			if(!this.pipe.visible)
			{
				this.pipe.visible = true;
				/*for(var i= 0; i < this.cubes.length; i++)
				{
					this.cubes[i].visible = true;
				}
				*/
				if(!this.parts34Cleared)
				{
					this.parts34Cleared=true
					this.part3.cleard(this.scene);
					this.part4.cleard(this.scene);
				}
			}
			
			this.film.uniforms[ "sCount" ].value = Math.min(1000,this.swapCount-300);
			this.film.uniforms[ "sIntensity" ].value = Math.min(500,this.swapCount-300)/500 *-0.8 + 0.9;
			this.film.uniforms[ "nIntensity" ].value = Math.min(500,this.swapCount-300)/500 *-0.2 + 0.3; 
			this.film.uniforms.grayscale.value = Math.min(500,this.swapCount-300)/500 *-1 + 1;;

			var c = (0xFF-0x15) * (750-this.swapCount)/150+0x15;
			this.ambient.color = new THREE.Color(c << 16 | c << 8 | c+Math.floor(0x15*(this.swapCount-600)/150));
			if(this.swapCount > 750)
			{
				this.ambient.color = new THREE.Color(0x151530);
			}
			}
		if(elapsedtime - this.startTime <= 26500)
		{
			this.film.uniforms[ "sCount" ].value = 300;
			this.film.uniforms[ "sIntensity" ].value = Math.min(0.9, 0.9-(80-this.timeFixCount)/80*0.9);
			this.film.uniforms[ "nIntensity" ].value = Math.min(0.3, 0.3 - (80-this.timeFixCount)/80*0.9); 
		//Drive the part where particles are only dancing
			this.uniforms.time.value += 0.01*timedelta;
			
			var td = (elapsedtime-this.startTime)/26500;
			tdc = 600 * td;
			//this.main.renderer.setClearColor(0x101010*Math.floor(this.count/25*15));
			
			var tx = Math.sin(tdc/140+1.4)*37+5;
			var ty = Math.cos(Math.sin(tdc/25+1.3)+tdc/40)*30;
			var tz = -td*600+Math.cos(tdc/50)*Math.sin(tdc/140)*80;
			
			var tx2 = Math.sin(tdc/141+1.45)*40+5;
			var ty2 = Math.cos(Math.cos(tdc/25+1.35)+tdc/81)*25;
			var tz2 = -td*600+Math.cos(tdc/30)*Math.sin(tdc/40)*120;
			if(td > 0.95)
			{
				
				tx = 0;
				ty = 0;
				tx2 = 0;
				ty2 = 0;
			}
			if(!this.pipe.visible)
			{
				var tx3 = Math.sin(tdc/60+0.5+Math.PI)*47;
				var ty3 = Math.cos(Math.cos(tdc/415+1)+tdc/81+Math.PI/2)*24+Math.max(0, (tdc-400)/1.5);
				var tz3 = -tdc+Math.cos(tdc/30+2)*Math.sin(tdc/40)*120;
				
				var tx4 = Math.sin(tdc/60+0.5)*42;
				var ty4 = Math.cos(Math.cos(tdc/415+1)+tdc/81)*24+Math.max(0, (tdc-400)/1.7);
				var tz4 = -tdc+Math.cos(tdc/30+2)*Math.sin(tdc/40)*120;
				if(elapsedtime - this.startTime > 350*8)
					this.part3.update(tx3,ty3,tz3,0,1);
				if(elapsedtime - this.startTime > 350*6)
					this.part4.update(tx4,ty4,tz4,0,1);
			}
			if(elapsedtime - this.startTime > 350*4)
				this.part2.update(tx2,ty2,tz2,0,1);
			if(elapsedtime - this.startTime > 350*2)
				this.part.update(tx,ty,tz,0,1);
			this.light.position.set(tx,ty,tz);
			this.light2.position.set(tx2,ty2,tz2);
			this.camera.position.z = -td*600 + 180;
		}
		
		else if( elapsedtime - this.startTime <  46500)
		{
			//Drive the tunnel part & the part where particles are only dancing
			this.uniforms.time.value += 0.08;
			
			var td = (elapsedtime-this.startTime-26500)/(46500-26500);
			if(td > 1.2 && !this.part12Clear)
			{
				this.part12Clear = true;
			//	this.part.cleard(this.scene);
			//	this.part2.cleard(this.scene);
			}
			tdc = td*900+600;
			//this.main.renderer.setClearColor(0x101010*Math.floor(this.count/25*15));
			this.foos = tdc;
			this.food = td;
			var tx = Math.sin(tdc/140)*4;
			var ty = Math.cos(Math.sin(tdc/25)+tdc/40)*4;
			var tz = -td*900+Math.cos(tdc/50)*Math.sin(tdc/140)*30-600+120;
			
			var tx2 = Math.sin(tdc/50+11)*7;
			var ty2 = Math.cos(Math.cos(tdc/45)+tdc/81)*4;
			var tz2 = -td*900+Math.cos(tdc/30)*Math.sin(tdc/40)*12-600+120;
			if(!this.pipe.visible)
			{
				var tx3 = Math.sin(tdc/50)*82+Math.max(0, (tdc-400)/1.5);
				var ty3 = Math.cos(Math.cos(tdc/45)+tdc/281)*74;
				var tz3 = -this.count+Math.cos(tdc/30)*Math.sin(tdc/40)*70;
				
				var tx4 = Math.sin(this.count/60+0.5)*62;
				var ty4 = Math.cos(Math.cos(this.count/415+1)+this.count/81)*84+Math.max(0, (this.count-400)/1.5);
				var tz4 = -this.count+Math.cos(this.count/30+2)*Math.sin(this.count/40)*120;
				this.part3.update(tx3,ty3,tz3,0,1);
				this.part4.update(tx4,ty4,tz4,0,1);
			}
			var ofs = td/0.1*0.55;
			if(ofs > 0.44)
				ofs = 0.44;
				this.ofs = ofs;
			this.part2.update(tx2,ty2,tz2,ofs,(ofs-0.44)/0.44);
			this.part.update(tx,ty,tz,ofs,(ofs-0.44)/0.44);
			this.light.position.set(tx,ty,tz);
			this.light2.position.set(tx2,ty2,tz2);
			this.camera.position.z = -td*900 + 180-600;
		}
		else
		{
			if(!this.creditsIn)
			{
				this.creditsIn = true;
				$("#code").delay(4600).fadeIn(400);
				$("#exca").delay(5600).fadeIn(400);
				$("#poro").delay(6000).fadeIn(400);
				$("#rimina").delay(6400).fadeIn(400);
				$("#music").delay(7000).fadeIn(400);
				$("#eclipser").delay(7400).fadeIn(400);
				$("#brownies").delay(3000).fadeIn(400);
			}
			var td = (elapsedtime-this.startTime-46500)/(16600);
			if(td > 1.06)
			{
			if(!this.dispReseted)
			{
				this.display.material.color = new THREE.Color(0);
				this.scene.add(this.display);
				this.display.position.z = this.cubes2[0].position.z+60;
				this.uniforms.time.value = 0;
				
				this.display.scale.x = 0.00;
				this.dispReseted = true;
			}
				this.display.scale.x+=0.004;
				if(this.display.scale.x > 1)
				this.display.scale.x = 1;
			}
			if(td > 1)
			{
				//End this really badly coded part :D
				for(var i =0; i < this.cubes2.length; i++)
				{
					var yo = this.csCount+i;
					//Normalize to range of 400
					var over = Math.floor(yo/400);
					yo = yo - over*400;
					if(!this.cubes2[i].rtarget)
					{
						this.cubes2[i].rtarget = Math.round(this.cubes2[i].rotation.y / Math.PI/2)*Math.PI/2;
						if(this.cubes2[i].rtarget == 0 ||this.cubes2[i].rtarget == Math.PI)
						{
							this.cubes2[i].rtarget = Math.PI/2
						}
						//this.cubes2[i].rtarget = Math.PI+Math.PI/2;
						
					}
					this.cubes2[i].rotation.y += (this.cubes2[i].rtarget-this.cubes2[i].rotation.y)/14*timedelta;
					
					var yo = this.count+i;
					//Normalize to range of 400
					var over = Math.floor(yo/200);
					yo = yo - over*200;
					this.cubes2[i].visible = true;
				//	this.cubes2[i].rotation.y += Math.sin(tdc/32+yo/50)/20;
					
					if(!this.credsfadedout)
					{
				$("#code").fadeOut(400);
				$("#exca").fadeOut(400);
				$("#poro").fadeOut(400);
				$("#rimina").fadeOut(400);
				$("#music").fadeOut(400);
				$("#eclipser").fadeOut(400);
				$("#brownies").fadeOut(400);
				this.credsfadedout = true;
					}
				}
				
			}
			else
			{
			var td = (elapsedtime-this.startTime-68500)/(4000);			
			tdc = 900+600 + td*400;
			tdc = this.foos++;
			td = this.food++;
				//Drive the twister part
				var tx = Math.sin(tdc/140)*4;
			var ty = Math.cos(Math.sin(tdc/25)+tdc/40)*4;
			var tz = -td*900+Math.cos(tdc/50)*Math.sin(tdc/140)*30-600+120;
			
			var tx2 = Math.sin(tdc/50+11)*7;
			var ty2 = Math.cos(Math.cos(tdc/45)+tdc/81)*4;
			var tz2 = -td*900+Math.cos(tdc/30)*Math.sin(tdc/40)*12-600+120;
			this.part.scene = this.scene;
			this.part2.scene = this.scene;
				this.part.fadeOut();
				this.part2.fadeOut();
				
				
						this.part2.update(tx2,ty2,tz2,this.ofs,(this.ofs-0.44)/0.44);
			this.part.update(tx,ty,tz,this.ofs,(this.ofs-0.44)/0.44);
	this.light.position.set(tx,ty,tz);
				this.light2.position.set(tx2,ty2,tz2);
			//	this.camera.position.z = -this.count + 180;
			if(td > 0.04)
			 {
			 var tdc = td*200;
			 if(!this.csCount)
				this.csCount = 100;
				this.csCount++;
				for(var i =0; i < this.cubes2.length; i++)
				{
					var yo = this.csCount+i;
					//Normalize to range of 400
					var over = Math.floor(yo/220);
					yo = yo - over*220;
					this.cubes2[i].visible = true;
					this.cubes2[i].rotation.y += Math.sin(this.csCount/42+yo/70)/30;
					
				//	this.cubes2[i].position.y = 200-yo;
				
					
				}
				}
			}
		}
	}
	
	/**
	* Main controller calls render function
	* @param renderTarget The rendertarget to render to
	*/
	p.render = function(elapsedtime){
		//this.main.renderer.render(this.scene, this.camera, this.renderTarget);
		this.composer.render();
	}
	
	/**
	* Post render if required. Postprocessing actions can be done here for example.
	* @param renderTarget The rendertarget for final image. It is different than the one given in render-function.
	*/
	p.postRender = function(elapsedtime){
		
	}
	
	/**
	* Ending is near. Start animating ending if necessary
	* @param next part
	*/
	p.prepareEnd = function(elapsedtime,next){
		
	}

	/**
	* Order to end the part
	*/
	p.endPart = function(elapsedtime){
	
	}
	
}())