//Namespace
this.wideload = this.wideload || {};

(function(){
	var Building = function(topLeft, bottomLeft,bottomRight, topRight){
		this.topLeft = topLeft;
		this.bottomLeft = bottomLeft;
		this.topRight = topRight;
		this.bottomRight = bottomRight;

	}
	wideload.Building = Building;

	Building.prototype.BuildLine = function(material){
		var vertices = this.BuildVertices();
		var geometry = new THREE.Geometry();
		for(var i = 0; i < vertices.length; ++i){
			geometry.vertices.push(vertices[i]);
		}
		return new THREE.Line(geometry, material);
	}

	Building.prototype.BuildVertices = function BuildVertices(){
		var vertices = [];
		vertices.push(this.topLeft);
		vertices.push(this.bottomLeft);
		vertices.push(this.bottomRight);
		vertices.push(this.topRight);
		vertices.push(this.topLeft);
		return vertices;
	}

	Building.prototype.BuildMesh = function (extrudeSettings, material){
		
		var vertices = this.BuildVertices();
		var starPoints = [];
	
	starPoints.push( new THREE.Vector2 (   0,  5 ) );
	starPoints.push( new THREE.Vector2 (  1,  1 ) );
	starPoints.push( new THREE.Vector2 (  4,  10 ) );
	starPoints.push( new THREE.Vector2 (  2, -1 ) );
	starPoints.push( new THREE.Vector2 (  3, -5 ) );
	starPoints.push( new THREE.Vector2 (   0, -2 ) );
	starPoints.push( new THREE.Vector2 ( -3, -5 ) );
	starPoints.push( new THREE.Vector2 ( -2, -1 ) );
	starPoints.push( new THREE.Vector2 ( -4,  1 ) );
	starPoints.push( new THREE.Vector2 ( -1,  1 ) );
		//vertices.pop(); // Viimeisessä on eka vertice vaan uusiksi
		var shape = new THREE.Shape(vertices);
		var geometry = new THREE.ExtrudeGeometry(shape, extrudeSettings);
		geometry.applyMatrix( new THREE.Matrix4().makeRotationX(-Math.PI/2));
		var mesh = new THREE.Mesh(geometry, material);
		//mesh.position = new THREE.Vector3(0,0,0);
		//mesh.rotation.z = 15;
		return mesh;
	}
}())