//Namespace
this.wideload = this.wideload || {};

/**
* Pulse Part 
*/

(function(){
	
	/**
	* Constructor
	* @param beginTime When the effect should start
	* @param prepareTime How long should the effect be allowed to stay in prepare phase (visible during previous parts end phase).
	         Value of 0 indicates immediate change. The endtime for previous part is the same as this parts prepare. First part has no prepare.
	*/
	var PulsePart = function(beginTime, prepareTime, main){
		this.beginTime = beginTime;
		this.prepareTime = prepareTime;
		this.renderer = null; //Renderer is given from outside.
		this.main = main;
	} 
	//Expose class
	wideload.PulsePart = PulsePart;
	
	var p = PulsePart.prototype = new wideload.BasePart();
	
	/**
	* Initialize the part. This is called during page load.
	*/
	p.initialize = function(){
		this.renderTarget = new THREE.WebGLRenderTarget(this.main.resolution[0], this.main.resolution[1]);
    	this.scene = new THREE.Scene();
		this.camera = new THREE.PerspectiveCamera(50,1,0.1,10000);
		this.camera.position.z = 100;
		this.camera.position.y = 100;
		this.camera.position.x = 50;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		this.scene.add(this.camera);

		this.lines = [];
		this.blocks = [];
		this.wireframes = [];
		var extrudeSettings = {
			amount:100,
			size: 3, height: 4, curveSegments: 3,
			bevelThickness: 1, bevelSize: 2, bevelEnabled: false,
			material: 0, extrudeMaterial: 1
		};
		var plane = new THREE.Mesh(new THREE.PlaneGeometry(100, 100), new THREE.MeshNormalMaterial());
		plane.applyMatrix( new THREE.Matrix4().makeRotationX(-Math.PI/2));
		plane.position = new THREE.Vector3(0,-1,0);
		this.scene.add(plane);
		var j = 0;
		var k = 0;
		this.minX = 0;
		this.maxX = 0;
		this.minZ = 0;
		this.maxZ = 0;
		this.time = 0;

var material = new THREE.LineBasicMaterial({
        color: 0xff00ff
    });

		var g = new THREE.Geometry();
		g.vertices.push(new THREE.Vector3(-100,0,0));
		g.vertices.push(new THREE.Vector3(100,0,0));
		var l = new THREE.Line(g, material);
		this.scene.add(l);
			
		var g = new THREE.Geometry();
		g.vertices.push(new THREE.Vector3(0,0,100));
		g.vertices.push(new THREE.Vector3(0,0,-100));
		var l = new THREE.Line(g, material);
		this.scene.add(l);

		this.circle = DrawCircle(0,this.scene);
		this.circle2 = DrawCircle(0,this.scene);

		var startz = -30;
		var startx = -30;
		for(var i = 1; i < 100; ++i){
			var topleft = new THREE.Vector2(0,0);
			var topright = new THREE.Vector2(4,0);
			var bottomleft = new THREE.Vector2(0,4);
			var bottomright = new THREE.Vector2(4,4);
			var line = new wideload.Line(topleft,topright); 
			var geometry = new THREE.Geometry();
			geometry.vertices.push(line.start);
			geometry.vertices.push(line.end);
			this.lines.push(line);
			var line = new THREE.Line(geometry);
		//	this.scene.add(line);
			if(i%10 == 0){
				j++;
				k = 0;
			}

				var building = new wideload.Building(topleft,bottomleft,bottomright,topright);
				var line = building.BuildLine();
				this.scene.add(line);
				var mesh = building.BuildMesh(extrudeSettings,new THREE.MeshBasicMaterial( { color: 0xffff00 } ));
				var wmesh = building.BuildMesh(extrudeSettings,new THREE.MeshBasicMaterial({wireframe: true, color: 0xff000000}));
				mesh.position = new THREE.Vector3(startx+k*6,-100,startz+j*6);
				mesh.speed = Math.random()/2 + 1.5;
				wmesh.position = new THREE.Vector3(startx+k*6,-100,startz+j*6);

				if(mesh.position.x < this.minX){
					this.minX = mesh.position.x;
				}
				if(mesh.position.z > this.minZ){
					this.minZ = mesh.position.z;
				}
				if(mesh.position.x > this.maxX){
					this.maxX = mesh.position.x;
				}
				if(mesh.position.z > this.maxZ){
					this.maxZ = mesh.position.z;
				}
				this.scene.add(mesh);
				this.scene.add(wmesh)
				this.blocks.push(mesh);
				this.wireframes.push(wmesh);
				mesh.starty = mesh.position.y;
			++k;
			
		}
	}
	
	/**
	* Prepare the part for coming up next. This is called when previous effect notifies the main controller it is ready to end.
	* @param previous Previous part.
	*/
	p.prepare = function(elapsedtime,previous){
    //miksi tätä ei kutsuta koskaan?
	}
	
	
	/**
	* Previous effect has stopped playback. Start playback part.
	*/
	p.begin = function(elapsedtime){
	
	}
	
	/**
	* Pre render action if required
	*/
	p.preRender = function(elapsedtime){
		var origo = new THREE.Vector3((this.maxX - this.minX)/2,0, (this.maxZ - this.minZ)/2)
    	var maxHeight = 50;
    	var pulseWidth = 2;
    	this.time += 0.5;
    	var pulseRadius = this.time % (this.maxX-this.minX);
    	this.scene.remove(this.circle);
    	this.circle = DrawCircle(pulseRadius,this.scene);

    	this.scene.remove(this.circle2);
    	this.circle2 = DrawCircle(pulseRadius + pulseWidth,this.scene);

		for(var i = 0; i < this.blocks.length;++i){
			var block = this.blocks[i];
			var wireframe = this.wireframes[i];
			block.direction = 0;

			var center = getCenter(block);
			center.x = Math.abs(center.x);
			center.z = Math.abs(center.z);
			/*
			if(center.x >= pulseRadius && center.x <= pulseRadius + pulseWidth)
			{
				block.direction = 1;
		//		else
				{
			//		block.direction = -1;	
				}
			}
			else if(center.z >= pulseRadius && center.z <= pulseRadius + pulseWidth)
				{
					block.direction = 1;
				}*/
				block.direction = undefined;
			if(center.x < pulseRadius && center.z < pulseRadius)
			{
				block.direction = 1;
			}
			if(center.x < pulseRadius - pulseWidth && center.z < pulseRadius - pulseWidth)
			{
				block.direction = -1;
			}
			if(block.direction != undefined && block.position.y >= block.starty)
			{
				if(block.position.y + block.direction * block.speed > block.starty)
				{
					block.position.y = block.position.y + block.direction * block.speed;
				}
			}
			if(block.position.y > -30){
			//	block.position.y = block.starty;
			}
			wireframe.position.y = block.position.y;
		}
    
	}

	function DrawCircle(radius, scene){
		var resolution = 100;
		var amplitude = radius;
		var size = 360 / resolution;

		var geometry = new THREE.Geometry();
		var material = new THREE.LineBasicMaterial( { color: 0xFF00FF} );
		for(var i = 0; i <= resolution; i++) 
		{
    		var segment = ( i * size ) * Math.PI / 180;
    		geometry.vertices.push( new THREE.Vector3( Math.cos( segment ) * amplitude, 0, Math.sin( segment ) * amplitude ) );
    	}

    	var line = new THREE.Line( geometry, material );
		scene.add(line);
    	return line;
	}


	function getCenter(mesh){
		mesh.geometry.computeBoundingBox();
		var box = mesh.geometry.boundingBox;
		var x = Math.abs(mesh.position.x) + Math.abs(box.min.x + box.max.x)/2;
		var y = Math.abs(mesh.position.y) + Math.abs(box.min.y + box.max.y)/2;
		var z = Math.abs(mesh.position.z) + Math.abs(box.min.z + box.max.z)/2;
		return new THREE.Vector3(x,y,z);
	}

	/**
	* Main controller calls render function
	* @param renderTarget The rendertarget to render to
	*/
	p.render = function(elapsedtime){
		this.main.renderer.render(this.scene, this.camera, this.renderTarget);
	}
	
	/**
	* Post render if required. Postprocessing actions can be done here for example.
	* @param renderTarget The rendertarget for final image. It is different than the one given in render-function.
	*/
	p.postRender = function(elapsedtime,renderTarget){
		
	}
	
	/**
	* Ending is near. Start animating ending if necessary
	* @param next part
	*/
	p.prepareEnd = function(elapsedtime,next){
		
	}

	/**
	* Order to end the part
	*/
	p.endPart = function(elapsedtime){
	
	}
	
}())