//Namespace
this.wideload = this.wideload || {};

/**
* Part 1 
*/

(function(){
	
	/**
	* Constructor
	* @param beginTime When the effect should start
	* @param prepareTime How long should the effect be allowed to stay in prepare phase (visible during previous parts end phase).
	         Value of 0 indicates immediate change. The endtime for previous part is the same as this parts prepare. First part has no prepare.
	         */
	         var ReefPart = function(beginTime, prepareTime, main){
	         	this.beginTime = beginTime;
	         	this.prepareTime = prepareTime;
				this.renderer = null; //Renderer is given from outside.
				this.main = main;

				this.camerapositions = [];

				this.transitiontime = 0;
				this.nextPosition = 1;

				this.camerapositions.push(new THREE.Vector3(0,130,0));
				this.camerapositions.push(new THREE.Vector3(100,25,-90));
				this.camerapositions.push(new THREE.Vector3(-80,40,-110));
				this.camerapositions.push(new THREE.Vector3(-90,55,-200));
				this.camerapositions.push(new THREE.Vector3(-130,95,-180));
				this.camerapositions.push(new THREE.Vector3(-120,35,-80));
				this.camerapositions.push(new THREE.Vector3(-80,65,-40));
				this.camerapositions.push(new THREE.Vector3(1,5,-151));

				this.lookAts = [];
				this.lookAts.push(new THREE.Vector3(0,5,-60));
				this.lookAts.push(new THREE.Vector3(50,15,-100));
				this.lookAts.push(new THREE.Vector3(-110,25,-140));
				this.lookAts.push(new THREE.Vector3(-30,35,-220));
				this.lookAts.push(new THREE.Vector3(-100,12,-50));
				this.lookAts.push(new THREE.Vector3(-100,5,-50));
				this.lookAts.push(new THREE.Vector3(-20,5,-150));
				this.lookAts.push(new THREE.Vector3(2,5,-153));

				this.ballPosition = new THREE.Vector3(0,95,-150);



				this.ballpositions = [];
				this.ballpositions.push(new THREE.Vector3(0,135,-6000));
				this.ballpositions.push(new THREE.Vector3(-50,135,-8000));
				this.ballpositions.push(new THREE.Vector3(-150,135,-7000));
				this.ballpositions.push(new THREE.Vector3(-190,135,-32000));
				this.ballpositions.push(new THREE.Vector3(-20,135,-5000));
				this.ballpositions.push(new THREE.Vector3(-30,135,-15000));
				this.ballpositions.push(new THREE.Vector3(0,135,-15020));


	}
	//Expose class
	wideload.ReefPart = ReefPart;
	
	var p = ReefPart.prototype = new wideload.BasePart();
	
	/**
	* Initialize the part. This is called during page load.
	*/
	p.initialize = function(){
		this.renderTarget = new THREE.WebGLRenderTarget(this.main.resolution[0], this.main.resolution[1]);

		this.scene = new THREE.Scene();
		this.elapsedtime = 0;
		this.scene.fog = new THREE.Fog( 0x20A092, 0.05,250 );
		this.balls = [];
		var texture = new THREE.Texture(soilTexture);
		texture.needsUpdate = true;

		var soilMaterial = new THREE.MeshLambertMaterial({
			map: texture,
			side: THREE.DoubleSide,
		});

		this.balluniforms = {
			delta: {type: 'f', value:0.0},
			rm: {type: 'f', value:1.0},
			gm: {type: 'f', value:1.0},			
			bm: {type: 'f', value:1.0},
			size: {type:'f',value:1},
		};
		this.material = new THREE.ShaderMaterial({
			color:0x606060,
			wireframe: false,
			side: THREE.DoubleSide,
			shading: 1,
			attributes: {},
			uniforms: this.balluniforms,
			vertexShader: wideload.BallVertexShader.vertexShader,
			fragmentShader: wideload.BallVertexShader.fragmentShader
		});

		this.ballsMaterial = new THREE.MeshLambertMaterial({
			color: 0x0c0c00,
		});
		var geometry = new THREE.IcosahedronGeometry(5,3);
		
		this.ball = new THREE.Mesh(geometry, this.material);
		this.ball.position = this.ballPosition;
		//this.scene.add(this.ball);


		this.uniforms = {
			time: {type: 'f', value:0.0},
		};
		loader = new THREE.OfflineJSONLoader();
		var scene = this.scene;
		//reefland is loaded separetaly
    	loader.load( reefland, function( geometry ) {
        	mesh = new THREE.Mesh( geometry, soilMaterial );
        	geometry.computeBoundingBox();
        	var box = geometry.boundingBox;
        	mesh.scale.set( 5, 5, 5 );
        	mesh.position.y = 20;
        	mesh.position.x = (box.max.x-box.min.x)/2;
        	mesh.position.z = (box.max.z-box.min.z)/2;
        	scene.add( mesh );
   		} );

   		for(var i = 0; i < 7; ++i){
   			var position = this.ballpositions[i];
   			var ballGeom = new THREE.IcosahedronGeometry(5,3);
   			var mesh = new THREE.Mesh(ballGeom, this.ballsMaterial);
   			mesh.position = position;
   		//	this.scene.add(mesh);
   		}
		
		this.camera = new THREE.PerspectiveCamera(50,1,0.1,2000);

//controls = new THREE.OrbitControls( this.camera);
//controls.addEventListener( 'change', this.render ); 

		//this.camera = new THREE.OrthographicCamera(this.minX,this.maxX, this.maxY, this.minY);
		this.camera.position = this.camerapositions[0];
		this.camera.lookAt(this.lookAts[0]);
		this.camera.look = this.lookAts[0];
		this.lookat = new THREE.Vector3(0,15,-10);
		this.scene.add(this.camera);

		this.count = 0;
		this.random = wideload.Random;

    	this.baseLines = []; // bottom lines, saved for color transformation or something like that
    	this.linesAlive = [];
    	this.reefs = [];
    	this.lights = [];

    	this.timeFromLastSpawn = 0;
    	this.time = 0;

    	var valot = [];
    	valot.push(0x22aaaa);
    	valot.push(0x448844);
    	valot.push(0x5555FF);
    	// add subtle ambient lighting
    	for(var i = 0; i < 3;++i)
    	{
    		var light = new THREE.DirectionalLight(valot[i],2,20.0);
    		light.speed = i*1.2+1.5;
    		light.position = new THREE.Vector3(0.01,0.01,0.01);
			this.scene.add(light);	
			this.lights.push(light);
    	}

		
    this.brightnessEffect = new THREE.ShaderPass(THREE.BrightnessContrastShader);
		// Add underwater shader
		this.composer = new THREE.EffectComposer(this.main.renderer,this.renderTarget);
		this.composer.addPass(new THREE.RenderPass(this.scene, this.camera));
		this.composer.addPass(this.brightnessEffect);
		this.underwaterEffect = new THREE.ShaderPass(wideload.underwaterShader);
		this.composer.addPass(this.underwaterEffect);
		this.brightnessEffect.uniforms.brightness.value = -1.0;
		this.brightnessEffect.uniforms.contrast.value = 1.0;

	}

function buildHelpLines(scene){
	var material = new THREE.LineBasicMaterial({
		color: 0xff00ff
	});
	var g = new THREE.Geometry();
	g.vertices.push(new THREE.Vector3(-100,0,0));
	g.vertices.push(new THREE.Vector3(100,0,0));
	var l = new THREE.Line(g, material);
	scene.add(l);

	var g = new THREE.Geometry();
	g.vertices.push(new THREE.Vector3(0,100,00));
	g.vertices.push(new THREE.Vector3(0,-100,00));
	var l = new THREE.Line(g, material);
	scene.add(l);

	var g = new THREE.Geometry();
	g.vertices.push(new THREE.Vector3(0,0,100));
	g.vertices.push(new THREE.Vector3(0,0,-100));
	var l = new THREE.Line(g, material);
	scene.add(l);
}


	/**
	* Prepare the part for coming up next. This is called when previous effect notifies the main controller it is ready to end.
	* @param previous Previous part.
	*/
	p.prepare = function(elapsedtime,previous){
		//tämän on tässä siksi, että Part2:n pallo erottuisi
		//taustasta paremmin.
		this.main.renderer.setClearColor(0x20A092);
	}
	
	
	/**
	* Previous effect has stopped playback. Start playback part.
	*/
	p.begin = function(elapsedtime){
		this.prevTime = Date.now();
		this.main.effectBloom.materialCopy.uniforms.opacity.value = 0.1;

	}
	
	/**
	* Pre render action if required
	*/
	p.preRender = function(elapsedtime,td,timeSpent){
		//this.main.drumDelta;
		//this.main.otherDelta;
		var lightI = Math.floor(wideload.Random.nextFloat()*3);
		this.lights[lightI].intensity = 2 + 2.5*this.main.drumDelta;
		if(this.brightnessEffect.uniforms.brightness.value < -0.12 && this.fadeinDone == undefined){
			this.brightnessEffect.uniforms.brightness.value += 0.01*td;
			this.brightnessEffect.uniforms.contrast.value -= 0.01*td;
		}
		else{
			this.fadeinDone = true;
		}
		if(elapsedtime > 76800)
		{
			this.brightnessEffect.uniforms.brightness.value -= 0.01*td;
			this.brightnessEffect.uniforms.contrast.value += 0.01*td;
			if(this.brightnessEffect.uniforms.brightness.value < -1)
				this.brightnessEffect.uniforms.brightness.value = -1;
		}
		this.balluniforms.delta.value+=0.05*td;
		this.uniforms.time += elapsedtime;
		this.time++;
		for(var i = 0; i < this.lights.length; ++i){
			var light = this.lights[i];
			//var fish = this.fishes[i]
			var previousposition = new THREE.Vector3(light.position.x, light.position.y, light.position.z);
			light.position.z = light.speed*(60)*Math.cos(10+i*10 + this.time/(150))*td;
			light.position.x = light.speed*(60)*Math.sin(10+i*10 + this.time/(150*(i+3)))*td;
			//fish.position.z = light.position.z;
			//fish.position.x = light.position.x;
			//var heading = light.position.clone().sub(previousposition);
			//fish.rotation.y = heading.z + heading.x;

		}
		
		if(this.nextPosition == 7 && this.ball.position.y >= 5){
			this.ball.position.y -= 0.5*td;
		}
		else if(this.nextPosition == 7){
			// fadeout
		//	this.brightnessEffect.uniforms.brightness.value -= 0.02*td;
		//	this.brightnessEffect.uniforms.contrast.value += 0.02*td;
		}

		var transitionlength = 5000;
		this.elapsedtime += timeSpent;
		this.enabled = true;
		if(this.enabled == undefined && this.elapsedtime >= 1000){
			
			this.elapsedtime = 0;
		}
		if(this.enabled && this.nextPosition < this.camerapositions.length)
		{
			var cameraTarget = this.camerapositions[this.nextPosition];
			var curpos = this.camera.position;
			var cameraLookAtTarget = this.lookAts[this.nextPosition];
			var curlook = this.camera.look;

			var dxC = (cameraTarget.x-curpos.x)*(timeSpent)/(transitionlength-this.elapsedtime);
			var dyC = (cameraTarget.y-curpos.y)*(timeSpent)/(transitionlength-this.elapsedtime);
			var dzC = (cameraTarget.z-curpos.z)*(timeSpent)/(transitionlength-this.elapsedtime);
			this.camera.position.x += dxC;
			this.camera.position.y += dyC;
			this.camera.position.z += dzC;

			var dxL = (cameraLookAtTarget.x-curlook.x)*(timeSpent)/(transitionlength-this.elapsedtime);
			var dyL = (cameraLookAtTarget.y-curlook.y)*(timeSpent)/(transitionlength-this.elapsedtime);
			var dzL = (cameraLookAtTarget.z-curlook.z)*(timeSpent)/(transitionlength-this.elapsedtime);
			this.camera.look.add(new THREE.Vector3(dxL,dyL,dzL));
			this.camera.lookAt(this.camera.look);
			if(this.shake > 0){
				this.shake--;
				//this.lights[0].intensity--;
				//this.lights[0].intensity = Math.max(this.lights[0].intensity,3.0);
				this.camera.position.x += (0.5 - wideload.Random.nextFloat())
				this.camera.position.z += (0.5 - wideload.Random.nextFloat())
				this.camera.position.z += (0.5 - wideload.Random.nextFloat())
			}
			if(this.elapsedtime > transitionlength){
				this.camera.position = this.camerapositions[this.nextPosition];
				this.camera.look = this.lookAts[this.nextPosition];
				this.camera.lookAt(this.camera.look);
				this.camerapositions[this.nextPosition-1] = this.camera.position;
				this.lookAts[this.nextPosition-1] = this.camera.look;
				this.nextPosition++;
				this.shake = 15;
				//this.lights[0].intensity = 9;
				this.elapsedtime = 0;
				console.debug("Next camera position: " + this.nextPosition);
			}
		}

	}

    p.Buildreef = function(position){
    	var reef = BuildLineWithShader(position);
    	for(var i = 0; i < 6;++i){
			// Lets add more vertices.
			reef.geometry.vertices.push(reef.geometry.vertices[0].clone());	
		}
		reef.length = 0;
		this.reefs.push(reef);
		this.scene.add(reef);
	}

	/**
	* Main controller calls render function
	* @param renderTarget The rendertarget to render to
	*/
	p.render = function(elapsedtime){
		//this.main.renderer.render(this.scene, this.camera, this.renderTarget);
		this.composer.render();
	}
	
	/**
	* Post render if required. Postprocessing actions can be done here for example.
	* @param renderTarget The rendertarget for final image. It is different than the one given in render-function.
	*/
	p.postRender = function(elapsedtime){
		
	}
	
	/**
	* Ending is near. Start animating ending if necessary
	* @param next part
	*/
	p.prepareEnd = function(elapsedtime,next){
		
	}

	/**
	* Order to end the part
	*/
	p.endPart = function(elapsedtime){

	}
	
}())