(function()
{
	var Tentacles = function()
	{
		
	}
	
	var p = Tentacles.prototype;
	
	p.init = function()
	{
		this.group = new THREE.Object3D();
		
		this.uniforms = {
			delta: {type: 'f', value:0.0},
			rm: {type: 'f', value:0},
			gm: {type: 'f', value:0},			
			bm: {type: 'f', value:0},
			collapse: {type: 'f', value:1},
			distance: {type: 'f', value:0}
		};
		this.materials = [];
		var material = new THREE.ShaderMaterial({
		//	color:0x606060,
			wireframe: false,
			shading: 1,
			attributes: {},
			uniforms: this.uniforms,
			vertexShader: wideload.TentacleShader.vertexShader,
			fragmentShader: wideload.TentacleShader.fragmentShader
		});
		
		var materialBall = new THREE.MeshLambertMaterial({
		
		  color : 0xFFFFFF,
		  eimissive : 0x000033,
		  ambient : 0x000033
		});
		this.balls = [];
		
		this.group.material = material;
		var geometry = new THREE.IcosahedronGeometry(4,0);
		var center = new THREE.Mesh(geometry, material);
		this.group.add(center);
		
		this.legs = [[],[],[],[],[],[],[]];
		for(var i = 0; i < 3; i++)
		{
			for(var j = 0; j < 2*9+1; j++)
			{
			
				if(j != 10)
				{
					var am = wideload.Random.next()%4;
					for(var k =0 ; k < am; k++)
					{
						geometry = new THREE.IcosahedronGeometry(4-k,0);
						var material2 = new THREE.ShaderMaterial({
						//	color:0x606060,
								wireframe: false,
								shading: 1,
								attributes: {},
								uniforms:  {
						delta: {type: 'f', value:3.0},
						rm: {type: 'f', value:0},
						gm: {type: 'f', value:0},			
						bm: {type: 'f', value:0},
						collapse: {type: 'f', value:1},
						distance: {type: 'f', value:(j>10?j-11:j-10)*3}
					},
						vertexShader: wideload.TentacleShader.vertexShader,
						fragmentShader: wideload.TentacleShader.fragmentShader
					});
					this.materials.push(material2);
			
						var ball = new THREE.Mesh(geometry, material2);
						if(i == 0)
							ball.position.x = (j>10?j-11:j-9)*3;
						else if(i==1)
							ball.position.y = (j>10?j-11:j-9)*3;
						else
							ball.position.z = (j>10?j-11:j-9)*3;
						if(k > 0)
						{
							ball.position.x += k*(wideload.Random.nextFloat()-0.5)*5;
							ball.position.y += k*(wideload.Random.nextFloat()-0.5)*5;
							ball.position.z += k*(wideload.Random.nextFloat()-0.5)*5;
							
						}
						this.balls.push(ball);
						this.group.add(ball);
						if(j < 10)
						{
							this.legs[i*2].push(ball);
						}
						else
						{
							this.legs[i*2+1].push(ball);
						}
					}
				}
			}
		}
		this.collapseDelta = 0.95;
		this.count = 0;
		this.endcount = 0;
	}
	
	p.update = function(rm,gm,bm,end,td)
	{
		this.uniforms.delta.value += 0.05*td;
/*		
		if(wideload.Random.next()%40 == 0)
		{
			var randomLeg = wideload.Random.next()%6;
//			console.log(this.legs[randomLeg]);
			for(var j = 0; j < this.legs[randomLeg].length; j++)
			{
			var s = this;
			window.setTimeout(
				function(ind){
				return function(){
				s.legs[randomLeg][ind].material.uniforms.rm.value = rm;
				s.legs[randomLeg][ind].material.uniforms.gm.value = gm;
				s.legs[randomLeg][ind].material.uniforms.bm.value = bm;
				}}(j),40*(10-j));
			}
		}*/
		this.count++;
		for(var i =0 ; i < this.materials.length; i++)
		{
			this.materials[i].uniforms.delta.value +=0.05*td;
			
			if(end)
			{
			this.endcount++;
				this.balls[i].position.x *= this.collapseDelta;
				this.balls[i].position.z *= this.collapseDelta;
				this.balls[i].position.y *= this.collapseDelta;
				if(this.count%4==0 && this.endcount > 400)
				{
					this.balls[i].position.x *= 0.4+this.collapseDelta;
					this.balls[i].position.z *= 0.4+this.collapseDelta;
					this.balls[i].position.y *= 0.4+this.collapseDelta;
				}
				this.collapseDelta -= 0.000005;
			}
			if(this.count%50 == 0)
			{
				var s = this;
				for(var randomLeg = 0; randomLeg < 6; randomLeg++)
				{
					for(var ind = 0; ind < s.legs[randomLeg].length; ind++)
					{
						s.legs[randomLeg][ind].material.uniforms.rm.value = rm;
						s.legs[randomLeg][ind].material.uniforms.gm.value = gm;
						s.legs[randomLeg][ind].material.uniforms.bm.value = bm;
					}
				}
			}
			
			
			this.materials[i].uniforms.rm.value = Math.max(0,this.materials[i].uniforms.rm.value-0.03*td);
			this.materials[i].uniforms.gm.value = Math.max(0,this.materials[i].uniforms.gm.value-0.03*td);
			this.materials[i].uniforms.bm.value = Math.max(0,this.materials[i].uniforms.bm.value-0.03*td);
		
		}
		this.group.rotation.x+=0.004*td;
		this.group.rotation.z += 0.002*td;
		this.group.rotation.y += 0.003*td;
	}
	
	p.clearColors = function()
	{
for(var i =0 ; i < this.materials.length; i++)
		{
			
			this.materials[i].uniforms.rm.value = 0;
			this.materials[i].uniforms.gm.value = 0;
			this.materials[i].uniforms.bm.value = 0;
		
		}		
	}
	
	wideload.Tentacles = Tentacles;
	
}())