#version 330

layout( location = 0 ) in vec3 InVertex;
layout( location = 1 ) in vec3 InTexCoord;
layout( location = 2 ) in vec3 InNormal;

out vec4 vVertexPos;

uniform mat4 ViewMatrix;
uniform mat4 ProjectionMatrix;
uniform mat4 ModelMatrix;

void main()
{
	vVertexPos = ProjectionMatrix * ViewMatrix * ModelMatrix * vec4( InVertex, 1.0 );
	gl_Position = vVertexPos;
}