#version 330

in vec3 vNormal;
in vec3 vEye;
in vec2 vTexCoord;
in vec4 vVertexPos;

out vec4 out_Color;

//uniform sampler2D uBumpSampler;
uniform sampler2D uRefractionSampler;
uniform samplerCube uReflectionSampler;
uniform vec4 uDiffuse;

float Fresnel( float NdotL, float fresnelBias, float fresnelPow )
{
	float facing = ( 1.0 - NdotL );
	return max( fresnelBias + ( 1.0 - fresnelBias ) * pow( facing, fresnelPow ), 0.0 );
}

void main()
{
	vec3 eyePos = normalize( vEye );
	
	//Reflection
	vec3 reflectionVector = reflect( eyePos, normalize( vNormal ) );
	vec4 reflectionColor = texture( uReflectionSampler, reflectionVector );
	//reflectionColor.rgb /= 2.0;
	
	//Bump
	vec3 bumpVector = reflectionVector.xyz;//-normalize( vNormal );//2.0 * texture( uBumpSampler, vTexCoord.xy ).xyz - 1.0;
	bumpVector = normalize( bumpVector * vec3( 0.2 ) );
	float LdotN = dot( bumpVector, eyePos );
	
	//Refraction
	vec2 screenTexCoord = ( ( vVertexPos.xy / vVertexPos.w ) + 1.0 ) / 2.0;
	vec4 refA = texture( uRefractionSampler, screenTexCoord + bumpVector.xy );
	vec4 refB = texture( uRefractionSampler, screenTexCoord );
	
	vec4 refractionColor = refB * refA.w + refA * ( 1.0 - refA.w );
	
	vec4 diffuse2 = vec4( 1.0, 1.0, 0.0, 0.5 );
	float fresnel = Fresnel( LdotN, 0.4, 4.0 );
	vec4 diffuse = clamp( 0.1 + uDiffuse * 0.9, 0.0, 1.0 );
	out_Color = ( mix( diffuse, refA, 0.3 ) + reflectionColor * 0.10 );
	//out_Color = mix( diffuse, mix( refA, reflectionColor, 0.3 ), 0.2 );//diffuse * refractionColor * ( 1.0 - fresnel ) + reflectionColor * fresnel;
}