#version 330

in vec2 vTexCoord;

layout( location = 0 ) out vec4 outColor;

uniform sampler2D uColorSampler;
uniform sampler2D uDepthSampler;
uniform sampler2D uSmallBlurSampler;
uniform sampler2D uLargeBlurSampler;
uniform vec2 uInvRenderTargetSize;

uniform vec4 uDOFLerpScale;
uniform vec4 uDOFLerpBias;
uniform vec3 uDOFEqFar;

uniform float uZNear;
uniform float uZFar;

float LinearizeDepth(float depth)
{
  return (2.0 * uZNear) / (uZFar + uZNear - depth * (uZFar - uZNear));	
}

vec4 TexSampleOffset( sampler2D inSampler, vec2 inTexCoords, vec2 inOffset )
{
	return texture( inSampler, inTexCoords + inOffset * uInvRenderTargetSize );
}

vec3 GetSmallBlurSample( vec2 inTexCoords )
{
	vec3 sum = vec3( 0.0 );
	const float weight = 4.0 / 17.0;
	
	sum += weight * TexSampleOffset( uColorSampler, inTexCoords, vec2( 0.5, -1.5 ) ).rgb;
	sum += weight * TexSampleOffset( uColorSampler, inTexCoords, vec2( -1.5, -0.5 ) ).rgb;
	sum += weight * TexSampleOffset( uColorSampler, inTexCoords, vec2( -0.5, 1.5 ) ).rgb;
	sum += weight * TexSampleOffset( uColorSampler, inTexCoords, vec2( 1.5, 0.5 ) ).rgb;
	
	return sum;
}

vec4 InterpolateDof( vec3 inSmall, vec3 inMedium, vec3 inLarge, float inT )
{
	vec4 weights = clamp( inT * uDOFLerpScale + uDOFLerpBias, 0.0, 1.0 );
	weights.yz = min( weights.yz, 1 - weights.xy );
	
	vec3 color = ( weights.y * inSmall ) + ( weights.z * inMedium ) + ( weights.w * inLarge );
	float alpha = dot( weights.yzw, vec3( 16.0 / 17.0, 1.0, 1.0 ) );
	return vec4( color, 1.0 ); //Replaced alpha with 1.0 since alpha was 0?
}

void main()
{
	vec3 small = GetSmallBlurSample( vTexCoord );
	vec4 med = texture( uSmallBlurSampler, vTexCoord );
	vec3 large = texture( uLargeBlurSampler, vTexCoord ).rgb;
	float nearCoc = med.a;
	float coc = 0.0;
	float farCoc = 0.0;
	float depth = LinearizeDepth( texture( uDepthSampler, vTexCoord ).r );
	if( depth > 1.0e6 )
	{
		coc = nearCoc;
	}
	else
	{
		farCoc = clamp( uDOFEqFar.x * depth + uDOFEqFar.y, 0.0, 1.0 );
		coc = max( nearCoc, farCoc * uDOFEqFar.z );
	}
	outColor = InterpolateDof( small, med.rgb, large, coc );
}