#version 330

in vec2 vTexCoord;

layout( location = 0 ) out vec4 outColor;

uniform sampler2D uTexSampler;
uniform float uExposure;
uniform float uGhostDistance;
uniform vec2 uInvRenderTargetSize;

void main()
{
	vec2 pixelDirection = ( ( vTexCoord - 0.5 ) * 2.0 );
	vec2 texCoord = ( ( pixelDirection * uGhostDistance ) + 1.0 ) / 2.0;
	//vec2 texOffset = ( pixelDirection * uGhostDistance ) * uInvRenderTargetSize;
	outColor = vec4( texture( uTexSampler, texCoord ).rgb, uExposure );
}