#version 330

layout( location = 0 ) in vec2 InVertex;

out vec2 vTexCoord;
out vec4 vSunPos;

uniform vec3 uSunPosition;
uniform mat4 uModelMatrix;
uniform mat4 uViewMatrix;
uniform mat4 uProjectionMatrix;

void main()
{
	gl_Position = vec4( vec3( InVertex, 0.0 ), 1.0 );
	vTexCoord = ( InVertex + 1.0 ) / 2.0;
	vSunPos = uProjectionMatrix * uViewMatrix * uModelMatrix * vec4( uSunPosition, 1.0 );
}