#version 330

in vec2 vTexCoord;

out vec4 out_Color;

uniform vec3 uPosition;

vec3 Tex2Pos( vec3 color )
{
	return color * 2.0 - 1.0;
}

vec3 Pos2Tex( vec3 pos )
{
	return ( pos + 1.0 ) / 2.0;
}

void main()
{
	vec2 coords = gl_FragCoord.xy / vec2( 1280.0, 720.0 ) * 360.0;
	
	float t = radians( coords.x );
	float s = radians( coords.y );

	float x = sin( t ) * cos( s ) * 50.0;
	float y = cos( t ) * 50.0;
	float z = sin( t ) * sin( s ) * 50.0;
	
	out_Color = vec4( Pos2Tex( vec3( 0.0 ) ), 1.0 );
}