#version 330

in vec3 vNormal;
in vec3 vEye;

out vec4 out_Color;

uniform vec3 LightPos;
uniform vec4 Diffuse;

void main()
{
	
	vec3 n = normalize( vNormal );
	vec3 v = normalize( -vEye );
	vec3 l = normalize( LightPos - vEye );
	vec3 h = normalize( v + l );
	
	float specularCoefficient = 60.0;

	vec3 cAmb = vec3( 0.0 );
	vec3 cDiff = Diffuse.rgb;
	vec3 cSpec = vec3( 1.0, 1.0, 1.0 );
	float diff = max( 0.0, dot( n, l ) );
	float spec = max( pow( ( dot( n, h ) ), specularCoefficient ), 0.0 );
	
	out_Color = vec4( cAmb + cDiff*diff + cSpec*spec, Diffuse.a );
}