#version 330

layout( location = 0 ) in vec3 InVertex;
layout( location = 1 ) in vec3 InNormal;

out vec3 vNormal;
out vec3 vEye;
out vec3 vPos;

uniform mat4 ViewMatrix;
uniform mat4 ProjectionMatrix;
uniform mat4 ModelMatrix;

void main()
{
	vPos = InVertex.xyz;
	vEye = vec3( ( ViewMatrix * ModelMatrix ) * vec4( InVertex, 1.0 ) );
	vNormal = normalize( transpose( inverse( mat3( ViewMatrix * ModelMatrix ) ) ) * InNormal );
	gl_Position = ProjectionMatrix * ViewMatrix * ModelMatrix * vec4( InVertex, 1.0 );
}