#version 330

layout( location = 0 ) in vec2 InVertex;

out vec4 vTexCoords;

uniform vec2 uInvRenderTargetSize;

void main()
{
	gl_Position = vec4( vec3( InVertex, 0.0 ), 1.0 );
	vec2 texCenter = ( InVertex + 1.0 ) / 2.0;
	const vec4 halfPixel = vec4( -0.5, 0.5, -0.5, 0.5 );
	vTexCoords = texCenter.xxyy + halfPixel * uInvRenderTargetSize.xxyy;
}