#version 330

in vec2 vTexCoord;

out vec4 out_Color;

uniform sampler2D PrevPosTex;
uniform sampler2D VelTex;

uniform float uDeltaTime;

vec3 Tex2Pos( vec3 color )
{
	return color * 2.0 - 1.0;
}

vec3 Pos2Tex( vec3 pos )
{
	return ( pos + 1.0 ) / 2.0;
}

void main()
{
	out_Color = vec4( Pos2Tex( Tex2Pos( texture( PrevPosTex, vTexCoord ).rgb ) + ( Tex2Pos( texture( VelTex, vTexCoord ).rgb ) * uDeltaTime ) ), 1.0 );
}