#version 330

in vec2 vTexCoord;

out vec4 out_Color;

uniform sampler2D PrevVelTex;
uniform vec3 uVelocity;
uniform float uDeltaTime;

vec3 Tex2Pos( vec3 color )
{
	return color * 2.0 - 1.0;
}

vec3 Pos2Tex( vec3 pos )
{
	return ( pos + 1.0 ) / 2.0;
}

void main()
{
	float friction = 1.0;
	vec3 newVel = ( ( Tex2Pos( texture( PrevVelTex, vTexCoord ).rgb ) ) + ( uVelocity * uDeltaTime ) ) * friction;

	out_Color = vec4( Pos2Tex( newVel ), 1.0 );
}