/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.wavefront;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.materials.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.materials.Material;
import com.badlogic.gdx.graphics.g3d.materials.MaterialAttribute;
import com.badlogic.gdx.graphics.g3d.materials.TextureAttribute;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

class MtlLoader {
    private ArrayList<Material> materials = new ArrayList();
    private static AssetManager assetManager;
    private static Texture emptyTexture;

    public MtlLoader() {
        if (emptyTexture == null) {
            assetManager = new AssetManager();
            Pixmap pm = new Pixmap(1, 1, Pixmap.Format.RGB888);
            pm.setColor(0.5f, 0.5f, 0.5f, 1.0f);
            pm.fill();
            emptyTexture = new Texture(pm, false);
        }
    }

    public void load(String name, FileHandle textureDir) {
        Material mat;
        String curMatName = "default";
        Color difcolor = Color.WHITE;
        Color speccolor = Color.WHITE;
        Texture texture = emptyTexture;
        FileHandle file = Gdx.files.internal(name);
        if (file == null || !file.exists()) {
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(file.read()), 4096);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String[] tokens;
                if (line.length() > 0 && line.charAt(0) == '\t') {
                    line = line.substring(1).trim();
                }
                if ((tokens = line.split("\\s+"))[0].length() == 0 || tokens[0].charAt(0) == '#') continue;
                if (tokens[0].toLowerCase().equals("newmtl")) {
                    mat = new Material(curMatName, new TextureAttribute(texture, 0, "diffuseTexture"), new ColorAttribute(difcolor, "diffuseColor"), new ColorAttribute(speccolor, "specularColor"));
                    this.materials.add(mat);
                    if (tokens.length > 1) {
                        curMatName = tokens[1];
                        curMatName = curMatName.replace('.', '_');
                    } else {
                        curMatName = "default";
                    }
                    difcolor = Color.WHITE;
                    speccolor = Color.WHITE;
                    continue;
                }
                if (tokens[0].toLowerCase().equals("kd") || tokens[0].toLowerCase().equals("ks")) {
                    float r = Float.parseFloat(tokens[1]);
                    float g = Float.parseFloat(tokens[2]);
                    float b = Float.parseFloat(tokens[3]);
                    float a = 1.0f;
                    if (tokens.length > 4) {
                        a = Float.parseFloat(tokens[4]);
                    }
                    if (tokens[0].toLowerCase().equals("kd")) {
                        difcolor = new Color();
                        difcolor.set(r, g, b, a);
                        continue;
                    }
                    speccolor = new Color();
                    speccolor.set(r, g, b, a);
                    continue;
                }
                if (!tokens[0].toLowerCase().equals("map_kd")) continue;
                String textureName = tokens[1];
                if (textureName.length() > 0) {
                    String texname = textureDir.child(textureName).toString();
                    assetManager.load(texname, Texture.class);
                    assetManager.finishLoading();
                    texture = assetManager.get(texname, Texture.class);
                    texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
                    continue;
                }
                texture = emptyTexture;
            }
            reader.close();
        }
        catch (IOException e) {
            return;
        }
        mat = new Material(curMatName, new TextureAttribute(texture, 0, "diffuseTexture"), new ColorAttribute(difcolor, "diffuseColor"), new ColorAttribute(speccolor, "specularColor"));
        this.materials.add(mat);
    }

    public Material getMaterial(String name) {
        name = name.replace('.', '_');
        for (Material mat : this.materials) {
            if (!mat.getName().equals(name)) continue;
            return mat;
        }
        return new Material("default", new MaterialAttribute[0]);
    }

    static {
        emptyTexture = null;
    }
}

