/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import org.taongad.scene.Scene;

public class CirclesScene
extends Scene {
    Texture circles1;
    Texture circles2;

    @Override
    public void load() {
        this.batch = new SpriteBatch();
        Pixmap circlePixmap = new Pixmap(640, 640, Pixmap.Format.RGBA8888);
        Color col = Color.WHITE;
        boolean isWhite = true;
        circlePixmap.setColor(col);
        int radius = 640;
        while (radius > 0) {
            if (isWhite) {
                col = Color.WHITE;
                isWhite = false;
            } else {
                col = Color.BLACK;
                isWhite = true;
            }
            circlePixmap.setColor(col);
            circlePixmap.fillCircle(circlePixmap.getWidth() / 2, circlePixmap.getHeight() / 2, radius);
            radius -= 5;
        }
        this.circles1 = new Texture(circlePixmap);
        circlePixmap.dispose();
        this.disposables.add(this.circles1);
    }

    @Override
    public void draw(float deltaTimeMSec) {
        this.time += deltaTimeMSec;
        Gdx.gl.glClear(16384);
        float timeScale = 9.0E-4f;
        float wave1 = MathUtils.sin(this.time * timeScale * (float)Math.PI);
        float wave2 = MathUtils.sin((this.time + 1200.0f) * timeScale * (float)Math.PI);
        float wave3 = MathUtils.sin(this.time * timeScale * 0.01f * (float)Math.PI);
        this.batch.begin();
        this.batch.draw(this.circles1, -640.0f + 40.0f * wave2 * 2.0f + 70.0f * wave3, -960.0f + 40.0f * wave1, 0.0f, 0.0f, 1280.0f, 1280.0f, 2.0f, 2.0f, 0.0f, 0, 0, this.circles1.getWidth(), this.circles1.getHeight(), false, false);
        this.batch.setBlendFunction(1, 769);
        this.batch.draw(this.circles1, -640.0f + 40.0f * wave1, -960.0f + 40.0f * wave2 * 3.0f, 0.0f, 0.0f, 1280.0f, 1280.0f, 2.0f, 2.0f, 0.0f, 0, 0, 640, 640, false, false);
        this.batch.end();
    }
}

