/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.taongad.scene.Scene;
import org.taongad.utils.FastMath;

public class PlasmaScene
extends Scene {
    Logger log = Logger.getLogger(PlasmaScene.class.getName());
    Texture redneck;
    Texture ansi;
    Pixmap plasma;
    Texture plasmaTex;
    private float delta;

    @Override
    public void load() {
        this.log.info("Loading images...");
        this.batch = new SpriteBatch();
        this.disposables.add(this.batch);
        this.redneck = this.loadImage("gfx/redneck_monkey.png");
        this.ansi = this.loadImage("gfx/taongad_ansi.png");
        this.plasma = new Pixmap(128, 72, Pixmap.Format.RGB888);
        this.plasmaTex = new Texture(this.plasma);
        this.disposables.add(this.plasmaTex);
        this.log.info("Done loading images...");
    }

    private Texture loadImage(String relPath) {
        FileHandle handle = Gdx.files.internal(relPath);
        this.log.info("Loading: " + handle.name());
        Texture tex = new Texture(handle);
        this.disposables.add(tex);
        this.log.info("Image[" + handle.name() + "] - w: " + tex.getWidth() + ", h: " + tex.getHeight());
        return tex;
    }

    @Override
    public void draw(float deltaTimeMSec) {
        this.delta = deltaTimeMSec;
        Gdx.gl.glClear(16384);
        this.renderPlasma();
        this.batch.begin();
        this.batch.draw(this.plasmaTex, 0.0f, 0.0f, 0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), 1.0f, 1.0f, 0.0f, 0, 0, 128, 72, false, false);
        this.batch.draw(this.redneck, (float)(Gdx.graphics.getWidth() - 450), 0.0f);
        this.batch.draw(this.ansi, -20.0f, 520.0f, (float)this.ansi.getWidth() / 4.0f, (float)this.ansi.getHeight() / 2.0f, (float)this.ansi.getWidth() / 2.0f, (float)this.ansi.getHeight() / 2.0f, (float)((double)MathUtils.sin(this.time / 10.0f) * 0.1) + 1.0f, (float)((double)MathUtils.sin(this.time / 5.0f) * 0.2) + 1.0f, 30.0f, 0, 0, this.ansi.getWidth(), this.ansi.getHeight(), false, false);
        this.batch.end();
    }

    private void renderPlasma() {
        this.time += this.delta / 16.666666f;
        float xFactor = 0.35f;
        float yFactor = 0.35f;
        ByteBuffer buffer = this.plasma.getPixels();
        int w = this.plasma.getWidth();
        int h = this.plasma.getHeight();
        buffer.clear();
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                int color = this.plasma(xFactor, yFactor, x, y, this.time / 12.0f);
                buffer.put((byte)(color >> 24 & 0xFF));
                buffer.put((byte)(color >> 16 & 0xFF));
                buffer.put((byte)(color >> 8 & 0xFF));
                ++x;
            }
            ++y;
        }
        buffer.flip();
        this.plasmaTex.draw(this.plasma, 0, 0);
    }

    private int plasma(float xFactor, float yFactor, float x, float y, float time) {
        float wave1 = FastMath.sin((x *= xFactor) + time * 5.0f);
        float cx = x * FastMath.sin(time / 2.0f);
        float cy = (y *= yFactor) * FastMath.cos(time / 3.0f);
        float wave2 = FastMath.sin(cx + cy + time);
        cx = x + 0.5f * FastMath.sin(time / 5.0f);
        cy = y + 0.5f * FastMath.cos(time / 3.0f);
        float wave3 = FastMath.sin((float)(Math.sqrt(0.1f * (cx * cx + cy * cy)) + (double)time));
        float colorVal = (wave1 + wave2 + wave3) / 3.0f;
        int color = (FastMath.floatSinToAbsUChar(FastMath.sin(colorVal * (float)Math.PI)) << 24) + (FastMath.floatSinToAbsUChar(FastMath.sin(colorVal * (float)Math.PI + 2.0943952f)) << 16) + (FastMath.floatSinToAbsUChar(FastMath.sin(colorVal * (float)Math.PI + 4.1887903f)) << 8) | 0xFF;
        return color;
    }
}

