/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.Disposable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.taongad.anim.AnimationEvent;
import org.taongad.anim.AnimationSequence;
import org.taongad.anim.Metronome;
import org.taongad.scene.BallsToTheWallScene;
import org.taongad.scene.CirclesScene;
import org.taongad.scene.IntroScene;
import org.taongad.scene.NoiseScene;
import org.taongad.scene.PlasmaScene;
import org.taongad.scene.RasterBarScene;
import org.taongad.scene.RotoZoomScene;
import org.taongad.scene.Scene;
import org.taongad.scene.StillScene;
import org.taongad.scene.TwisterScene;
import org.taongad.scene.WobbleScene;
import org.taongad.utils.FastMath;

public class SceneManager {
    Logger log = Logger.getLogger(SceneManager.class.getName());
    List<Scene> scenes;
    Scene currentScene;
    Scene nextScene;
    int activeScene = 0;
    SpriteBatch batch;
    List<Disposable> disposables = new ArrayList<Disposable>();
    FrameBuffer currentSceneFBO;
    FrameBuffer nextSceneFBO;
    Sprite currentSceneSprite;
    Sprite nextSceneSprite;
    Pixmap black;
    Texture blackTex;
    Texture barrelTex;
    ShaderProgram shader;
    Music music;
    Metronome metronome;
    AnimationSequence anim;
    float time = 0.0f;
    boolean isAllLoaded = false;
    boolean isLoading = false;
    List<Texture> loadAnim = new ArrayList<Texture>();
    final float LOAD_ANIM_TICK_MSEC = 50.0f;
    float loadAnimLastTickMSec;
    int currentTexIdx;
    Texture loadBarComponent;
    Pixmap loadBarComponentPix;
    Pixmap loadBarComponentPixInner;
    BitmapFont font;

    public float getCurrentMusicPosMSec() {
        return this.music.getPosition() * 1000.0f;
    }

    public void addDisposable(Disposable disposable) {
        this.disposables.add(disposable);
    }

    public SpriteBatch getBatch() {
        return this.batch;
    }

    public void load() {
        this.batch = new SpriteBatch();
        this.disposables.add(this.batch);
        FreeTypeFontGenerator generator = new FreeTypeFontGenerator(Gdx.files.internal("fonts/Computerfont.ttf"));
        this.font = generator.generateFont(90);
        generator.dispose();
        this.loadAnim.add(new Texture(Gdx.files.internal("gfx/amigahand.png")));
        this.loadBarComponentPix = new Pixmap((int)((float)Gdx.graphics.getWidth() * 0.75f), 80, Pixmap.Format.RGB888);
        this.loadBarComponentPix.setColor(Color.WHITE);
        this.loadBarComponentPix.fill();
        this.loadBarComponentPixInner = new Pixmap(this.loadBarComponentPix.getWidth() - 16, this.loadBarComponentPix.getHeight() - 16, Pixmap.Format.RGB888);
        this.loadBarComponentPixInner.setColor(Color.BLACK);
        this.loadBarComponentPixInner.fill();
        this.loadBarComponentPix.drawPixmap(this.loadBarComponentPixInner, 8, 8);
        this.loadBarComponent = new Texture(this.loadBarComponentPix);
        this.disposables.add(this.loadBarComponentPix);
        this.disposables.add(this.loadBarComponentPixInner);
        this.disposables.add(this.loadBarComponent);
    }

    private void loadAll() {
        FastMath.init();
        this.barrelTex = new Texture(Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), Pixmap.Format.RGB888);
        this.createFBOs();
        this.loadScenes();
        this.createScanlinePixmap();
        this.loadMusic();
        this.anim = new AnimationSequence();
        this.loadSceneSequence();
        this.music.play();
        this.isAllLoaded = true;
    }

    private void createFBOs() {
        this.currentSceneFBO = new FrameBuffer(Pixmap.Format.RGBA8888, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), false);
        this.disposables.add(this.currentSceneFBO);
        this.currentSceneSprite = new Sprite(this.currentSceneFBO.getColorBufferTexture());
        this.currentSceneSprite.flip(false, true);
        this.nextSceneFBO = new FrameBuffer(Pixmap.Format.RGBA8888, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), false);
        this.disposables.add(this.nextSceneFBO);
        this.nextSceneSprite = new Sprite(this.nextSceneFBO.getColorBufferTexture());
        this.nextSceneSprite.flip(false, true);
    }

    private void loadScenes() {
        this.scenes = new ArrayList<Scene>();
        this.loadScene(IntroScene.class);
        this.loadScene(RasterBarScene.class);
        this.loadScene(TwisterScene.class);
        this.loadScene(CirclesScene.class);
        this.loadScene(RotoZoomScene.class);
        this.loadScene(NoiseScene.class);
        this.loadScene(WobbleScene.class);
        this.loadScene(PlasmaScene.class);
        this.loadScene(BallsToTheWallScene.class);
        this.loadScene(StillScene.class);
        this.activeScene = 0;
        this.currentScene = this.scenes.get(this.activeScene);
        this.nextScene = this.scenes.get((this.activeScene + 1) % this.scenes.size());
    }

    private void loadScene(Class<? extends Scene> sceneType) {
        try {
            Scene scene = sceneType.getConstructor(new Class[0]).newInstance(new Object[0]);
            scene.load();
            this.scenes.add(scene);
            this.disposables.add(scene);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.log.log(Level.WARNING, "Error creating Scene of type: " + sceneType.getName(), e);
        }
    }

    private void loadSceneSequence() {
        this.anim.addEvent(new SceneSwitchEvent(this, 0.0f, 16250.0f));
        this.anim.addEvent(new SceneSwitchEvent(this, 16250.0f, 53000.0f));
        this.anim.addEvent(new SceneSwitchEvent(this, 53000.0f, 66700.0f));
        this.anim.addEvent(new SceneSwitchEvent(this, 66700.0f, 73550.0f));
        this.anim.addEvent(new SceneSwitchEvent(this, 73550.0f, 80400.0f));
        this.anim.addEvent(new SceneSwitchEvent(this, 80400.0f, 101000.0f));
        this.anim.addEvent(new SceneSwitchEvent(this, 101000.0f, 114650.0f));
        this.anim.addEvent(new SceneSwitchEvent(this, 114650.0f, 128350.0f));
        this.anim.addEvent(new SceneSwitchEvent(this, 128350.0f, 142100.0f));
        this.anim.addEvent(new SceneSwitchEvent(this, 142100.0f, 180000.0f));
    }

    private void loadMusic() {
        this.music = Gdx.audio.newMusic(Gdx.files.internal("sfx/legolas_lol_09.mp3"));
        this.music.setLooping(false);
        this.music.setVolume(1.0f);
        this.disposables.add(this.music);
    }

    private void createScanlinePixmap() {
        int w = Gdx.graphics.getWidth();
        int h = Gdx.graphics.getHeight();
        this.black = new Pixmap(w, h, Pixmap.Format.RGBA8888);
        this.black.setColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.black.fill();
        this.black.setColor(0.0f, 0.0f, 0.0f, 0.6f);
        int y = 0;
        while (y < this.black.getHeight()) {
            this.black.setColor(0.0f, 0.0f, 0.0f, 1.0f);
            this.black.drawLine(0, y + 2, w, y + 2);
            y += 4;
        }
        this.blackTex = new Texture(this.black);
        this.disposables.add(this.blackTex);
    }

    private void createBorderPixmap() {
        int w = Gdx.graphics.getWidth();
        int h = Gdx.graphics.getHeight();
        int aX = 0;
        int aY = 0;
        this.black = new Pixmap(w, h, Pixmap.Format.RGBA8888);
        float leftMargin = (float)w / 8.0f;
        float rightMargin = (float)w / 8.0f * 7.0f;
        float lowerMargin = (float)h / 8.0f;
        float upperMargin = (float)h / 8.0f * 7.0f;
        int y = 0;
        while (y < this.black.getHeight()) {
            int x = 0;
            while (x < this.black.getWidth()) {
                float scale;
                if ((float)x < leftMargin) {
                    aX = (int)(256.0f - (float)x / leftMargin * 256.0f);
                } else if ((float)x > rightMargin) {
                    scale = ((float)x - rightMargin) / leftMargin;
                    aX = (int)(scale * 256.0f);
                } else {
                    aX = 0;
                }
                if ((float)y < lowerMargin) {
                    aY = (int)(256.0f - (float)y / lowerMargin * 256.0f);
                } else if ((float)y > upperMargin) {
                    scale = ((float)y - upperMargin) / lowerMargin;
                    aY = (int)(scale * 256.0f);
                } else {
                    aY = 0;
                }
                if (aX + aY >= 256) {
                    aX = 127;
                    aY = 128;
                }
                this.black.drawPixel(x, y, aX + aY);
                ++x;
            }
            ++y;
        }
    }

    public void nextScene() {
        ++this.activeScene;
        this.activeScene %= this.scenes.size();
        this.currentScene = this.scenes.get(this.activeScene);
        this.nextScene = this.scenes.get((this.activeScene + 1) % this.scenes.size());
    }

    public void draw(float deltaTimeMSec) {
        if (this.isAllLoaded) {
            if (this.isLoading) {
                this.isLoading = false;
                deltaTimeMSec = 0.0f;
            }
            this.time += deltaTimeMSec / 200.0f;
            this.anim.update(deltaTimeMSec);
            this.currentSceneFBO.begin();
            this.currentScene.draw(deltaTimeMSec);
            this.currentSceneFBO.end();
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            Gdx.gl.glClear(16384);
            this.batch.begin();
            this.currentSceneSprite.draw(this.batch);
            this.batch.draw(this.blackTex, 0.0f, 0.0f);
            this.batch.end();
        } else {
            this.loadAnimLastTickMSec += deltaTimeMSec;
            if (this.loadAnimLastTickMSec >= 50.0f) {
                ++this.currentTexIdx;
                this.currentTexIdx %= this.loadAnim.size();
                this.loadAnimLastTickMSec = 0.0f;
            }
            float factorLoaded = this.time % 20.0f / 20.0f;
            this.loadBarComponentPixInner.setColor(Color.BLACK);
            this.loadBarComponentPixInner.fill();
            this.loadBarComponentPixInner.setColor(Color.WHITE);
            this.loadBarComponentPixInner.fillRectangle(0, 0, (int)((float)this.loadBarComponentPixInner.getWidth() * factorLoaded), this.loadBarComponentPixInner.getHeight());
            this.loadBarComponentPix.drawPixmap(this.loadBarComponentPixInner, 8, 8);
            this.loadBarComponent.draw(this.loadBarComponentPix, 0, 0);
            float scale = 2.0f;
            Texture currTex = this.loadAnim.get(this.currentTexIdx);
            float animDestW = (float)currTex.getWidth() * scale;
            float animDestH = (float)currTex.getHeight() * scale;
            int animSrcW = currTex.getWidth();
            int animSrcH = currTex.getHeight();
            float yOffs = 0.0f;
            String txt2 = "Loading...";
            this.batch.begin();
            this.batch.draw(this.loadAnim.get(this.currentTexIdx), (float)Gdx.graphics.getWidth() / 2.0f - animDestW / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f - animDestH / 2.0f - yOffs, (float)animSrcW / 2.0f, (float)animSrcH / 2.0f, animDestW, animDestH, 1.0f, 1.0f, 0.0f, 0, 0, animSrcW, animSrcH, false, false);
            this.font.setColor(Color.WHITE);
            this.font.draw(this.batch, txt2, (float)Gdx.graphics.getWidth() / 2.0f - this.font.getBounds((CharSequence)txt2).width / 2.0f + 30.0f, (float)Gdx.graphics.getHeight() * 0.25f);
            this.batch.end();
            if (this.isLoading) {
                this.loadAll();
                this.time = 0.0f;
            } else {
                this.isLoading = true;
            }
        }
    }

    public void dispose() {
        for (Disposable disposable : this.disposables) {
            this.log.info("Disposing: " + disposable.getClass().getName());
            disposable.dispose();
        }
    }

    public class SceneSwitchEvent
    extends AnimationEvent {
        SceneManager manager;

        public SceneSwitchEvent(SceneManager manager, float startTime, float endTime) {
            super(startTime, endTime);
            this.manager = manager;
        }

        @Override
        public void update(float deltaTimeMSec) {
        }

        @Override
        public void draw() {
        }

        @Override
        public void dispose() {
            this.manager.nextScene();
        }
    }
}

