/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import org.taongad.anim.AnimationSequence;
import org.taongad.anim.InstantAnimationEvent;
import org.taongad.scene.Scene;

public class WobbleScene
extends Scene {
    final float AMP_INIT = 140.0f;
    final float MIN_TICK_TIME_MSEC = 16.666666f;
    float timeSinceLastTick;

    @Override
    public void load() {
        this.batch = new SpriteBatch();
        this.anim = new AnimationSequence();
        this.anim.addEvent(new WobbleEvent("gfx/joystick.png", 0.0f, 3000.0f));
        this.anim.addEvent(new WobbleEvent("gfx/awesomeguy.png", 3000.0f, 3000.0f));
        this.anim.addEvent(new WobbleEvent("gfx/duckvase.png", 6000.0f, 3000.0f));
        this.anim.addEvent(new WobbleEvent("gfx/taongad_64.png", 9000.0f, 3000.0f));
    }

    private Pixmap createPix(Pixmap tile) {
        Pixmap pix = new Pixmap(tile.getWidth() * 3, tile.getHeight(), Pixmap.Format.RGBA8888);
        this.disposables.add(pix);
        return pix;
    }

    private Pixmap loadTile(String path) {
        Pixmap tile = new Pixmap(Gdx.files.internal(path));
        this.disposables.add(tile);
        return tile;
    }

    @Override
    public void draw(float deltaTimeMSec) {
        this.time += deltaTimeMSec;
        this.timeSinceLastTick += deltaTimeMSec;
        if (this.timeSinceLastTick >= 16.666666f) {
            this.anim.update(this.timeSinceLastTick);
            this.timeSinceLastTick = 0.0f;
        }
        Gdx.gl.glClear(16384);
        this.batch.begin();
        this.anim.draw();
        this.batch.end();
    }

    class WobbleEvent
    extends InstantAnimationEvent {
        float amp;
        Texture wobble;
        Pixmap tile;
        Pixmap pix;
        boolean fadeout;
        float fade;
        boolean hold;
        int holdTicker;

        public WobbleEvent(String fileName, float startTime, float runningTime) {
            super(startTime, runningTime);
            this.amp = 140.0f;
            this.fadeout = false;
            this.fade = 1.0f;
            this.hold = false;
            this.holdTicker = 140;
            this.tile = WobbleScene.this.loadTile(fileName);
            this.pix = WobbleScene.this.createPix(this.tile);
            this.wobble = new Texture(this.pix);
            WobbleScene.this.disposables.add(this.wobble);
        }

        @Override
        public void update(float deltaTimeMSec) {
            this.renderWobble();
            if (this.hold) {
                --this.holdTicker;
                if (this.holdTicker <= 0) {
                    this.hold = false;
                }
            }
            if (!this.hold && this.fadeout && this.fade > 0.0f) {
                this.fade -= 0.01f;
                if (this.fade < 0.0f) {
                    this.fade = 0.0f;
                }
            }
        }

        @Override
        public void draw() {
            this.wobble.draw(this.pix, 0, 0);
            WobbleScene.this.batch.setColor(1.0f, 1.0f, 1.0f, this.fade);
            WobbleScene.this.batch.draw(this.wobble, (float)(-(WobbleScene.this.SCREEN_W / 4)), (float)(WobbleScene.this.SCREEN_H_HALF - WobbleScene.this.SCREEN_W / 4), (float)(WobbleScene.this.SCREEN_W + WobbleScene.this.SCREEN_W_HALF), (float)WobbleScene.this.SCREEN_W_HALF, 0, 0, this.wobble.getWidth(), this.wobble.getHeight(), false, false);
        }

        private void renderWobble() {
            if (this.amp >= 0.0f) {
                float wave = MathUtils.sin(0.0f);
                float freq = 2.0f;
                float timeScale = 0.1f;
                this.pix.setColor(Color.BLACK);
                this.pix.fill();
                int y = 0;
                while (y < this.tile.getHeight()) {
                    wave = MathUtils.sin(((float)y + WobbleScene.this.time * timeScale) / (float)this.tile.getHeight() * freq * (float)Math.PI);
                    int wobbleX = 0;
                    wobbleX = y % 2 == 0 ? (int)(wave * this.amp) : (int)(-(wave * this.amp));
                    this.pix.drawPixmap(this.tile, this.tile.getWidth() + wobbleX, y, 0, y, this.tile.getWidth(), 1);
                    ++y;
                }
                this.amp -= 2.5f;
                if (this.amp <= 0.0f) {
                    this.amp = 0.0f;
                    this.hold = true;
                    this.fadeout = true;
                }
            }
        }
    }
}

