/*
 * Decompiled with CFR 0.152.
 */
package art;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Art {
    public static BufferedImage centerConflict = Art.load("maps/centerConflict.png");
    public static BufferedImage costalChaos = Art.load("maps/costalChaos.png");
    public static BufferedImage scorchedEarth = Art.load("maps/scorchedEarth.png");
    public static BufferedImage theBridge = Art.load("maps/theBridge.png");
    public static BufferedImage iceLake = Art.load("maps/icelake.png");
    public static BufferedImage theSixthSense = Art.load("maps/theSixthSense.png");
    public static BufferedImage fourFingers = Art.load("maps/fourFingers.png");
    public static BufferedImage builder = Art.load("unitArt/builder.png");
    public static BufferedImage[][] factory1 = Art.split(Art.load("unitArt/factory1.png"), 20, 20);
    public static BufferedImage[][] factory2 = Art.split(Art.load("unitArt/factory2.png"), 20, 20);
    public static BufferedImage[][] hoverLight = Art.split(Art.load("unitArt/hoverLight.png"), 10, 10);
    public static BufferedImage resMakerS = Art.load("unitArt/resMakerS.png");
    public static BufferedImage resMakerM = Art.load("unitArt/resMakerM.png");
    public static BufferedImage resMakerL = Art.load("unitArt/resMakerL.png");
    public static BufferedImage resExtractor = Art.load("unitArt/resExtractor.png");
    public static BufferedImage kbotFast = Art.load("unitArt/kbotFast.png");
    public static BufferedImage[][] tankLight = Art.split(Art.load("unitArt/tankLight.png"), 10, 10);
    public static BufferedImage[][] missileVehLight = Art.split(Art.load("unitArt/missileVehLight.png"), 12, 12);
    public static BufferedImage[][] hoverHeavy = Art.split(Art.load("unitArt/hoverHeavy.png"), 10, 10);
    public static BufferedImage[][] hoverMissile = Art.split(Art.load("unitArt/hoverMissile.png"), 10, 10);
    public static BufferedImage kbotHeavy = Art.load("unitArt/kbotHeavy.png");
    public static BufferedImage[][] missileVehHeavy = Art.split(Art.load("unitArt/missileVehHeavy.png"), 12, 12);
    public static BufferedImage[][] tankHeavy = Art.split(Art.load("unitArt/tankHeavy.png"), 15, 15);
    public static BufferedImage missileTower = Art.load("unitArt/missileTower.png");
    public static BufferedImage[][] cannonTower = Art.split(Art.load("unitArt/cannonTower.png"), 13, 13);
    public static BufferedImage laserTower = Art.load("unitArt/laserTower.png");
    public static BufferedImage resourceSpot = Art.load("resourceSpot.png");

    public static BufferedImage emptyImage(int w, int h) {
        return new BufferedImage(w, h, 1);
    }

    public static BufferedImage load(String name) {
        try {
            BufferedImage loaded = ImageIO.read(Art.class.getResource(name));
            BufferedImage img = new BufferedImage(loaded.getWidth(), loaded.getHeight(), 2);
            Graphics g = img.getGraphics();
            g.drawImage(loaded, 0, 0, null, null);
            g.dispose();
            return img;
        }
        catch (IOException e) {
            System.out.println("Hittade inte filen");
            return null;
        }
    }

    public static BufferedImage[][] split(BufferedImage img, int w, int h) {
        int xSlices = img.getWidth() / w;
        int ySlices = img.getHeight() / h;
        BufferedImage[][] imgs = new BufferedImage[xSlices][ySlices];
        int x = 0;
        while (x < xSlices) {
            int y = 0;
            while (y < ySlices) {
                imgs[x][y] = new BufferedImage(w, h, 2);
                Graphics g = imgs[x][y].getGraphics();
                g.drawImage(img, -x * w, -y * h, null);
                g.dispose();
                ++y;
            }
            ++x;
        }
        return imgs;
    }

    public static BufferedImage enlarge(BufferedImage old, int w, int h) {
        BufferedImage img = new BufferedImage(old.getWidth() * w, old.getHeight() * h, 2);
        Graphics g = img.getGraphics();
        int x = 0;
        while (x < old.getWidth()) {
            int y = 0;
            while (y < old.getHeight()) {
                if (old.getRGB(x, y) != 0) {
                    g.setColor(new Color(old.getRGB(x, y)));
                    g.fillRect(x * w, y * h, w, h);
                }
                ++y;
            }
            ++x;
        }
        g.dispose();
        return img;
    }

    private static BufferedImage[][] mirrorsplit(BufferedImage src, int xs, int ys) {
        int xSlices = src.getWidth() / xs;
        int ySlices = src.getHeight() / ys;
        BufferedImage[][] res = new BufferedImage[xSlices][ySlices];
        int x = 0;
        while (x < xSlices) {
            int y = 0;
            while (y < ySlices) {
                res[x][y] = new BufferedImage(xs, ys, 2);
                Graphics g = res[x][y].getGraphics();
                g.drawImage(src, xs, 0, 0, ys, x * xs, y * ys, (x + 1) * xs, (y + 1) * ys, null);
                g.dispose();
                ++y;
            }
            ++x;
        }
        return res;
    }

    public static int getRGB(BufferedImage img, int x, int y) {
        return img.getRGB(x, y) & 0xFFFFFF;
    }

    public static void setPixel(BufferedImage img, int x, int y, Color c) {
        Graphics g = img.getGraphics();
        g.setColor(c);
        g.fillRect(x, y, 1, 1);
        g.dispose();
    }

    public static BufferedImage color(BufferedImage img, Color c) {
        Graphics g = img.getGraphics();
        int x = 0;
        while (x < img.getWidth()) {
            int y = 0;
            while (y < img.getHeight()) {
                if (Art.getRGB(img, x, y) == 0) {
                    g.setColor(c);
                    g.fillRect(x, y, 1, 1);
                }
                ++y;
            }
            ++x;
        }
        g.dispose();
        return img;
    }
}

