/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.jsonbeans;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class JsonWriter
extends Writer {
    Writer writer;
    private final ArrayList<JsonObject> stack = new ArrayList();
    private JsonObject current;
    private boolean named;
    private OutputType outputType = OutputType.json;

    public JsonWriter(Writer writer) {
        this.writer = writer;
    }

    public void setOutputType(OutputType outputType) {
        this.outputType = outputType;
    }

    public JsonWriter name(String string) throws IOException {
        if (this.current == null || this.current.array) {
            throw new IllegalStateException("Current item must be an object.");
        }
        if (!this.current.needsComma) {
            this.current.needsComma = true;
        } else {
            this.writer.write(44);
        }
        this.writer.write(this.outputType.quoteName(string));
        this.writer.write(58);
        this.named = true;
        return this;
    }

    public JsonWriter object() throws IOException {
        if (this.current != null) {
            if (this.current.array) {
                if (!this.current.needsComma) {
                    this.current.needsComma = true;
                } else {
                    this.writer.write(44);
                }
            } else {
                if (!this.named && !this.current.array) {
                    throw new IllegalStateException("Name must be set.");
                }
                this.named = false;
            }
        }
        this.current = new JsonObject(false);
        this.stack.add(this.current);
        return this;
    }

    public JsonWriter array() throws IOException {
        if (this.current != null) {
            if (this.current.array) {
                if (!this.current.needsComma) {
                    this.current.needsComma = true;
                } else {
                    this.writer.write(44);
                }
            } else {
                if (!this.named && !this.current.array) {
                    throw new IllegalStateException("Name must be set.");
                }
                this.named = false;
            }
        }
        this.current = new JsonObject(true);
        this.stack.add(this.current);
        return this;
    }

    public JsonWriter value(Object object) throws IOException {
        if (this.current != null) {
            if (this.current.array) {
                if (!this.current.needsComma) {
                    this.current.needsComma = true;
                } else {
                    this.writer.write(44);
                }
            } else {
                if (!this.named) {
                    throw new IllegalStateException("Name must be set.");
                }
                this.named = false;
            }
        }
        if (object == null || object instanceof Number || object instanceof Boolean) {
            this.writer.write(String.valueOf(object));
        } else {
            this.writer.write(this.outputType.quoteValue(object.toString()));
        }
        return this;
    }

    public JsonWriter object(String string) throws IOException {
        return this.name(string).object();
    }

    public JsonWriter array(String string) throws IOException {
        return this.name(string).array();
    }

    public JsonWriter set(String string, Object object) throws IOException {
        return this.name(string).value(object);
    }

    public JsonWriter pop() throws IOException {
        if (this.named) {
            throw new IllegalStateException("Expected an object, array, or value since a name was set.");
        }
        this.stack.remove(this.stack.size() - 1).close();
        this.current = this.stack.size() == 0 ? null : this.stack.get(0);
        return this;
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.writer.write(cArray, n, n2);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        while (this.stack.size() > 0) {
            this.pop();
        }
        this.writer.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputType {
        json,
        javascript,
        minimal;


        public String quoteValue(String string) {
            string = string.replace("\\", "\\\\");
            return '\"' + string.replace("\"", "\\\"") + '\"';
        }

        public String quoteName(String string) {
            string = string.replace("\\", "\\\\");
            switch (this) {
                default: 
            }
            return '\"' + string.replace("\"", "\\\"") + '\"';
        }
    }

    private class JsonObject {
        final boolean array;
        boolean needsComma;

        JsonObject(boolean bl) throws IOException {
            this.array = bl;
            JsonWriter.this.writer.write(bl ? 91 : 123);
        }

        void close() throws IOException {
            JsonWriter.this.writer.write(this.array ? 93 : 125);
        }
    }
}

