/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.NotNull;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.IntArray;
import com.esotericsoftware.kryo.util.ObjectMap;
import com.esotericsoftware.kryo.util.Util;
import com.esotericsoftware.minlog.Log;
import com.esotericsoftware.reflectasm.FieldAccess;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldSerializer<T>
extends Serializer<T>
implements Comparator<CachedField> {
    final Kryo kryo;
    final Class type;
    private CachedField[] fields = new CachedField[0];
    Object access;
    private boolean fieldsCanBeNull = true;
    private boolean setFieldsAsAccessible = true;
    private boolean ignoreSyntheticFields = true;
    private boolean fixedFieldTypes;

    public FieldSerializer(Kryo kryo, Class clazz) {
        this.kryo = kryo;
        this.type = clazz;
        this.rebuildCachedFields();
    }

    private void rebuildCachedFields() {
        if (this.type.isInterface()) {
            this.fields = new CachedField[0];
            return;
        }
        ArrayList arrayList = new ArrayList();
        for (Class clazz = this.type; clazz != Object.class; clazz = clazz.getSuperclass()) {
            Collections.addAll(arrayList, clazz.getDeclaredFields());
        }
        ObjectMap objectMap = this.kryo.getContext();
        IntArray intArray = new IntArray();
        ArrayList<Field> arrayList2 = new ArrayList<Field>(arrayList.size());
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Optional optional;
            Field field = (Field)arrayList.get(i);
            int n2 = field.getModifiers();
            if (Modifier.isTransient(n2) || Modifier.isStatic(n2) || field.isSynthetic() && this.ignoreSyntheticFields) continue;
            if (!field.isAccessible()) {
                if (!this.setFieldsAsAccessible) continue;
                try {
                    field.setAccessible(true);
                }
                catch (AccessControlException accessControlException) {
                    continue;
                }
            }
            if ((optional = field.getAnnotation(Optional.class)) != null && !objectMap.containsKey(optional.value())) continue;
            arrayList2.add(field);
            intArray.add(!Modifier.isFinal(n2) && Modifier.isPublic(n2) && Modifier.isPublic(field.getType().getModifiers()) ? 1 : 0);
        }
        if (!Util.isAndroid && Modifier.isPublic(this.type.getModifiers()) && intArray.indexOf(1) != -1) {
            try {
                this.access = FieldAccess.get(this.type);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        ArrayList<CachedField> arrayList3 = new ArrayList<CachedField>(arrayList2.size());
        int n3 = arrayList2.size();
        for (n = 0; n < n3; ++n) {
            Field field = (Field)arrayList2.get(n);
            int n4 = -1;
            if (this.access != null && intArray.get(n) == 1) {
                n4 = ((FieldAccess)this.access).getIndex(field.getName());
            }
            arrayList3.add(this.newCachedField(field, arrayList3.size(), n4));
        }
        Collections.sort(arrayList3, this);
        this.fields = arrayList3.toArray(new CachedField[arrayList3.size()]);
        this.initializeCachedFields();
    }

    protected void initializeCachedFields() {
    }

    private CachedField newCachedField(Field field, int n, int n2) {
        CachedField cachedField;
        Class<?> clazz = field.getType();
        if (n2 != -1) {
            cachedField = clazz.isPrimitive() ? (clazz == Boolean.TYPE ? new BooleanField() : (clazz == Byte.TYPE ? new ByteField() : (clazz == Character.TYPE ? new CharField() : (clazz == Short.TYPE ? new ShortField() : (clazz == Integer.TYPE ? new IntField() : (clazz == Long.TYPE ? new LongField() : (clazz == Float.TYPE ? new FloatField() : (clazz == Double.TYPE ? new DoubleField() : new ObjectField())))))))) : (!(clazz != String.class || this.kryo.getReferences() && this.kryo.getReferenceResolver().useReferences(String.class)) ? new StringField() : new ObjectField());
        } else {
            cachedField = new ObjectField();
            cachedField.generics = Kryo.getGenerics(field.getGenericType());
        }
        cachedField.field = field;
        cachedField.accessIndex = n2;
        boolean bl = cachedField.canBeNull = this.fieldsCanBeNull && !clazz.isPrimitive() && !field.isAnnotationPresent(NotNull.class);
        if (this.kryo.isFinal(clazz) || this.fixedFieldTypes) {
            cachedField.valueClass = clazz;
        }
        return cachedField;
    }

    @Override
    public int compare(CachedField cachedField, CachedField cachedField2) {
        return cachedField.field.getName().compareTo(cachedField2.field.getName());
    }

    public void setFieldsCanBeNull(boolean bl) {
        this.fieldsCanBeNull = bl;
        this.rebuildCachedFields();
    }

    public void setFieldsAsAccessible(boolean bl) {
        this.setFieldsAsAccessible = bl;
        this.rebuildCachedFields();
    }

    public void setIgnoreSyntheticFields(boolean bl) {
        this.ignoreSyntheticFields = bl;
        this.rebuildCachedFields();
    }

    public void setFixedFieldTypes(boolean bl) {
        this.fixedFieldTypes = bl;
        this.rebuildCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T t) {
        CachedField[] cachedFieldArray = this.fields;
        int n = cachedFieldArray.length;
        for (int i = 0; i < n; ++i) {
            cachedFieldArray[i].write(output, t);
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<T> clazz) {
        T t = this.create(kryo, input, clazz);
        kryo.reference(t);
        CachedField[] cachedFieldArray = this.fields;
        int n = cachedFieldArray.length;
        for (int i = 0; i < n; ++i) {
            cachedFieldArray[i].read(input, t);
        }
        return t;
    }

    protected T create(Kryo kryo, Input input, Class<T> clazz) {
        return kryo.newInstance(clazz);
    }

    public CachedField getField(String string) {
        for (CachedField cachedField : this.fields) {
            if (!cachedField.field.getName().equals(string)) continue;
            return cachedField;
        }
        throw new IllegalArgumentException("Field \"" + string + "\" not found on class: " + this.type.getName());
    }

    public void removeField(String string) {
        for (int i = 0; i < this.fields.length; ++i) {
            CachedField cachedField = this.fields[i];
            if (!cachedField.field.getName().equals(string)) continue;
            CachedField[] cachedFieldArray = new CachedField[this.fields.length - 1];
            System.arraycopy(this.fields, 0, cachedFieldArray, 0, i);
            System.arraycopy(this.fields, i + 1, cachedFieldArray, i, cachedFieldArray.length - i);
            this.fields = cachedFieldArray;
            return;
        }
        throw new IllegalArgumentException("Field \"" + string + "\" not found on class: " + this.type.getName());
    }

    public CachedField[] getFields() {
        return this.fields;
    }

    public Class getType() {
        return this.type;
    }

    protected T createCopy(Kryo kryo, T t) {
        return (T)kryo.newInstance(t.getClass());
    }

    @Override
    public T copy(Kryo kryo, T t) {
        T t2 = this.createCopy(kryo, t);
        kryo.reference(t2);
        int n = this.fields.length;
        for (int i = 0; i < n; ++i) {
            this.fields[i].copy(t, t2);
        }
        return t2;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Optional {
        public String value();
    }

    class ObjectField
    extends CachedField {
        Class[] generics;

        ObjectField() {
        }

        public void write(Output output, Object object) {
            try {
                if (Log.TRACE) {
                    Log.trace("kryo", "Write field: " + this + " (" + object.getClass().getName() + ")");
                }
                Object object2 = this.accessIndex != -1 ? ((FieldAccess)FieldSerializer.this.access).get(object, this.accessIndex) : this.field.get(object);
                Serializer serializer = this.serializer;
                if (this.valueClass == null) {
                    if (object2 == null) {
                        FieldSerializer.this.kryo.writeClass(output, null);
                        return;
                    }
                    Registration registration = FieldSerializer.this.kryo.writeClass(output, object2.getClass());
                    if (serializer == null) {
                        serializer = registration.getSerializer();
                    }
                    if (this.generics != null) {
                        serializer.setGenerics(FieldSerializer.this.kryo, this.generics);
                    }
                    FieldSerializer.this.kryo.writeObject(output, object2, serializer);
                } else {
                    if (serializer == null) {
                        this.serializer = serializer = FieldSerializer.this.kryo.getSerializer(this.valueClass);
                    }
                    if (this.generics != null) {
                        serializer.setGenerics(FieldSerializer.this.kryo, this.generics);
                    }
                    if (this.canBeNull) {
                        FieldSerializer.this.kryo.writeObjectOrNull(output, object2, serializer);
                    } else {
                        if (object2 == null) {
                            throw new KryoException("Field value is null but canBeNull is false: " + this + " (" + object.getClass().getName() + ")");
                        }
                        FieldSerializer.this.kryo.writeObject(output, object2, serializer);
                    }
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new KryoException("Error accessing field: " + this + " (" + object.getClass().getName() + ")", illegalAccessException);
            }
            catch (KryoException kryoException) {
                kryoException.addTrace(this + " (" + object.getClass().getName() + ")");
                throw kryoException;
            }
            catch (RuntimeException runtimeException) {
                KryoException kryoException = new KryoException(runtimeException);
                kryoException.addTrace(this + " (" + object.getClass().getName() + ")");
                throw kryoException;
            }
        }

        public void read(Input input, Object object) {
            try {
                Object var3_7;
                if (Log.TRACE) {
                    Log.trace("kryo", "Read field: " + this + " (" + FieldSerializer.this.type.getName() + ")");
                }
                Class clazz = this.valueClass;
                Serializer serializer = this.serializer;
                if (clazz == null) {
                    Registration registration = FieldSerializer.this.kryo.readClass(input);
                    if (registration == null) {
                        var3_7 = null;
                    } else {
                        if (serializer == null) {
                            serializer = registration.getSerializer();
                        }
                        if (this.generics != null) {
                            serializer.setGenerics(FieldSerializer.this.kryo, this.generics);
                        }
                        var3_7 = FieldSerializer.this.kryo.readObject(input, registration.getType(), serializer);
                    }
                } else {
                    if (serializer == null) {
                        this.serializer = serializer = FieldSerializer.this.kryo.getSerializer(this.valueClass);
                    }
                    if (this.generics != null) {
                        serializer.setGenerics(FieldSerializer.this.kryo, this.generics);
                    }
                    var3_7 = this.canBeNull ? FieldSerializer.this.kryo.readObjectOrNull(input, clazz, serializer) : FieldSerializer.this.kryo.readObject(input, clazz, serializer);
                }
                if (this.accessIndex != -1) {
                    ((FieldAccess)FieldSerializer.this.access).set(object, this.accessIndex, var3_7);
                } else {
                    this.field.set(object, var3_7);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new KryoException("Error accessing field: " + this + " (" + FieldSerializer.this.type.getName() + ")", illegalAccessException);
            }
            catch (KryoException kryoException) {
                kryoException.addTrace(this + " (" + FieldSerializer.this.type.getName() + ")");
                throw kryoException;
            }
            catch (RuntimeException runtimeException) {
                KryoException kryoException = new KryoException(runtimeException);
                kryoException.addTrace(this + " (" + FieldSerializer.this.type.getName() + ")");
                throw kryoException;
            }
        }

        public void copy(Object object, Object object2) {
            try {
                if (this.accessIndex != -1) {
                    FieldAccess fieldAccess = (FieldAccess)FieldSerializer.this.access;
                    fieldAccess.set(object2, this.accessIndex, FieldSerializer.this.kryo.copy(fieldAccess.get(object, this.accessIndex)));
                } else {
                    this.field.set(object2, FieldSerializer.this.kryo.copy(this.field.get(object)));
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new KryoException("Error accessing field: " + this + " (" + FieldSerializer.this.type.getName() + ")", illegalAccessException);
            }
            catch (KryoException kryoException) {
                kryoException.addTrace(this + " (" + FieldSerializer.this.type.getName() + ")");
                throw kryoException;
            }
            catch (RuntimeException runtimeException) {
                KryoException kryoException = new KryoException(runtimeException);
                kryoException.addTrace(this + " (" + FieldSerializer.this.type.getName() + ")");
                throw kryoException;
            }
        }
    }

    class StringField
    extends AsmCachedField {
        StringField() {
        }

        public void write(Output output, Object object) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Write string: " + this.access.getString(object, this.accessIndex));
            }
            output.writeString(this.access.getString(object, this.accessIndex));
        }

        public void read(Input input, Object object) {
            if (Log.TRACE) {
                String string = input.readString();
                this.access.set(object, this.accessIndex, (Object)string);
                Log.trace("kryo", "Read field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Read string: " + string);
            } else {
                this.access.set(object, this.accessIndex, (Object)input.readString());
            }
        }

        public void copy(Object object, Object object2) {
            this.access.set(object2, this.accessIndex, (Object)this.access.getString(object, this.accessIndex));
        }
    }

    class DoubleField
    extends AsmCachedField {
        DoubleField() {
        }

        public void write(Output output, Object object) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Write double: " + this.access.getDouble(object, this.accessIndex));
            }
            output.writeDouble(this.access.getDouble(object, this.accessIndex));
        }

        public void read(Input input, Object object) {
            if (Log.TRACE) {
                double d = input.readDouble();
                this.access.setDouble(object, this.accessIndex, d);
                Log.trace("kryo", "Read field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Read double: " + d);
            } else {
                this.access.setDouble(object, this.accessIndex, input.readDouble());
            }
        }

        public void copy(Object object, Object object2) {
            this.access.setDouble(object2, this.accessIndex, this.access.getDouble(object, this.accessIndex));
        }
    }

    class LongField
    extends AsmCachedField {
        LongField() {
        }

        public void write(Output output, Object object) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Write long: " + this.access.getLong(object, this.accessIndex));
            }
            output.writeLong(this.access.getLong(object, this.accessIndex), false);
        }

        public void read(Input input, Object object) {
            if (Log.TRACE) {
                long l = input.readLong(false);
                this.access.setLong(object, this.accessIndex, l);
                Log.trace("kryo", "Read field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Read long: " + l);
            } else {
                this.access.setLong(object, this.accessIndex, input.readLong(false));
            }
        }

        public void copy(Object object, Object object2) {
            this.access.setLong(object2, this.accessIndex, this.access.getLong(object, this.accessIndex));
        }
    }

    class CharField
    extends AsmCachedField {
        CharField() {
        }

        public void write(Output output, Object object) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Write char: " + this.access.getChar(object, this.accessIndex));
            }
            output.writeChar(this.access.getChar(object, this.accessIndex));
        }

        public void read(Input input, Object object) {
            if (Log.TRACE) {
                char c = input.readChar();
                this.access.setChar(object, this.accessIndex, c);
                Log.trace("kryo", "Read field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Read char: " + c);
            } else {
                this.access.setChar(object, this.accessIndex, input.readChar());
            }
        }

        public void copy(Object object, Object object2) {
            this.access.setChar(object2, this.accessIndex, this.access.getChar(object, this.accessIndex));
        }
    }

    class BooleanField
    extends AsmCachedField {
        BooleanField() {
        }

        public void write(Output output, Object object) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Write boolean: " + this.access.getBoolean(object, this.accessIndex));
            }
            output.writeBoolean(this.access.getBoolean(object, this.accessIndex));
        }

        public void read(Input input, Object object) {
            if (Log.TRACE) {
                boolean bl = input.readBoolean();
                this.access.setBoolean(object, this.accessIndex, bl);
                Log.trace("kryo", "Read field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Read boolean: " + bl);
            } else {
                this.access.setBoolean(object, this.accessIndex, input.readBoolean());
            }
        }

        public void copy(Object object, Object object2) {
            this.access.setBoolean(object2, this.accessIndex, this.access.getBoolean(object, this.accessIndex));
        }
    }

    class ByteField
    extends AsmCachedField {
        ByteField() {
        }

        public void write(Output output, Object object) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Write byte: " + this.access.getByte(object, this.accessIndex));
            }
            output.writeByte(this.access.getByte(object, this.accessIndex));
        }

        public void read(Input input, Object object) {
            if (Log.TRACE) {
                byte by = input.readByte();
                this.access.setByte(object, this.accessIndex, by);
                Log.trace("kryo", "Read field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Read byte: " + by);
            } else {
                this.access.setByte(object, this.accessIndex, input.readByte());
            }
        }

        public void copy(Object object, Object object2) {
            this.access.setByte(object2, this.accessIndex, this.access.getByte(object, this.accessIndex));
        }
    }

    class ShortField
    extends AsmCachedField {
        ShortField() {
        }

        public void write(Output output, Object object) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Write short: " + this.access.getShort(object, this.accessIndex));
            }
            output.writeShort(this.access.getShort(object, this.accessIndex));
        }

        public void read(Input input, Object object) {
            if (Log.TRACE) {
                short s = input.readShort();
                this.access.setShort(object, this.accessIndex, s);
                Log.trace("kryo", "Read field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Read short: " + s);
            } else {
                this.access.setShort(object, this.accessIndex, input.readShort());
            }
        }

        public void copy(Object object, Object object2) {
            this.access.setShort(object2, this.accessIndex, this.access.getShort(object, this.accessIndex));
        }
    }

    class FloatField
    extends AsmCachedField {
        FloatField() {
        }

        public void write(Output output, Object object) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Write float: " + this.access.getFloat(object, this.accessIndex));
            }
            output.writeFloat(this.access.getFloat(object, this.accessIndex));
        }

        public void read(Input input, Object object) {
            if (Log.TRACE) {
                float f = input.readFloat();
                this.access.setFloat(object, this.accessIndex, f);
                Log.trace("kryo", "Read field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Read float: " + f);
            } else {
                this.access.setFloat(object, this.accessIndex, input.readFloat());
            }
        }

        public void copy(Object object, Object object2) {
            this.access.setFloat(object2, this.accessIndex, this.access.getFloat(object, this.accessIndex));
        }
    }

    class IntField
    extends AsmCachedField {
        IntField() {
        }

        public void write(Output output, Object object) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Write int: " + this.access.getInt(object, this.accessIndex));
            }
            output.writeInt(this.access.getInt(object, this.accessIndex), false);
        }

        public void read(Input input, Object object) {
            if (Log.TRACE) {
                int n = input.readInt(false);
                this.access.setInt(object, this.accessIndex, n);
                Log.trace("kryo", "Read field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Read int: " + n);
            } else {
                this.access.setInt(object, this.accessIndex, input.readInt(false));
            }
        }

        public void copy(Object object, Object object2) {
            this.access.setInt(object2, this.accessIndex, this.access.getInt(object, this.accessIndex));
        }
    }

    abstract class AsmCachedField
    extends CachedField {
        FieldAccess access;

        AsmCachedField() {
            this.access = (FieldAccess)FieldSerializer.this.access;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class CachedField<X> {
        Field field;
        Class valueClass;
        Serializer serializer;
        boolean canBeNull;
        int accessIndex = -1;

        public void setClass(Class clazz) {
            this.valueClass = clazz;
            this.serializer = null;
        }

        public void setClass(Class clazz, Serializer serializer) {
            this.valueClass = clazz;
            this.serializer = serializer;
        }

        public void setSerializer(Serializer serializer) {
            this.serializer = serializer;
        }

        public void setCanBeNull(boolean bl) {
            this.canBeNull = bl;
        }

        public Field getField() {
            return this.field;
        }

        public String toString() {
            return this.field.getName();
        }

        public abstract void write(Output var1, Object var2);

        public abstract void read(Input var1, Object var2);

        public abstract void copy(Object var1, Object var2);
    }
}

