/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.EndPoint;
import com.esotericsoftware.kryonet.FrameworkMessage;
import com.esotericsoftware.kryonet.KryoNetException;
import com.esotericsoftware.kryonet.KryoSerialization;
import com.esotericsoftware.kryonet.Listener;
import com.esotericsoftware.kryonet.Serialization;
import com.esotericsoftware.kryonet.UdpConnection;
import com.esotericsoftware.minlog.Log;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client
extends Connection
implements EndPoint {
    private final Serialization serialization;
    private Selector selector;
    private volatile boolean tcpRegistered;
    private volatile boolean udpRegistered;
    private Object tcpRegistrationLock = new Object();
    private Object udpRegistrationLock = new Object();
    private volatile boolean shutdown;
    private final Object updateLock = new Object();
    private Thread updateThread;
    private int connectTimeout;
    private InetAddress connectHost;
    private int connectTcpPort;
    private int connectUdpPort;

    public Client() {
        this(8192, 2048);
    }

    public Client(int n, int n2) {
        this(n, n2, new KryoSerialization());
    }

    public Client(int n, int n2, Serialization serialization) {
        this.endPoint = this;
        this.serialization = serialization;
        this.initialize(serialization, n, n2);
        try {
            this.selector = Selector.open();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error opening selector.", iOException);
        }
    }

    @Override
    public Serialization getSerialization() {
        return this.serialization;
    }

    @Override
    public Kryo getKryo() {
        return ((KryoSerialization)this.serialization).getKryo();
    }

    public void connect(int n, String string, int n2) throws IOException {
        this.connect(n, InetAddress.getByName(string), n2, -1);
    }

    public void connect(int n, String string, int n2, int n3) throws IOException {
        this.connect(n, InetAddress.getByName(string), n2, n3);
    }

    public void connect(int n, InetAddress inetAddress, int n2) throws IOException {
        this.connect(n, inetAddress, n2, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(int n, InetAddress inetAddress, int n2, int n3) throws IOException {
        if (inetAddress == null) {
            throw new IllegalArgumentException("host cannot be null.");
        }
        if (Thread.currentThread() == this.getUpdateThread()) {
            throw new IllegalStateException("Cannot connect on the connection's update thread.");
        }
        this.connectTimeout = n;
        this.connectHost = inetAddress;
        this.connectTcpPort = n2;
        this.connectUdpPort = n3;
        this.close();
        if (Log.INFO) {
            if (n3 != -1) {
                Log.info("Connecting: " + inetAddress + ":" + n2 + "/" + n3);
            } else {
                Log.info("Connecting: " + inetAddress + ":" + n2);
            }
        }
        this.id = -1;
        try {
            long l;
            if (n3 != -1) {
                this.udp = new UdpConnection(this.serialization, this.tcp.readBuffer.capacity());
            }
            Object object = this.updateLock;
            synchronized (object) {
                this.tcpRegistered = false;
                this.selector.wakeup();
                l = System.currentTimeMillis() + (long)n;
                this.tcp.connect(this.selector, new InetSocketAddress(inetAddress, n2), 5000);
            }
            object = this.tcpRegistrationLock;
            synchronized (object) {
                while (!this.tcpRegistered && System.currentTimeMillis() < l) {
                    try {
                        this.tcpRegistrationLock.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.tcpRegistered) {
                    throw new SocketTimeoutException("Connected, but timed out during TCP registration.\nNote: Client#update must be called in a separate thread during connect.");
                }
            }
            if (n3 == -1) return;
            object = new InetSocketAddress(inetAddress, n3);
            Object object2 = this.updateLock;
            synchronized (object2) {
                this.udpRegistered = false;
                this.selector.wakeup();
                this.udp.connect(this.selector, (InetSocketAddress)object);
            }
            object2 = this.udpRegistrationLock;
            synchronized (object2) {
                while (!this.udpRegistered && System.currentTimeMillis() < l) {
                    FrameworkMessage.RegisterUDP registerUDP = new FrameworkMessage.RegisterUDP();
                    registerUDP.connectionID = this.id;
                    this.udp.send(this, registerUDP, (SocketAddress)object);
                    try {
                        this.udpRegistrationLock.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.udpRegistered) return;
                throw new SocketTimeoutException("Connected, but timed out during UDP registration: " + inetAddress + ":" + n3);
            }
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    public void reconnect() throws IOException {
        this.reconnect(this.connectTimeout);
    }

    public void reconnect(int n) throws IOException {
        if (this.connectHost == null) {
            throw new IllegalStateException("This client has never been connected.");
        }
        this.connect(this.connectTimeout, this.connectHost, this.connectTcpPort, this.connectUdpPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(int n) throws IOException {
        long l;
        this.updateThread = Thread.currentThread();
        Object object = this.updateLock;
        synchronized (object) {
        }
        long l2 = System.currentTimeMillis();
        int n2 = 0;
        n2 = n > 0 ? this.selector.select(n) : this.selector.selectNow();
        if (n2 == 0) {
            l = System.currentTimeMillis() - l2;
            try {
                if (l < 25L) {
                    Thread.sleep(25L - l);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            Set<SelectionKey> set;
            Set<SelectionKey> set2 = set = this.selector.selectedKeys();
            synchronized (set2) {
                Iterator<SelectionKey> iterator = set.iterator();
                while (iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    iterator.remove();
                    try {
                        int n3 = selectionKey.readyOps();
                        if ((n3 & 1) == 1) {
                            Object object2;
                            Object object3;
                            if (selectionKey.attachment() == this.tcp) {
                                while ((object3 = this.tcp.readObject(this)) != null) {
                                    if (!this.tcpRegistered) {
                                        if (!(object3 instanceof FrameworkMessage.RegisterTCP)) continue;
                                        this.id = ((FrameworkMessage.RegisterTCP)object3).connectionID;
                                        object2 = this.tcpRegistrationLock;
                                        synchronized (object2) {
                                            this.tcpRegistered = true;
                                            this.tcpRegistrationLock.notifyAll();
                                            if (Log.TRACE) {
                                                Log.trace("kryonet", this + " received TCP: RegisterTCP");
                                            }
                                            if (this.udp == null) {
                                                this.setConnected(true);
                                            }
                                        }
                                        if (this.udp != null) continue;
                                        this.notifyConnected();
                                        continue;
                                    }
                                    if (this.udp != null && !this.udpRegistered) {
                                        if (!(object3 instanceof FrameworkMessage.RegisterUDP)) continue;
                                        object2 = this.udpRegistrationLock;
                                        synchronized (object2) {
                                            this.udpRegistered = true;
                                            this.udpRegistrationLock.notifyAll();
                                            if (Log.TRACE) {
                                                Log.trace("kryonet", this + " received UDP: RegisterUDP");
                                            }
                                            if (Log.DEBUG) {
                                                Log.debug("kryonet", "Port " + this.udp.datagramChannel.socket().getLocalPort() + "/UDP connected to: " + this.udp.connectedAddress);
                                            }
                                            this.setConnected(true);
                                        }
                                        this.notifyConnected();
                                        continue;
                                    }
                                    if (!this.isConnected) continue;
                                    if (Log.DEBUG) {
                                        Object object4 = object2 = object3 == null ? "null" : object3.getClass().getSimpleName();
                                        if (!(object3 instanceof FrameworkMessage)) {
                                            Log.debug("kryonet", this + " received TCP: " + (String)object2);
                                        } else if (Log.TRACE) {
                                            Log.trace("kryonet", this + " received TCP: " + (String)object2);
                                        }
                                    }
                                    this.notifyReceived(object3);
                                }
                            } else {
                                if (this.udp.readFromAddress() == null || (object3 = this.udp.readObject(this)) == null) continue;
                                if (Log.DEBUG) {
                                    object2 = object3 == null ? "null" : object3.getClass().getSimpleName();
                                    Log.debug("kryonet", this + " received UDP: " + (String)object2);
                                }
                                this.notifyReceived(object3);
                            }
                        }
                        if ((n3 & 4) != 4) continue;
                        this.tcp.writeOperation();
                    }
                    catch (CancelledKeyException cancelledKeyException) {}
                }
            }
        }
        if (this.isConnected) {
            l = System.currentTimeMillis();
            if (this.tcp.isTimedOut(l)) {
                if (Log.DEBUG) {
                    Log.debug("kryonet", this + " timed out.");
                }
                this.close();
            } else {
                if (this.tcp.needsKeepAlive(l)) {
                    this.sendTCP(FrameworkMessage.keepAlive);
                }
                if (this.udp != null && this.udpRegistered && this.udp.needsKeepAlive(l)) {
                    this.sendUDP(FrameworkMessage.keepAlive);
                }
            }
            if (this.isIdle()) {
                this.notifyIdle();
            }
        }
    }

    @Override
    public void run() {
        if (Log.TRACE) {
            Log.trace("kryonet", "Client thread started.");
        }
        this.shutdown = false;
        while (!this.shutdown) {
            try {
                this.update(250);
            }
            catch (IOException iOException) {
                if (Log.TRACE) {
                    if (this.isConnected) {
                        Log.trace("kryonet", "Unable to update connection: " + this, iOException);
                    } else {
                        Log.trace("kryonet", "Unable to update connection.", iOException);
                    }
                } else if (Log.DEBUG) {
                    if (this.isConnected) {
                        Log.debug("kryonet", this + " update: " + iOException.getMessage());
                    } else {
                        Log.debug("kryonet", "Unable to update connection: " + iOException.getMessage());
                    }
                }
                this.close();
            }
            catch (KryoNetException kryoNetException) {
                if (Log.ERROR) {
                    if (this.isConnected) {
                        Log.error("kryonet", "Error updating connection: " + this, kryoNetException);
                    } else {
                        Log.error("kryonet", "Error updating connection.", kryoNetException);
                    }
                }
                this.close();
                throw kryoNetException;
            }
        }
        if (Log.TRACE) {
            Log.trace("kryonet", "Client thread stopped.");
        }
    }

    @Override
    public void start() {
        if (this.updateThread != null) {
            this.shutdown = true;
            try {
                this.updateThread.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.updateThread = new Thread((Runnable)this, "Client");
        this.updateThread.setDaemon(true);
        this.updateThread.start();
    }

    @Override
    public void stop() {
        if (this.shutdown) {
            return;
        }
        this.close();
        if (Log.TRACE) {
            Log.trace("kryonet", "Client thread stopping.");
        }
        this.shutdown = true;
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        Object object = this.updateLock;
        synchronized (object) {
            this.selector.wakeup();
            try {
                this.selector.selectNow();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void addListener(Listener listener) {
        super.addListener(listener);
        if (Log.TRACE) {
            Log.trace("kryonet", "Client listener added.");
        }
    }

    @Override
    public void removeListener(Listener listener) {
        super.removeListener(listener);
        if (Log.TRACE) {
            Log.trace("kryonet", "Client listener removed.");
        }
    }

    public void setKeepAliveUDP(int n) {
        if (this.udp == null) {
            throw new IllegalStateException("Not connected via UDP.");
        }
        this.udp.keepAliveMillis = n;
    }

    @Override
    public Thread getUpdateThread() {
        return this.updateThread;
    }

    private void broadcast(int n, DatagramSocket datagramSocket) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(64);
        this.serialization.write(null, byteBuffer, new FrameworkMessage.DiscoverHost());
        byteBuffer.flip();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
            for (InetAddress inetAddress : Collections.list(networkInterface.getInetAddresses())) {
                byte[] byArray2 = inetAddress.getAddress();
                byArray2[3] = -1;
                datagramSocket.send(new DatagramPacket(byArray, byArray.length, InetAddress.getByAddress(byArray2), n));
                byArray2[2] = -1;
                datagramSocket.send(new DatagramPacket(byArray, byArray.length, InetAddress.getByAddress(byArray2), n));
            }
        }
        if (Log.DEBUG) {
            Log.debug("kryonet", "Broadcasted host discovery on port: " + n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress discoverHost(int n, int n2) {
        DatagramSocket datagramSocket = null;
        try {
            datagramSocket = new DatagramSocket();
            this.broadcast(n, datagramSocket);
            datagramSocket.setSoTimeout(n2);
            DatagramPacket datagramPacket = new DatagramPacket(new byte[0], 0);
            try {
                datagramSocket.receive(datagramPacket);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (Log.INFO) {
                    Log.info("kryonet", "Host discovery timed out.");
                }
                InetAddress inetAddress = null;
                if (datagramSocket != null) {
                    datagramSocket.close();
                }
                return inetAddress;
            }
            if (Log.INFO) {
                Log.info("kryonet", "Discovered server: " + datagramPacket.getAddress());
            }
            InetAddress inetAddress = datagramPacket.getAddress();
            return inetAddress;
        }
        catch (IOException iOException) {
            if (Log.ERROR) {
                Log.error("kryonet", "Host discovery failed.", iOException);
            }
            InetAddress inetAddress = null;
            return inetAddress;
        }
        finally {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<InetAddress> discoverHosts(int n, int n2) {
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        DatagramSocket datagramSocket = null;
        try {
            datagramSocket = new DatagramSocket();
            this.broadcast(n, datagramSocket);
            datagramSocket.setSoTimeout(n2);
            while (true) {
                DatagramPacket datagramPacket = new DatagramPacket(new byte[0], 0);
                try {
                    datagramSocket.receive(datagramPacket);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (Log.INFO) {
                        Log.info("kryonet", "Host discovery timed out.");
                    }
                    ArrayList<InetAddress> arrayList2 = arrayList;
                    if (datagramSocket == null) return arrayList2;
                    datagramSocket.close();
                    return arrayList2;
                }
                if (Log.INFO) {
                    Log.info("kryonet", "Discovered server: " + datagramPacket.getAddress());
                }
                arrayList.add(datagramPacket.getAddress());
                continue;
                break;
            }
        }
        catch (IOException iOException) {
            if (Log.ERROR) {
                Log.error("kryonet", "Host discovery failed.", iOException);
            }
            ArrayList<InetAddress> arrayList3 = arrayList;
            return arrayList3;
        }
        finally {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
        }
    }

    static {
        try {
            System.setProperty("java.net.preferIPv6Addresses", "false");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }
}

