/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.util.IntMap;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.EndPoint;
import com.esotericsoftware.kryonet.FrameworkMessage;
import com.esotericsoftware.kryonet.KryoNetException;
import com.esotericsoftware.kryonet.KryoSerialization;
import com.esotericsoftware.kryonet.Listener;
import com.esotericsoftware.kryonet.Serialization;
import com.esotericsoftware.kryonet.UdpConnection;
import com.esotericsoftware.minlog.Log;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;

public class Server
implements EndPoint {
    private final Serialization serialization;
    private final int writeBufferSize;
    private final int objectBufferSize;
    private final Selector selector;
    private ServerSocketChannel serverChannel;
    private UdpConnection udp;
    private Connection[] connections = new Connection[0];
    private IntMap<Connection> pendingConnections = new IntMap();
    Listener[] listeners = new Listener[0];
    private Object listenerLock = new Object();
    private int nextConnectionID = 1;
    private volatile boolean shutdown;
    private Object updateLock = new Object();
    private Thread updateThread;
    private ByteBuffer emptyBuffer = ByteBuffer.allocate(0);
    private Listener dispatchListener = new Listener(){

        public void connected(Connection connection) {
            Listener[] listenerArray = Server.this.listeners;
            int n = listenerArray.length;
            for (int i = 0; i < n; ++i) {
                listenerArray[i].connected(connection);
            }
        }

        public void disconnected(Connection connection) {
            Server.this.removeConnection(connection);
            Listener[] listenerArray = Server.this.listeners;
            int n = listenerArray.length;
            for (int i = 0; i < n; ++i) {
                listenerArray[i].disconnected(connection);
            }
        }

        public void received(Connection connection, Object object) {
            Listener[] listenerArray = Server.this.listeners;
            int n = listenerArray.length;
            for (int i = 0; i < n; ++i) {
                listenerArray[i].received(connection, object);
            }
        }

        public void idle(Connection connection) {
            Listener[] listenerArray = Server.this.listeners;
            int n = listenerArray.length;
            for (int i = 0; i < n; ++i) {
                listenerArray[i].idle(connection);
            }
        }
    };

    public Server() {
        this(16384, 2048);
    }

    public Server(int n, int n2) {
        this(n, n2, new KryoSerialization());
    }

    public Server(int n, int n2, Serialization serialization) {
        this.writeBufferSize = n;
        this.objectBufferSize = n2;
        this.serialization = serialization;
        try {
            this.selector = Selector.open();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error opening selector.", iOException);
        }
    }

    public Serialization getSerialization() {
        return this.serialization;
    }

    public Kryo getKryo() {
        return ((KryoSerialization)this.serialization).getKryo();
    }

    public void bind(int n) throws IOException {
        this.bind(new InetSocketAddress(n), null);
    }

    public void bind(int n, int n2) throws IOException {
        this.bind(new InetSocketAddress(n), new InetSocketAddress(n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) throws IOException {
        this.close();
        Object object = this.updateLock;
        synchronized (object) {
            this.selector.wakeup();
            try {
                this.serverChannel = this.selector.provider().openServerSocketChannel();
                this.serverChannel.socket().bind(inetSocketAddress);
                this.serverChannel.configureBlocking(false);
                this.serverChannel.register(this.selector, 16);
                if (Log.DEBUG) {
                    Log.debug("kryonet", "Accepting connections on port: " + inetSocketAddress + "/TCP");
                }
                if (inetSocketAddress2 != null) {
                    this.udp = new UdpConnection(this.serialization, this.objectBufferSize);
                    this.udp.bind(this.selector, inetSocketAddress2);
                    if (Log.DEBUG) {
                        Log.debug("kryonet", "Accepting connections on port: " + inetSocketAddress2 + "/UDP");
                    }
                }
            }
            catch (IOException iOException) {
                this.close();
                throw iOException;
            }
        }
        if (Log.INFO) {
            Log.info("kryonet", "Server opened.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int n) throws IOException {
        long l;
        this.updateThread = Thread.currentThread();
        Object object = this.updateLock;
        synchronized (object) {
        }
        long l2 = System.currentTimeMillis();
        int n2 = 0;
        n2 = n > 0 ? this.selector.select(n) : this.selector.selectNow();
        if (n2 == 0) {
            l = System.currentTimeMillis() - l2;
            try {
                if (l < 25L) {
                    Thread.sleep(25L - l);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            Set<SelectionKey> set;
            Set<SelectionKey> set2 = set = this.selector.selectedKeys();
            synchronized (set2) {
                Connection[] connectionArray = this.udp;
                Iterator<SelectionKey> iterator = set.iterator();
                while (iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    iterator.remove();
                    Connection connection = (Connection)selectionKey.attachment();
                    try {
                        Object object2;
                        Connection connection2;
                        Object object3;
                        Object object4;
                        int n3 = selectionKey.readyOps();
                        if (connection != null) {
                            if (connectionArray != null && connection.udpRemoteAddress == null) {
                                connection.close();
                                continue;
                            }
                            if ((n3 & 1) == 1) {
                                try {
                                    while ((object4 = connection.tcp.readObject(connection)) != null) {
                                        if (Log.DEBUG) {
                                            Object object5 = object3 = object4 == null ? "null" : object4.getClass().getSimpleName();
                                            if (!(object4 instanceof FrameworkMessage)) {
                                                Log.debug("kryonet", connection + " received TCP: " + (String)object3);
                                            } else if (Log.TRACE) {
                                                Log.trace("kryonet", connection + " received TCP: " + (String)object3);
                                            }
                                        }
                                        connection.notifyReceived(object4);
                                    }
                                }
                                catch (IOException iOException) {
                                    if (Log.TRACE) {
                                        Log.trace("kryonet", "Unable to read TCP from: " + connection, iOException);
                                    } else if (Log.DEBUG) {
                                        Log.debug("kryonet", connection + " update: " + iOException.getMessage());
                                    }
                                    connection.close();
                                }
                                catch (KryoNetException kryoNetException) {
                                    if (Log.ERROR) {
                                        Log.error("kryonet", "Error reading TCP from connection: " + connection, kryoNetException);
                                    }
                                    connection.close();
                                }
                            }
                            if ((n3 & 4) != 4) continue;
                            try {
                                connection.tcp.writeOperation();
                            }
                            catch (IOException iOException) {
                                if (Log.TRACE) {
                                    Log.trace("kryonet", "Unable to write TCP to connection: " + connection, iOException);
                                } else if (Log.DEBUG) {
                                    Log.debug("kryonet", connection + " update: " + iOException.getMessage());
                                }
                                connection.close();
                            }
                            continue;
                        }
                        if ((n3 & 0x10) == 16) {
                            object4 = this.serverChannel;
                            if (object4 == null) continue;
                            try {
                                object3 = ((ServerSocketChannel)object4).accept();
                                if (object3 == null) continue;
                                this.acceptOperation((SocketChannel)object3);
                            }
                            catch (IOException iOException) {
                                if (!Log.DEBUG) continue;
                                Log.debug("kryonet", "Unable to accept new connection.", iOException);
                            }
                            continue;
                        }
                        if (connectionArray == null) {
                            selectionKey.channel().close();
                            continue;
                        }
                        try {
                            object4 = connectionArray.readFromAddress();
                        }
                        catch (IOException iOException) {
                            if (!Log.WARN) continue;
                            Log.warn("kryonet", "Error reading UDP data.", iOException);
                            continue;
                        }
                        if (object4 == null) continue;
                        object3 = this.connections;
                        int n4 = ((Connection[])object3).length;
                        for (int i = 0; i < n4; ++i) {
                            connection2 = object3[i];
                            if (!((InetSocketAddress)object4).equals(connection2.udpRemoteAddress)) continue;
                            connection = connection2;
                            break;
                        }
                        try {
                            object2 = connectionArray.readObject(connection);
                        }
                        catch (KryoNetException kryoNetException) {
                            if (!Log.WARN) continue;
                            if (connection != null) {
                                if (!Log.ERROR) continue;
                                Log.error("kryonet", "Error reading UDP from connection: " + connection, kryoNetException);
                                continue;
                            }
                            Log.warn("kryonet", "Error reading UDP from unregistered address: " + object4, kryoNetException);
                            continue;
                        }
                        if (object2 instanceof FrameworkMessage) {
                            if (object2 instanceof FrameworkMessage.RegisterUDP) {
                                n4 = ((FrameworkMessage.RegisterUDP)object2).connectionID;
                                connection2 = this.pendingConnections.remove(n4);
                                if (connection2 != null) {
                                    if (connection2.udpRemoteAddress != null) continue;
                                    connection2.udpRemoteAddress = object4;
                                    this.addConnection(connection2);
                                    connection2.sendTCP(new FrameworkMessage.RegisterUDP());
                                    if (Log.DEBUG) {
                                        Log.debug("kryonet", "Port " + connectionArray.datagramChannel.socket().getLocalPort() + "/UDP connected to: " + object4);
                                    }
                                    connection2.notifyConnected();
                                    continue;
                                }
                                if (!Log.DEBUG) continue;
                                Log.debug("kryonet", "Ignoring incoming RegisterUDP with invalid connection ID: " + n4);
                                continue;
                            }
                            if (object2 instanceof FrameworkMessage.DiscoverHost) {
                                try {
                                    connectionArray.datagramChannel.send(this.emptyBuffer, (SocketAddress)object4);
                                    if (!Log.DEBUG) continue;
                                    Log.debug("kryonet", "Responded to host discovery from: " + object4);
                                }
                                catch (IOException iOException) {
                                    if (!Log.WARN) continue;
                                    Log.warn("kryonet", "Error replying to host discovery from: " + object4, iOException);
                                }
                                continue;
                            }
                        }
                        if (connection != null) {
                            if (Log.DEBUG) {
                                String string;
                                String string2 = string = object2 == null ? "null" : object2.getClass().getSimpleName();
                                if (object2 instanceof FrameworkMessage) {
                                    if (Log.TRACE) {
                                        Log.trace("kryonet", connection + " received UDP: " + string);
                                    }
                                } else {
                                    Log.debug("kryonet", connection + " received UDP: " + string);
                                }
                            }
                            connection.notifyReceived(object2);
                            continue;
                        }
                        if (!Log.DEBUG) continue;
                        Log.debug("kryonet", "Ignoring UDP from unregistered address: " + object4);
                    }
                    catch (CancelledKeyException cancelledKeyException) {
                        if (connection != null) {
                            connection.close();
                            continue;
                        }
                        selectionKey.channel().close();
                    }
                }
            }
        }
        l = System.currentTimeMillis();
        for (Connection connection : this.connections) {
            if (connection.tcp.isTimedOut(l)) {
                if (Log.DEBUG) {
                    Log.debug("kryonet", connection + " timed out.");
                }
                connection.close();
            } else if (connection.tcp.needsKeepAlive(l)) {
                connection.sendTCP(FrameworkMessage.keepAlive);
            }
            if (!connection.isIdle()) continue;
            connection.notifyIdle();
        }
    }

    public void run() {
        if (Log.TRACE) {
            Log.trace("kryonet", "Server thread started.");
        }
        this.shutdown = false;
        while (!this.shutdown) {
            try {
                this.update(250);
            }
            catch (IOException iOException) {
                if (Log.ERROR) {
                    Log.error("kryonet", "Error updating server connections.", iOException);
                }
                this.close();
            }
        }
        if (Log.TRACE) {
            Log.trace("kryonet", "Server thread stopped.");
        }
    }

    public void start() {
        new Thread((Runnable)this, "Server").start();
    }

    public void stop() {
        if (this.shutdown) {
            return;
        }
        this.close();
        if (Log.TRACE) {
            Log.trace("kryonet", "Server thread stopping.");
        }
        this.shutdown = true;
    }

    private void acceptOperation(SocketChannel socketChannel) {
        block7: {
            Connection connection = this.newConnection();
            connection.initialize(this.serialization, this.writeBufferSize, this.objectBufferSize);
            connection.endPoint = this;
            UdpConnection udpConnection = this.udp;
            if (udpConnection != null) {
                connection.udp = udpConnection;
            }
            try {
                SelectionKey selectionKey = connection.tcp.accept(this.selector, socketChannel);
                selectionKey.attach(connection);
                int n = this.nextConnectionID++;
                if (this.nextConnectionID == -1) {
                    this.nextConnectionID = 1;
                }
                connection.id = n;
                connection.setConnected(true);
                connection.addListener(this.dispatchListener);
                if (udpConnection == null) {
                    this.addConnection(connection);
                } else {
                    this.pendingConnections.put(n, connection);
                }
                FrameworkMessage.RegisterTCP registerTCP = new FrameworkMessage.RegisterTCP();
                registerTCP.connectionID = n;
                connection.sendTCP(registerTCP);
                if (udpConnection == null) {
                    connection.notifyConnected();
                }
            }
            catch (IOException iOException) {
                connection.close();
                if (!Log.DEBUG) break block7;
                Log.debug("kryonet", "Unable to accept TCP connection.", iOException);
            }
        }
    }

    protected Connection newConnection() {
        return new Connection();
    }

    private void addConnection(Connection connection) {
        Connection[] connectionArray = new Connection[this.connections.length + 1];
        connectionArray[0] = connection;
        System.arraycopy(this.connections, 0, connectionArray, 1, this.connections.length);
        this.connections = connectionArray;
    }

    void removeConnection(Connection connection) {
        ArrayList<Connection> arrayList = new ArrayList<Connection>(Arrays.asList(this.connections));
        arrayList.remove(connection);
        this.connections = arrayList.toArray(new Connection[arrayList.size()]);
        this.pendingConnections.remove(connection.id);
    }

    public void sendToAllTCP(Object object) {
        for (Connection connection : this.connections) {
            connection.sendTCP(object);
        }
    }

    public void sendToAllExceptTCP(int n, Object object) {
        for (Connection connection : this.connections) {
            if (connection.id == n) continue;
            connection.sendTCP(object);
        }
    }

    public void sendToTCP(int n, Object object) {
        for (Connection connection : this.connections) {
            if (connection.id != n) continue;
            connection.sendTCP(object);
            break;
        }
    }

    public void sendToAllUDP(Object object) {
        for (Connection connection : this.connections) {
            connection.sendUDP(object);
        }
    }

    public void sendToAllExceptUDP(int n, Object object) {
        for (Connection connection : this.connections) {
            if (connection.id == n) continue;
            connection.sendUDP(object);
        }
    }

    public void sendToUDP(int n, Object object) {
        for (Connection connection : this.connections) {
            if (connection.id != n) continue;
            connection.sendUDP(object);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Object object = this.listenerLock;
        synchronized (object) {
            Listener[] listenerArray = this.listeners;
            int n = listenerArray.length;
            for (int i = 0; i < n; ++i) {
                if (listener != listenerArray[i]) continue;
                return;
            }
            Listener[] listenerArray2 = new Listener[n + 1];
            listenerArray2[0] = listener;
            System.arraycopy(listenerArray, 0, listenerArray2, 1, n);
            this.listeners = listenerArray2;
        }
        if (Log.TRACE) {
            Log.trace("kryonet", "Server listener added: " + listener.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Object object = this.listenerLock;
        synchronized (object) {
            Listener[] listenerArray = this.listeners;
            int n = listenerArray.length;
            Listener[] listenerArray2 = new Listener[n - 1];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                Listener listener2 = listenerArray[i];
                if (listener == listener2) continue;
                if (n2 == n - 1) {
                    return;
                }
                listenerArray2[n2++] = listener2;
            }
            this.listeners = listenerArray2;
        }
        if (Log.TRACE) {
            Log.trace("kryonet", "Server listener removed: " + listener.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        UdpConnection udpConnection;
        Connection[] connectionArray = this.connections;
        if (Log.INFO && connectionArray.length > 0) {
            Log.info("kryonet", "Closing server connections...");
        }
        int n = connectionArray.length;
        for (int i = 0; i < n; ++i) {
            connectionArray[i].close();
        }
        connectionArray = new Connection[]{};
        ServerSocketChannel serverSocketChannel = this.serverChannel;
        if (serverSocketChannel != null) {
            block12: {
                try {
                    serverSocketChannel.close();
                    if (Log.INFO) {
                        Log.info("kryonet", "Server closed.");
                    }
                }
                catch (IOException iOException) {
                    if (!Log.DEBUG) break block12;
                    Log.debug("kryonet", "Unable to close server.", iOException);
                }
            }
            this.serverChannel = null;
        }
        if ((udpConnection = this.udp) != null) {
            udpConnection.close();
            this.udp = null;
        }
        Object object = this.updateLock;
        synchronized (object) {
            this.selector.wakeup();
            try {
                this.selector.selectNow();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Thread getUpdateThread() {
        return this.updateThread;
    }

    public Connection[] getConnections() {
        return this.connections;
    }
}

