/*
 * Decompiled with CFR 0.152.
 */
package effects;

import effects.Effect;
import fonts.Fonts;
import java.awt.Color;
import java.awt.Graphics;

public class NotEnoughResourcesEffect
implements Effect {
    private int maxTime = 100;
    private int time;
    private int x;
    private int y;

    public NotEnoughResourcesEffect(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public boolean isFinsihed() {
        return this.time > this.maxTime;
    }

    @Override
    public void simulate() {
        ++this.time;
    }

    @Override
    public void draw(Graphics g) {
        double p = (double)this.time / (double)this.maxTime;
        g.setFont(Fonts.c64size20);
        g.setColor(new Color(0, 0, 0, 255 - (int)(p * 255.0)));
        g.drawString("NOT ENOUGH RESOURCES", this.x - 150 + 1, this.y - this.time + 1);
        g.setColor(new Color(255, 255, 255, 255 - (int)(p * 255.0)));
        g.drawString("NOT ENOUGH RESOURCES", this.x - 150, this.y - this.time);
    }

    @Override
    public boolean isOnHud() {
        return false;
    }
}

