/*
 * Decompiled with CFR 0.152.
 */
package effects;

import effects.Effect;
import java.awt.Color;
import java.awt.Graphics;
import utils.Vec2;

public class Smoke
implements Effect {
    private static final int HALF_SIZE = 2;
    private int time;
    private final int startTime;
    private Vec2[] particlesPos;
    private Vec2[] particlesSpeeds;
    private boolean[] particlesVisible;
    private Vec2 center;

    public Smoke(Vec2 pos, int numParticles, double minSpeed, double maxSpeed, int time) {
        this.time = time;
        this.startTime = time;
        this.center = pos;
        this.particlesPos = new Vec2[numParticles];
        this.particlesSpeeds = new Vec2[numParticles];
        this.particlesVisible = new boolean[numParticles];
        int i = 0;
        while (i < this.particlesPos.length) {
            this.particlesVisible[i] = true;
            this.particlesPos[i] = pos.clone();
            double a = Math.random() * Math.PI * 2.0;
            double speed = minSpeed + Math.random() * (maxSpeed - minSpeed);
            this.particlesSpeeds[i] = new Vec2(Math.cos(a) * speed, Math.sin(a) * speed);
            ++i;
        }
    }

    @Override
    public void simulate() {
        int i = 0;
        while (i < this.particlesPos.length) {
            this.particlesPos[i].move(this.particlesSpeeds[i].x, this.particlesSpeeds[i].y);
            if (Math.random() > 0.975) {
                this.particlesVisible[i] = false;
            }
            ++i;
        }
        --this.time;
    }

    @Override
    public void draw(Graphics g) {
        int i = 0;
        while (i < this.particlesPos.length) {
            if (this.particlesVisible[i]) {
                int c = (int)(25.0 + Math.random() * 100.0);
                g.setColor(new Color(c, c, c));
                int x = (int)this.particlesPos[i].x;
                int y = (int)this.particlesPos[i].y;
                g.fillRect(x - 2, y - 2, 4, 4);
            }
            ++i;
        }
    }

    @Override
    public boolean isFinsihed() {
        return this.time <= 0;
    }

    @Override
    public boolean isOnHud() {
        return false;
    }
}

