/*
 * Decompiled with CFR 0.152.
 */
package entities.projectiles;

import entities.projectiles.Projectile;
import entities.units.Unit;
import game.Game;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import sound.Sound;
import utils.Vec2;

public class Grenade
extends Projectile {
    int drawSize;
    double aoeRadius;
    GrenadeType type;

    public Grenade(int myPlayerID, int myUnitID, Vec2 startPos, Game game, GrenadeType type, Vec2 targetPos) {
        super(myPlayerID, myUnitID, startPos, game);
        this.type = type;
        this.speed = 5.0;
        switch (type) {
            case BULLDOG: {
                this.damage = 60.0;
                this.aoeRadius = 40.0;
                this.drawSize = 10;
                break;
            }
            case HOVER: {
                this.damage = 40.0;
                this.aoeRadius = 40.0;
                this.drawSize = 8;
                break;
            }
            case GUARDIAN: {
                this.damage = 40.0;
                this.aoeRadius = 300.0;
                this.drawSize = 15;
                break;
            }
            case STUMPY: {
                this.damage = 30.0;
                this.aoeRadius = 30.0;
                this.drawSize = 7;
                break;
            }
            default: {
                System.err.println("unknown type in grenade: " + (Object)((Object)type));
            }
        }
        this.size = this.drawSize;
        game.sound.playSound(Sound.CANNON);
        double angle = Game.angleFromTo(startPos, targetPos);
        double dx = Math.cos(angle) * this.speed;
        double dy = Math.sin(angle) * this.speed;
        this.speeds = new Vec2(dx, dy);
    }

    @Override
    public void simulate() {
        if (this.pos.x < 0.0 || this.pos.x > (double)this.game.map.getWidth() || this.pos.y < 0.0 || this.pos.y > (double)this.game.map.getHeight()) {
            this.shallBeRemoved = true;
        }
        this.pos.x += this.speeds.x;
        this.pos.y += this.speeds.y;
        ArrayList<Unit> units = this.game.map.getUnitsFromAdjecentTiles(this);
        int i = 0;
        while (i < units.size() && !this.shallBeRemoved) {
            Unit uColl = units.get(i);
            if (uColl.myPlayerID != this.myPlayerID && this.collides(uColl)) {
                i = 0;
                while (i < units.size()) {
                    Unit u = units.get(i);
                    if (u.myPlayerID != this.myPlayerID && (this.pos.disTo(u.pos) <= this.aoeRadius || u == uColl)) {
                        u.takeDamage(this.damage);
                    }
                    ++i;
                }
                switch (this.type) {
                    case BULLDOG: {
                        this.game.effectHandler.newSmallExplosion(this.pos.clone());
                        break;
                    }
                    case GUARDIAN: {
                        this.game.effectHandler.newSmallExplosion(this.pos.clone());
                        break;
                    }
                    case HOVER: {
                        this.game.effectHandler.newSmallExplosion(this.pos.clone());
                        break;
                    }
                    case STUMPY: {
                        this.game.effectHandler.newSmallExplosion(this.pos.clone());
                    }
                }
                this.shallBeRemoved = true;
            }
            ++i;
        }
    }

    @Override
    public void draw(Graphics g) {
        g.setColor(new Color(255, (int)(Math.random() * 63.0 * (4.0 - Math.random() * 4.0)), 0));
        g.fillOval((int)this.pos.x - this.drawSize / 2, (int)this.pos.y - this.drawSize / 2, this.drawSize, this.drawSize);
    }

    public static enum GrenadeType {
        STUMPY,
        BULLDOG,
        GUARDIAN,
        HOVER;

    }
}

