/*
 * Decompiled with CFR 0.152.
 */
package entities.projectiles;

import entities.projectiles.Projectile;
import entities.units.Unit;
import game.Game;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import sound.Sound;
import utils.Vec2;

public class Missile
extends Projectile {
    double angle;
    Unit target;
    MissileType type;
    int drawLen;
    int drawWidth;
    int smokeTime;
    int smokeCounter;

    public Missile(int myPlayerID, int myUnitID, Vec2 startPos, Game game, Unit target, MissileType type) {
        super(myPlayerID, myUnitID, startPos, game);
        this.smokeCounter = this.smokeTime = 5;
        this.type = type;
        this.target = target;
        switch (type) {
            case DEFENDER: {
                this.speed = 10.0;
                this.drawLen = 10;
                this.drawWidth = 3;
                this.damage = 20.0;
                break;
            }
            case ICBM: {
                this.speed = 5.0;
                this.drawLen = 30;
                this.drawWidth = 5;
                this.damage = 200.0;
                break;
            }
        }
        game.sound.playSound(Sound.MISSILE);
    }

    @Override
    public void simulate() {
        if (this.target.shallBeRemoved) {
            this.shallBeRemoved = true;
        }
        this.angle = Game.angleFromTo(this.pos, this.target.pos);
        double dx = Math.cos(this.angle) * this.speed;
        double dy = Math.sin(this.angle) * this.speed;
        this.speeds = new Vec2(dx, dy);
        --this.smokeCounter;
        if (this.smokeCounter <= 0) {
            this.smokeCounter = this.smokeTime;
            this.game.effectHandler.newMissileSmoke(this.pos.clone());
        }
        if (this.pos.x < 0.0 || this.pos.x > (double)this.game.map.getWidth() || this.pos.y < 0.0 || this.pos.y > (double)this.game.map.getHeight()) {
            this.shallBeRemoved = true;
        }
        this.pos.x += this.speeds.x;
        this.pos.y += this.speeds.y;
        ArrayList<Unit> units = this.game.map.getUnitsFromAdjecentTiles(this);
        int i = 0;
        while (i < units.size() && !this.shallBeRemoved) {
            Unit uColl = units.get(i);
            if (uColl.myPlayerID != this.myPlayerID && this.collides(uColl)) {
                switch (this.type) {
                    case DEFENDER: {
                        uColl.takeDamage(this.damage);
                        break;
                    }
                    case ICBM: {
                        double aoeRadius = 60.0;
                        i = 0;
                        while (i < units.size()) {
                            Unit u = units.get(i);
                            if (u.myPlayerID != this.myPlayerID && (this.pos.disTo(u.pos) <= aoeRadius || u == uColl)) {
                                u.takeDamage(this.damage);
                            }
                            ++i;
                        }
                        this.game.effectHandler.newLargeExplosion(this.pos.clone());
                    }
                }
                this.shallBeRemoved = true;
            }
            ++i;
        }
    }

    @Override
    public void draw(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(this.drawWidth));
        g.setColor(Color.gray);
        g.drawLine((int)this.pos.x, (int)this.pos.y, (int)(this.pos.x + (double)this.drawLen * Math.cos(this.angle)), (int)(this.pos.y + (double)this.drawLen * Math.sin(this.angle)));
        g2.setStroke(new BasicStroke(1.0f));
    }

    public static enum MissileType {
        DEFENDER,
        ICBM;

    }
}

