/*
 * Decompiled with CFR 0.152.
 */
package entities.units;

import art.Art;
import entities.projectiles.Grenade;
import entities.projectiles.Projectile;
import entities.units.Unit;
import entities.units.UnitInfo;
import entities.units.unitOrders.UnitOrder;
import game.Game;
import game.Sprite3D;
import utils.Vec2;

public class CannonTower
extends Unit {
    public static final int BUILD_TIME = 1500;
    public static final int BUILD_COST = 700;
    public static final int SIZE = 75;
    public static UnitInfo UNIT_INFO = new UnitInfo(1500, 700, 75, Art.cannonTower[0][0], Art.cannonTower[1][0], "Cannon Tower", "Defensive Structure");

    public CannonTower(Game game, Vec2 vec2, int playerID, int unitID, UnitOrder[] startOrders) {
        super(game, vec2, playerID, unitID, startOrders);
        this.sprite = new boolean[2][][];
        this.sprite[0] = Sprite3D.spriteToArray(Art.cannonTower[0][0]);
        this.sprite[1] = Sprite3D.spriteToArray(Art.cannonTower[1][0]);
        this.artStanding = false;
        this.canAttack = true;
        this.attackRange = 600.0;
        this.reloadTime = 200;
        this.initHealth(500);
        this.size = 75;
    }

    @Override
    protected Projectile newProjectile(Unit target) {
        return new Grenade(this.myPlayerID, this.unitID, this.pos.clone(), this.game, Grenade.GrenadeType.GUARDIAN, target.pos.clone());
    }
}

