/*
 * Decompiled with CFR 0.152.
 */
package entities.units;

import art.Art;
import entities.projectiles.Grenade;
import entities.projectiles.Projectile;
import entities.units.Unit;
import entities.units.UnitInfo;
import entities.units.unitOrders.UnitOrder;
import game.Game;
import game.Sprite3D;
import utils.Vec2;

public class HoverHeavy
extends Unit {
    public static final int BUILD_TIME = 1000;
    public static final int BUILD_COST = 400;
    public static final int SIZE = 50;
    public static UnitInfo UNIT_INFO = new UnitInfo(1000, 400, 50, Art.hoverHeavy[0][0], Art.hoverHeavy[1][0], "Anaconda", "Hovercraft Tank");

    public HoverHeavy(Game game, Vec2 vec2, int playerID, int unitID, UnitOrder[] startOrders) {
        super(game, vec2, playerID, unitID, startOrders);
        this.sprite = new boolean[2][][];
        this.sprite[0] = Sprite3D.spriteToArray(Art.hoverHeavy[0][0]);
        this.sprite[1] = Sprite3D.spriteToArray(Art.hoverHeavy[1][0]);
        this.canAttack = true;
        this.attackRange = 400.0;
        this.reloadTime = 200;
        this.initHealth(200);
        this.speed = 2.0;
        this.canMove = true;
        this.canMoveLand = true;
        this.canMoveWater = true;
        this.artStanding = false;
        this.rotationOffset = Math.toRadians(90.0);
        this.size = 50;
    }

    @Override
    protected Projectile newProjectile(Unit target) {
        return new Grenade(this.myPlayerID, this.unitID, this.pos.clone(), this.game, Grenade.GrenadeType.HOVER, target.pos.clone());
    }
}

