/*
 * Decompiled with CFR 0.152.
 */
package entities.units;

import art.Art;
import entities.projectiles.Laser;
import entities.projectiles.Projectile;
import entities.units.Unit;
import entities.units.UnitInfo;
import entities.units.unitOrders.UnitOrder;
import game.Game;
import game.Sprite3D;
import utils.Vec2;

public class HoverLight
extends Unit {
    public static final int BUILD_TIME = 500;
    public static final int BUILD_COST = 150;
    public static final int SIZE = 50;
    public static UnitInfo UNIT_INFO = new UnitInfo(500, 150, 50, Art.hoverLight[0][0], Art.hoverLight[1][0], "Skimmer", "Fast Hovercraft Tank");

    public HoverLight(Game game, Vec2 vec2, int playerID, int unitID, UnitOrder[] startOrders) {
        super(game, vec2, playerID, unitID, startOrders);
        this.sprite = new boolean[2][][];
        this.sprite[0] = Sprite3D.spriteToArray(Art.hoverLight[0][0]);
        this.sprite[1] = Sprite3D.spriteToArray(Art.hoverLight[1][0]);
        this.canAttack = true;
        this.attackRange = 300.0;
        this.reloadTime = 150;
        this.initHealth(100);
        this.speed = 2.5;
        this.canMove = true;
        this.canMoveLand = true;
        this.canMoveWater = true;
        this.artStanding = false;
        this.rotationOffset = Math.toRadians(90.0);
        this.size = 50;
    }

    @Override
    protected Projectile newProjectile(Unit target) {
        return new Laser(this.myPlayerID, this.unitID, this.pos.clone(), target.pos.clone(), this.game, Laser.LaserType.RED);
    }
}

