/*
 * Decompiled with CFR 0.152.
 */
package entities.units;

import art.Art;
import entities.projectiles.Laser;
import entities.projectiles.Projectile;
import entities.units.Unit;
import entities.units.UnitInfo;
import entities.units.unitOrders.UnitOrder;
import game.Game;
import game.Sprite3D;
import utils.Vec2;

public class KbotFast
extends Unit {
    public static final int BUILD_TIME = 500;
    public static final int BUILD_COST = 50;
    public static final int SIZE = 30;
    public static UnitInfo UNIT_INFO = new UnitInfo(500, 50, 30, Art.kbotFast, "PeeWee", "Scout/Fast Attack Robot");

    public KbotFast(Game game, Vec2 vec2, int playerID, int unitID, UnitOrder[] startOrders) {
        super(game, vec2, playerID, unitID, startOrders);
        this.sprite = new boolean[1][][];
        this.sprite[0] = Sprite3D.spriteToArray(Art.kbotFast);
        this.canAttack = true;
        this.attackRange = 200.0;
        this.reloadTime = 100;
        this.initHealth(40);
        this.speed = 3.5;
        this.canMove = true;
        this.canMoveLand = true;
        this.canMoveWater = false;
        this.rotationOffset = Math.toRadians(90.0);
        this.size = 30;
    }

    @Override
    protected Projectile newProjectile(Unit target) {
        return new Laser(this.myPlayerID, this.unitID, this.pos.clone(), target.pos.clone(), this.game, Laser.LaserType.ORANGE);
    }
}

