/*
 * Decompiled with CFR 0.152.
 */
package entities.units;

import art.Art;
import entities.projectiles.Laser;
import entities.projectiles.Projectile;
import entities.units.Unit;
import entities.units.UnitInfo;
import entities.units.unitOrders.UnitOrder;
import game.Game;
import game.Sprite3D;
import utils.Vec2;

public class KbotHeavy
extends Unit {
    public static final int BUILD_TIME = 1200;
    public static final int BUILD_COST = 600;
    public static final int SIZE = 60;
    public static UnitInfo UNIT_INFO = new UnitInfo(1200, 600, 60, Art.kbotHeavy, "Sumo", "Heavy Battle Robot");

    public KbotHeavy(Game game, Vec2 vec2, int playerID, int unitID, UnitOrder[] startOrders) {
        super(game, vec2, playerID, unitID, startOrders);
        this.sprite = new boolean[1][][];
        this.sprite[0] = Sprite3D.spriteToArray(Art.kbotHeavy);
        this.canAttack = true;
        this.attackRange = 300.0;
        this.reloadTime = 150;
        this.initHealth(400);
        this.speed = 1.0;
        this.canMove = true;
        this.canMoveLand = true;
        this.canMoveWater = false;
        this.rotationOffset = Math.toRadians(90.0);
        this.size = 60;
    }

    @Override
    protected Projectile newProjectile(Unit target) {
        return new Laser(this.myPlayerID, this.unitID, this.pos.clone(), target.pos.clone(), this.game, Laser.LaserType.BLUE);
    }
}

