/*
 * Decompiled with CFR 0.152.
 */
package entities.units;

import art.Art;
import entities.projectiles.Laser;
import entities.projectiles.Projectile;
import entities.units.Unit;
import entities.units.UnitInfo;
import entities.units.unitOrders.UnitOrder;
import game.Game;
import game.Sprite3D;
import utils.Vec2;

public class LaserTower
extends Unit {
    public static final int BUILD_TIME = 800;
    public static final int BUILD_COST = 300;
    public static final int SIZE = 60;
    public static UnitInfo UNIT_INFO = new UnitInfo(800, 300, 60, Art.laserTower, "Laser Tower", "Defensive structure");

    public LaserTower(Game game, Vec2 vec2, int playerID, int unitID, UnitOrder[] startOrders) {
        super(game, vec2, playerID, unitID, startOrders);
        this.sprite = new boolean[1][][];
        this.sprite[0] = Sprite3D.spriteToArray(Art.laserTower);
        this.canAttack = true;
        this.attackRange = 450.0;
        this.reloadTime = 150;
        this.initHealth(400);
        this.size = 60;
    }

    @Override
    protected Projectile newProjectile(Unit target) {
        return new Laser(this.myPlayerID, this.unitID, this.pos.clone(), target.pos.clone(), this.game, Laser.LaserType.GREEN);
    }
}

